/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.misc;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.storage.ILocalStorage;
import thebetweenlands.api.storage.ILocalStorageHandler;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.world.gen.feature.structure.WorldGenSludgeWormDungeon;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.LocationStorage;

public class TestItemChimpRuler
extends Item {
    public TestItemChimpRuler() {
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flag) {
        if (this.hasTag(stack) && stack.func_77978_p().func_74764_b("homeX")) {
            list.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.bl.chimp_ruler.homex", new Object[]{stack.func_77978_p().func_74762_e("homeX")}).func_150254_d());
            list.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.bl.chimp_ruler.homey", new Object[]{stack.func_77978_p().func_74762_e("homeY")}).func_150254_d());
            list.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.bl.chimp_ruler.homez", new Object[]{stack.func_77978_p().func_74762_e("homeZ")}).func_150254_d());
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.hasTag(stack) && player.func_70093_af() && hand.equals((Object)EnumHand.MAIN_HAND)) {
            Block block = world.func_180495_p(pos).func_177230_c();
            if (!world.field_72995_K && block != null) {
                stack.func_77978_p().func_74768_a("homeX", pos.func_177958_n());
                stack.func_77978_p().func_74768_a("homeY", pos.func_177956_o());
                stack.func_77978_p().func_74768_a("homeZ", pos.func_177952_p());
                return EnumActionResult.SUCCESS;
            }
        }
        if (this.hasTag(stack) && stack.func_77978_p().func_74764_b("homeX") && !player.func_70093_af() && hand.equals((Object)EnumHand.MAIN_HAND)) {
            IBlockState state = world.func_180495_p(pos);
            if (!world.field_72995_K && state.func_177230_c() != null) {
                int x = pos.func_177958_n() - stack.func_77978_p().func_74762_e("homeX");
                int y = pos.func_177956_o() - stack.func_77978_p().func_74762_e("homeY");
                int z = pos.func_177952_p() - stack.func_77978_p().func_74762_e("homeZ");
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.chimp_ruler_x", new Object[]{x}), false);
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.chimp_ruler_y", new Object[]{y}), false);
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.chimp_ruler_z", new Object[]{z}), false);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.FAIL;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (!worldIn.field_72995_K && handIn == EnumHand.OFF_HAND) {
            ItemStack stack = playerIn.func_184586_b(handIn);
            int x = stack.func_77978_p().func_74762_e("homeX");
            int y = stack.func_77978_p().func_74762_e("homeY");
            int z = stack.func_77978_p().func_74762_e("homeZ");
            BlockPos home = new BlockPos(x, y, z);
            this.doUseAction(worldIn, playerIn, home);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    protected void doUseAction(World world, EntityPlayer player, BlockPos home) {
        BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(world);
        ILocalStorageHandler handler = worldStorage.getLocalStorageHandler();
        handler.getLocalStorages(LocationStorage.class, new AxisAlignedBB(home.func_177982_a(-80, -80, -80), home.func_177982_a(80, 80, 80)), l -> true).forEach(l -> handler.removeLocalStorage((ILocalStorage)l));
        new WorldGenSludgeWormDungeon().generateLocations(world, world.field_73012_v, home);
    }

    public static boolean CopytoClipboard(String string) {
        try {
            StringSelection selection = new StringSelection(string);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, selection);
            return true;
        }
        catch (Exception e) {
            System.out.println("Poo-poo, pee-pee bum.");
            return false;
        }
    }

    private boolean hasTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            return false;
        }
        return true;
    }

    public CreativeTabs func_77640_w() {
        return BetweenlandsConfig.DEBUG.debug ? BLCreativeTabs.SPECIALS : null;
    }
}

