/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.tools;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.handler.ItemTooltipHandler;
import thebetweenlands.common.item.BLMaterialRegistry;
import thebetweenlands.common.item.tools.ItemGreataxe;

public class ItemAncientBattleAxe
extends ItemGreataxe {
    public ItemAncientBattleAxe(Item.ToolMaterial material) {
        super(material);
        this.func_77656_e(material.func_77997_a());
    }

    public ItemAncientBattleAxe() {
        this(BLMaterialRegistry.TOOL_VALONITE);
    }

    @Override
    protected double getBlockBreakReach(EntityLivingBase entity, ItemStack stack) {
        return stack.func_77952_i() == stack.func_77958_k() ? 0.0 : 3.0;
    }

    @Override
    protected double getBlockBreakHalfAngle(EntityLivingBase entity, ItemStack stack) {
        return stack.func_77952_i() == stack.func_77958_k() ? 0.0 : 55.0;
    }

    @Override
    protected float getSwingSpeedMultiplier(EntityLivingBase entity, ItemStack stack) {
        return 0.225f;
    }

    @Override
    protected double getAoEReach(EntityLivingBase entityLiving, ItemStack stack) {
        return 2.2;
    }

    @Override
    public double getReach() {
        return 3.5;
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND && stack.func_77952_i() == stack.func_77958_k()) {
            HashMultimap map = HashMultimap.create();
            map.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", -1.0, 1));
            return map;
        }
        Multimap<String, AttributeModifier> multimap = super.getAttributeModifiers(equipmentSlot, stack);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.removeAll((Object)SharedMonsterAttributes.field_188790_f.func_111108_a());
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", -3.0, 0));
        }
        return multimap;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77952_i() == stack.func_77958_k()) {
            tooltip.addAll(ItemTooltipHandler.splitTooltip(I18n.func_135052_a((String)"tooltip.bl.tool.broken", (Object[])new Object[]{stack.func_82833_r()}), 0));
        }
    }

    public void setDamage(ItemStack stack, int damage) {
        int maxDamage = stack.func_77958_k();
        if (damage > maxDamage) {
            damage = maxDamage;
        }
        super.setDamage(stack, damage);
    }

    @Override
    public int getMinRepairFuelCost(ItemStack stack) {
        return BLMaterialRegistry.getMinRepairFuelCost(BLMaterialRegistry.TOOL_LOOT);
    }

    @Override
    public int getFullRepairFuelCost(ItemStack stack) {
        return BLMaterialRegistry.getFullRepairFuelCost(BLMaterialRegistry.TOOL_LOOT);
    }

    @Override
    public int getMinRepairLifeCost(ItemStack stack) {
        return BLMaterialRegistry.getMinRepairLifeCost(BLMaterialRegistry.TOOL_LOOT);
    }

    @Override
    public int getFullRepairLifeCost(ItemStack stack) {
        return BLMaterialRegistry.getFullRepairLifeCost(BLMaterialRegistry.TOOL_LOOT);
    }

    @Override
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }
}

