/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.tools;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.event.ArmSwingSpeedEvent;
import thebetweenlands.api.item.IExtendedReach;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.item.BLMaterialRegistry;
import thebetweenlands.common.item.tools.ItemBLSword;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.util.NBTHelper;

public class ItemGreatsword
extends ItemBLSword
implements IExtendedReach {
    protected static final String NBT_SWING_START_COOLDOWN = "swingStartCooldownState";
    protected static final String NBT_HIT_COOLDOWN = "hitCooldownState";
    protected static final String NBT_SWING_START_TICKS = "swingStartTicks";
    protected static final String NBT_LONG_SWING_STATE = "longSwingState";
    private static boolean renderingHand = false;

    public ItemGreatsword(Item.ToolMaterial mat) {
        super(mat);
        this.func_77637_a(BLCreativeTabs.GEARS);
    }

    public ItemGreatsword() {
        this(BLMaterialRegistry.TOOL_VALONITE);
    }

    protected double getAoEReach(EntityLivingBase entityLiving, ItemStack stack) {
        return 2.8;
    }

    protected double getAoEHalfAngle(EntityLivingBase entityLiving, ItemStack stack) {
        return 45.0;
    }

    @Override
    public void onLeftClick(EntityPlayer player, ItemStack stack) {
        boolean enemiesInReach = false;
        if (!player.field_70170_p.field_72995_K && !player.field_82175_bq) {
            stack.func_77983_a(NBT_SWING_START_COOLDOWN, (NBTBase)new NBTTagFloat(player.func_184825_o(0.0f)));
            stack.func_77983_a(NBT_SWING_START_TICKS, (NBTBase)new NBTTagInt(player.field_70173_aa));
            stack.func_77983_a(NBT_LONG_SWING_STATE, (NBTBase)new NBTTagByte(1));
        }
        double aoeReach = this.getAoEReach((EntityLivingBase)player, stack);
        double aoeHalfAngle = this.getAoEHalfAngle((EntityLivingBase)player, stack);
        IAttributeInstance attackSpeed = player.func_110148_a(SharedMonsterAttributes.field_188790_f);
        double baseAttackSpeed = attackSpeed.func_111125_b();
        Collection attackSpeedModifiers = attackSpeed.func_111122_c();
        for (AttributeModifier modifier : attackSpeedModifiers) {
            attackSpeed.func_111124_b(modifier);
        }
        float initialAttackStrength = Math.max(player.func_184825_o(0.5f), NBTHelper.getStackNBTSafe(stack).func_74760_g(NBT_HIT_COOLDOWN));
        List others = player.field_70170_p.func_72872_a(EntityLivingBase.class, player.func_174813_aQ().func_186662_g(aoeReach));
        block1: for (EntityLivingBase target : others) {
            if (target == player) continue;
            Entity[] parts = target.func_70021_al();
            for (int i = 0; i < 1 + (parts != null ? parts.length : 0); ++i) {
                double angle;
                Object part = i == 0 ? target : parts[i - 1];
                double dist = part.func_70032_d((Entity)player);
                if (!(dist < aoeReach) || !((angle = Math.min(Math.toDegrees(Math.acos(part.func_174791_d().func_178788_d(player.func_174791_d()).func_72432_b().func_72430_b(player.func_70040_Z()))), Math.min(Math.toDegrees(Math.acos(part.func_174791_d().func_178788_d(player.func_174824_e(1.0f)).func_72432_b().func_72430_b(player.func_70040_Z()))), Math.toDegrees(Math.acos(part.func_174791_d().func_72441_c(0.0, (double)(part.field_70131_O / 2.0f), 0.0).func_178788_d(player.func_174824_e(1.0f)).func_72432_b().func_72430_b(player.func_70040_Z())))))) < aoeHalfAngle)) continue;
                double distXZ = Math.sqrt((part.field_70165_t - player.field_70165_t) * (part.field_70165_t - player.field_70165_t) + (part.field_70161_v - player.field_70161_v) * (part.field_70161_v - player.field_70161_v));
                double hitY = player.field_70163_u + (double)player.func_70047_e() + player.func_70040_Z().field_72448_b / Math.sqrt(Math.pow(player.func_70040_Z().field_72450_a, 2.0) + Math.pow(player.func_70040_Z().field_72449_c, 2.0) + 0.1) * distXZ;
                if (!(hitY > part.func_174813_aQ().field_72338_b - 0.25) || !(hitY < part.func_174813_aQ().field_72337_e + 0.25) || player.field_70170_p.func_147447_a(player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0), part.func_174791_d().func_72441_c(0.0, (double)(part.field_70131_O / 2.0f), 0.0), false, true, false) != null) continue;
                if (!player.field_70170_p.field_72995_K) {
                    player.func_184821_cY();
                    attackSpeed.func_111128_a((double)(20.0f * initialAttackStrength / 0.5f));
                    player.func_71059_n((Entity)target);
                }
                enemiesInReach = true;
                continue block1;
            }
        }
        attackSpeed.func_111128_a(baseAttackSpeed);
        for (AttributeModifier modifier : attackSpeedModifiers) {
            if (attackSpeed.func_180374_a(modifier)) continue;
            attackSpeed.func_111121_a(modifier);
        }
        if (player.field_70170_p.field_72995_K && (!player.field_82175_bq || player.field_110158_av >= player.func_82166_i() / 2 || player.field_110158_av < 0)) {
            this.playSwingSound(player, stack);
            if (enemiesInReach) {
                this.playSliceSound(player, stack);
            }
        }
        stack.func_77983_a(NBT_HIT_COOLDOWN, (NBTBase)new NBTTagFloat(0.0f));
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity holder, int slot, boolean isHeldItem) {
        super.func_77663_a(stack, world, holder, slot, isHeldItem);
        if (!world.field_72995_K) {
            boolean swingInProgress = this.isLongSwingInProgress(stack);
            boolean newSwingInProgress = false;
            if (holder instanceof EntityLivingBase && ((EntityLivingBase)holder).func_184614_ca() == stack) {
                int ticksElapsed = holder.field_70173_aa - this.getSwingStartTicks(stack);
                boolean bl = newSwingInProgress = ticksElapsed >= 0 && (float)ticksElapsed < this.getLongSwingDuration((EntityLivingBase)holder, stack);
            }
            if (swingInProgress != newSwingInProgress) {
                stack.func_77983_a(NBT_LONG_SWING_STATE, (NBTBase)new NBTTagByte(newSwingInProgress ? (byte)1 : 0));
            }
        }
    }

    protected float getSwingStartCooledAttackStrength(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b(NBT_SWING_START_COOLDOWN, 5)) {
            return tag.func_74760_g(NBT_SWING_START_COOLDOWN);
        }
        return 0.0f;
    }

    protected int getSwingStartTicks(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b(NBT_SWING_START_TICKS, 3)) {
            return tag.func_74762_e(NBT_SWING_START_TICKS);
        }
        return 0;
    }

    protected boolean isLongSwingInProgress(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b(NBT_LONG_SWING_STATE, 1)) {
            return tag.func_74767_n(NBT_LONG_SWING_STATE);
        }
        return false;
    }

    protected float getLongSwingDuration(EntityLivingBase entity, ItemStack stack) {
        return (float)entity.func_82166_i() / 3.0f / this.getSwingSpeedMultiplier(entity, stack);
    }

    protected void playSwingSound(EntityPlayer player, ItemStack stack) {
        player.field_70170_p.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, (SoundEvent)SoundRegistry.LONG_SWING, SoundCategory.PLAYERS, 1.2f, 0.925f * ((0.65f + this.getSwingSpeedMultiplier((EntityLivingBase)player, stack)) * 0.66f + 0.33f) + player.field_70170_p.field_73012_v.nextFloat() * 0.15f);
    }

    protected void playSliceSound(EntityPlayer player, ItemStack stack) {
        player.field_70170_p.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, (SoundEvent)SoundRegistry.LONG_SLICE, SoundCategory.PLAYERS, 1.2f, 0.925f * ((0.65f + this.getSwingSpeedMultiplier((EntityLivingBase)player, stack)) * 0.66f + 0.33f) + player.field_70170_p.field_73012_v.nextFloat() * 0.15f);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        target.func_70653_a((Entity)attacker, 0.8f, (double)MathHelper.func_76126_a((float)(attacker.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(attacker.field_70177_z * ((float)Math.PI / 180)))));
        return super.func_77644_a(stack, target, attacker);
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap<String, AttributeModifier> modifiers = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            modifiers.removeAll((Object)SharedMonsterAttributes.field_188790_f.func_111108_a());
            modifiers.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.5, 0));
        }
        return modifiers;
    }

    @Override
    public int getMinRepairFuelCost(ItemStack stack) {
        return BLMaterialRegistry.getMinRepairFuelCost(BLMaterialRegistry.TOOL_LEGEND);
    }

    @Override
    public int getFullRepairFuelCost(ItemStack stack) {
        return BLMaterialRegistry.getFullRepairFuelCost(BLMaterialRegistry.TOOL_LEGEND);
    }

    @Override
    public int getMinRepairLifeCost(ItemStack stack) {
        return BLMaterialRegistry.getMinRepairLifeCost(BLMaterialRegistry.TOOL_LEGEND);
    }

    @Override
    public int getFullRepairLifeCost(ItemStack stack) {
        return BLMaterialRegistry.getFullRepairLifeCost(BLMaterialRegistry.TOOL_LEGEND);
    }

    @Override
    public double getReach() {
        return 5.5;
    }

    protected float getSwingSpeedMultiplier(EntityLivingBase entity, ItemStack stack) {
        return 0.35f;
    }

    protected boolean doesBlockShieldUse(EntityLivingBase entity, ItemStack stack) {
        return true;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    @SubscribeEvent
    public static void onAttack(AttackEntityEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = player.func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemGreatsword) {
            stack.func_77983_a(NBT_HIT_COOLDOWN, (NBTBase)new NBTTagFloat(Math.max(NBTHelper.getStackNBTSafe(stack).func_74760_g(NBT_HIT_COOLDOWN), player.func_184825_o(0.5f))));
        }
    }

    @SubscribeEvent
    public static void onStartUsingItem(LivingEntityUseItemEvent.Start event) {
        if (ItemGreatsword.handleItemUse(event.getEntityLiving(), event.getItem())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onStartUsingItem(PlayerInteractEvent.RightClickItem event) {
        if (ItemGreatsword.handleItemUse(event.getEntityLiving(), event.getEntityLiving().func_184586_b(event.getHand()))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onItemUsing(LivingEntityUseItemEvent.Tick event) {
        if (ItemGreatsword.handleItemUse(event.getEntityLiving(), event.getItem())) {
            event.setCanceled(true);
        }
    }

    private static boolean handleItemUse(EntityLivingBase entity, ItemStack useStack) {
        if (!useStack.func_190926_b() && useStack.func_77973_b().isShield(useStack, entity)) {
            for (EnumHand hand : EnumHand.values()) {
                ItemStack stack = entity.func_184586_b(hand);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemGreatsword) || !((ItemGreatsword)stack.func_77973_b()).doesBlockShieldUse(entity, stack)) continue;
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onArmSwingSpeed(ArmSwingSpeedEvent event) {
        ItemStack stack;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.field_82175_bq && entity.field_184622_au != null && !(stack = entity.func_184586_b(entity.field_184622_au)).func_190926_b() && stack.func_77973_b() instanceof ItemGreatsword) {
            event.setSpeed(event.getSpeed() * ((ItemGreatsword)stack.func_77973_b()).getSwingSpeedMultiplier(entity, stack));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRenderHand(RenderSpecificHandEvent event) {
        ItemStack stack;
        if (!renderingHand && !(stack = event.getItemStack()).func_190926_b() && stack.func_77973_b() instanceof ItemGreatsword) {
            event.setCanceled(true);
            renderingHand = true;
            try {
                GlStateManager.func_179094_E();
                float drive = event.getSwingProgress();
                float driveScale = 0.05f;
                float drivePow = 2.0f;
                drive = (float)(1.0 - Math.pow((1.0f - drive) * driveScale, drivePow) / Math.pow(driveScale, drivePow));
                float xOff = -0.65f;
                float yOff = 1.0f;
                float zOff = 0.85f;
                float leftMove = (float)Math.sin((double)drive * Math.PI);
                float roll = (float)Math.sin(Math.min((double)drive * Math.PI * 2.0, 1.5707963267948966));
                float roll2 = drive > 0.75f ? (float)Math.pow(Math.sin((double)(drive - 0.75f) * Math.PI * 2.0), 3.0) : 0.0f;
                float yaw = (float)Math.sin((double)drive * Math.PI);
                GlStateManager.func_179109_b((float)(leftMove * -1.2f), (float)(leftMove * 0.7f - event.getEquipProgress() * 0.2f), (float)0.0f);
                GlStateManager.func_179109_b((float)(-xOff), (float)(-yOff), (float)(-zOff));
                GlStateManager.func_179114_b((float)(roll * -90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)(yaw * -190.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(roll2 * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)xOff, (float)yOff, (float)zOff);
                float equipProg = 0.0f;
                float swingProg = 0.0f;
                if (!ForgeHooksClient.renderSpecificFirstPersonHand((EnumHand)event.getHand(), (float)event.getPartialTicks(), (float)event.getInterpolatedPitch(), (float)swingProg, (float)equipProg, (ItemStack)event.getItemStack())) {
                    Minecraft mc = Minecraft.func_71410_x();
                    mc.func_175597_ag().func_187457_a((AbstractClientPlayer)mc.field_71439_g, event.getPartialTicks(), event.getInterpolatedPitch(), event.getHand(), swingProg, event.getItemStack(), equipProg);
                }
                GlStateManager.func_179121_F();
            }
            finally {
                renderingHand = false;
            }
        }
    }
}

