/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.recipe.censer;

import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.block.ICenser;
import thebetweenlands.api.capability.IDecayCapability;
import thebetweenlands.api.recipes.ICenserRecipe;
import thebetweenlands.common.capability.decay.DecayStats;
import thebetweenlands.common.recipe.censer.AbstractCenserRecipe;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.common.registries.ItemRegistry;

public class CenserRecipeSapBall
extends AbstractCenserRecipe<Void> {
    private static final ResourceLocation ID = new ResourceLocation("thebetweenlands", "sap_ball");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public boolean matchesInput(ItemStack stack) {
        return stack.func_77973_b() == ItemRegistry.SAP_BALL;
    }

    private List<EntityLivingBase> getAffectedEntities(World world, BlockPos pos) {
        return world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(pos).func_72314_b(32.0, 1.0, 32.0).func_72321_a(0.0, 16.0, 0.0));
    }

    @Override
    public int update(Void context, ICenser censer) {
        World world = censer.getCenserWorld();
        if (!world.field_72995_K && world.func_82737_E() % 100L == 0L) {
            boolean applied = false;
            BlockPos pos = censer.getCenserPos();
            List<EntityLivingBase> affected = this.getAffectedEntities(world, pos);
            for (EntityLivingBase living : affected) {
                DecayStats stats;
                IDecayCapability cap = (IDecayCapability)living.getCapability(CapabilityRegistry.CAPABILITY_DECAY, null);
                if (cap == null || (stats = cap.getDecayStats()).getDecayLevel() <= 0) continue;
                stats.addStats(-1, 0.0f);
                applied = true;
            }
            if (applied) {
                return 500;
            }
        }
        return 0;
    }

    @Override
    public int getConsumptionAmount(Void context, ICenser censer) {
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getEffectColor(Void context, ICenser censer, ICenserRecipe.EffectColorType type) {
        return -3571712;
    }
}

