/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.biome.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import thebetweenlands.common.world.gen.ChunkGeneratorBetweenlands;
import thebetweenlands.common.world.gen.biome.BiomeWeights;
import thebetweenlands.common.world.gen.biome.feature.BiomeFeature;
import thebetweenlands.common.world.gen.biome.generator.BiomeGenerator;

public class Marsh1Feature
extends BiomeFeature {
    protected NoiseGeneratorPerlin islandNoiseGen;
    protected double[] islandNoise = new double[256];
    protected NoiseGeneratorPerlin fuzzNoiseGen;
    protected double[] fuzzNoise = new double[256];

    @Override
    public void initializeGenerators(long seed, Biome biome) {
        Random rng = new Random(seed);
        this.islandNoiseGen = new NoiseGeneratorPerlin(rng, 4);
        this.fuzzNoiseGen = new NoiseGeneratorPerlin(rng, 8);
    }

    @Override
    public void generateNoise(int chunkX, int chunkZ, Biome biome) {
        this.islandNoise = this.islandNoiseGen.func_151599_a(this.islandNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, 0.16, 0.16, 1.0);
        this.fuzzNoise = this.fuzzNoiseGen.func_151599_a(this.fuzzNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, 10.5, 10.5, 1.0);
    }

    @Override
    public void replaceStackBlocks(int x, int z, double baseBlockNoise, ChunkPrimer chunkPrimer, ChunkGeneratorBetweenlands chunkGenerator, Biome[] biomesForGeneration, Biome biome, BiomeWeights biomeWeights, BiomeGenerator.EnumGeneratorPass pass) {
        if (pass == BiomeGenerator.EnumGeneratorPass.PRE_REPLACE_BIOME_BLOCKS) {
            float biomeWeight = biomeWeights.get(x, z, 0.0f, 5.0f);
            double noise = (this.islandNoise[x * 16 + z] / (double)1.4f + this.fuzzNoise[x * 16 + z] / (double)1.4f) * Math.pow(biomeWeight, 4.0) + (double)1.8f;
            int layerHeight = 120;
            if (noise <= 0.0 && chunkPrimer.func_177856_a(x, layerHeight, z).func_177230_c() == chunkGenerator.layerBlock) {
                int y;
                int waterHeight = 2;
                int yOff = 0;
                while (yOff < layerHeight) {
                    y = layerHeight - yOff;
                    waterHeight = yOff++;
                    Block currentBlock = chunkPrimer.func_177856_a(x, y, z).func_177230_c();
                    if (currentBlock != chunkGenerator.layerBlock) break;
                    chunkPrimer.func_177855_a(x, y, z, chunkGenerator.baseBlockState);
                }
                for (yOff = waterHeight; yOff > 0; --yOff) {
                    y = layerHeight - yOff;
                    chunkPrimer.func_177855_a(x, y, z, chunkGenerator.baseBlockState);
                }
            }
        }
    }
}

