/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature.structure;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.api.storage.LocalRegion;
import thebetweenlands.api.storage.StorageUUID;
import thebetweenlands.common.block.structure.BlockMobSpawnerBetweenlands;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.tile.spawner.MobSpawnerLogicBetweenlands;
import thebetweenlands.common.world.gen.biome.decorator.DecorationHelper;
import thebetweenlands.common.world.gen.biome.decorator.DecoratorPositionProvider;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.EnumLocationType;
import thebetweenlands.common.world.storage.location.LocationStorage;

public class WorldGenSpawner
extends WorldGenerator {
    private final List<Block> blackListedBlocks = ImmutableList.of((Object)BlockRegistry.BETWEENSTONE_TILES, (Object)BlockRegistry.BETWEENSTONE_BRICK_STAIRS, (Object)BlockRegistry.BETWEENSTONE_BRICKS, (Object)BlockRegistry.BETWEENSTONE_BRICK_SLAB);
    private final double size;
    private int minY = 0;
    private DecoratorPositionProvider positionProvider = new DecoratorPositionProvider().setOffsetXZ(-4, 4).setOffsetY(0, 8);

    public WorldGenSpawner() {
        super(true);
        this.size = 1.0;
    }

    public WorldGenSpawner setMinY(int minY) {
        this.minY = minY;
        return this;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos position) {
        int i;
        BlockPos pos;
        int oy;
        int ox;
        BlockPos center = position;
        if ((position = position.func_177982_a(-8, 0, -8)).func_177956_o() <= 4 + this.minY) {
            return false;
        }
        position = position.func_177979_c(4);
        for (int xx = 0; xx < 16; ++xx) {
            for (int zz = 0; zz < 16; ++zz) {
                for (int yy = 0; yy < 8; ++yy) {
                    BlockPos pos2 = position.func_177982_a(xx, yy, zz);
                    if (world.func_175667_e(pos2) && !this.blackListedBlocks.contains(world.func_180495_p(pos2).func_177230_c())) continue;
                    return false;
                }
            }
        }
        boolean canGenerateNearCave = rand.nextInt(8) == 0;
        boolean[] isInBlob = new boolean[4096];
        int blobs = rand.nextInt(32) + 16;
        for (int blob = 0; blob < blobs; ++blob) {
            double sx = (rand.nextDouble() * 6.0 + 3.0) * this.size;
            double sy = (rand.nextDouble() * 6.0 + 3.0 + (double)(rand.nextInt(12) == 0 ? 8 : 0)) * this.size;
            double sz = (rand.nextDouble() * 6.0 + 3.0) * this.size;
            double bx = rand.nextDouble() * (16.0 - sx - 2.0) + 1.0 + sx / 2.0;
            double by = rand.nextDouble() * (8.0 - sy - 4.0) + 2.0 + sy / 2.0;
            double bz = rand.nextDouble() * (16.0 - sz - 2.0) + 1.0 + sz / 2.0;
            for (int ox2 = 1; ox2 < 15; ++ox2) {
                for (int oz = 1; oz < 15; ++oz) {
                    for (int oy2 = 1; oy2 < 15; ++oy2) {
                        double dx = ((double)ox2 - bx) / (sx / 2.0);
                        double dy = ((double)oy2 - by) / (sy / 2.0);
                        double dz = ((double)oz - bz) / (sz / 2.0);
                        double dst = dx * dx + dy * dy + dz * dz;
                        if (!(dst < 1.0)) continue;
                        isInBlob[(ox2 * 16 + oz) * 16 + oy2] = true;
                    }
                }
            }
        }
        for (ox = 0; ox < 16; ++ox) {
            for (int oz = 0; oz < 16; ++oz) {
                for (oy = 0; oy < 16; ++oy) {
                    boolean isOuterBlock;
                    boolean bl = isOuterBlock = !isInBlob[(ox * 16 + oz) * 16 + oy] && (ox < 15 && isInBlob[((ox + 1) * 16 + oz) * 16 + oy] || ox > 0 && isInBlob[((ox - 1) * 16 + oz) * 16 + oy] || oz < 15 && isInBlob[(ox * 16 + oz + 1) * 16 + oy] || oz > 0 && isInBlob[(ox * 16 + (oz - 1)) * 16 + oy] || oy < 15 && isInBlob[(ox * 16 + oz) * 16 + oy + 1] || oy > 0 && isInBlob[(ox * 16 + oz) * 16 + (oy - 1)]);
                    if (!isOuterBlock) continue;
                    Material material = world.func_180495_p(position.func_177982_a(ox, oy, oz)).func_185904_a();
                    if (!(oy >= 4 && canGenerateNearCave || material != Material.field_151579_a)) {
                        return false;
                    }
                    if (!material.func_76224_d()) continue;
                    return false;
                }
            }
        }
        for (ox = 0; ox < 16; ++ox) {
            for (int oz = 0; oz < 16; ++oz) {
                for (oy = 15; oy >= 0; --oy) {
                    if (!isInBlob[(ox * 16 + oz) * 16 + oy]) continue;
                    this.func_175903_a(world, position.func_177982_a(ox, oy, oz), Blocks.field_150350_a.func_176223_P());
                }
            }
        }
        for (ox = 0; ox < 16; ++ox) {
            for (int oz = 0; oz < 16; ++oz) {
                for (oy = 15; oy >= 0; --oy) {
                    boolean isOuterBlock = !isInBlob[(ox * 16 + oz) * 16 + oy] && (ox < 15 && isInBlob[((ox + 1) * 16 + oz) * 16 + oy] || ox > 0 && isInBlob[((ox - 1) * 16 + oz) * 16 + oy] || oz < 15 && isInBlob[(ox * 16 + oz + 1) * 16 + oy] || oz > 0 && isInBlob[(ox * 16 + (oz - 1)) * 16 + oy] || oy < 15 && isInBlob[(ox * 16 + oz) * 16 + oy + 1] || oy > 0 && isInBlob[(ox * 16 + oz) * 16 + (oy - 1)]);
                    pos = position.func_177982_a(ox, oy, oz);
                    if (!isOuterBlock) continue;
                    if (oy < 2) {
                        if (world.func_180495_p(pos.func_177984_a()).func_185917_h()) {
                            this.func_175903_a(world, pos, BlockRegistry.SWAMP_DIRT.func_176223_P());
                            continue;
                        }
                        this.func_175903_a(world, pos, BlockRegistry.SWAMP_GRASS.func_176223_P());
                        continue;
                    }
                    if (!world.func_180495_p(pos).func_185917_h()) continue;
                    world.func_175656_a(pos, BlockRegistry.BETWEENSTONE.func_176223_P());
                }
            }
        }
        BlockPos spawnerPos = center.func_177982_a(0, -1, 0);
        this.func_175903_a(world, spawnerPos, BlockRegistry.MOB_SPAWNER.func_176223_P());
        BlockMobSpawnerBetweenlands.setRandomMob(world, spawnerPos, rand, new Consumer[0]);
        MobSpawnerLogicBetweenlands logic = BlockMobSpawnerBetweenlands.getLogic(world, spawnerPos);
        if (logic != null) {
            logic.setSpawnRange(6);
            logic.setCheckRange(16.0);
            logic.setSpawnInAir(false);
        }
        boolean bigMushroom = false;
        for (i = 0; i < 40; ++i) {
            pos = center.func_177982_a(rand.nextInt(8) - 4, rand.nextInt(8) - 4, rand.nextInt(8) - 4);
            if (world.func_180495_p(pos.func_177977_b()).func_177230_c() != BlockRegistry.SWAMP_GRASS) continue;
            bigMushroom |= DecorationHelper.GEN_BIG_BULB_CAPPED_MUSHROOM.func_180709_b(world, rand, pos);
        }
        if (!bigMushroom) {
            for (i = 0; i < 8; ++i) {
                pos = center.func_177982_a(rand.nextInt(8) - 4, rand.nextInt(8) - 4, rand.nextInt(8) - 4);
                if (!BlockRegistry.BULB_CAPPED_MUSHROOM.func_176196_c(world, pos)) continue;
                this.func_175903_a(world, pos, BlockRegistry.BULB_CAPPED_MUSHROOM.func_176223_P());
            }
        }
        this.positionProvider.init(world, world.getBiomeForCoordsBody(center), null, rand, center.func_177958_n(), center.func_177956_o(), center.func_177952_p());
        this.positionProvider.setOffsetY(-6, 3);
        this.positionProvider.setOffsetXZ(-8, 8);
        for (i = 0; i < 80; ++i) {
            DecorationHelper.generateWeepingBlue(this.positionProvider);
        }
        for (i = 0; i < 260; ++i) {
            DecorationHelper.generateSwampDoubleTallgrass(this.positionProvider);
        }
        for (i = 0; i < 16; ++i) {
            DecorationHelper.GEN_SWAMP_TALLGRASS.func_180709_b(world, rand, center.func_177982_a(rand.nextInt(8) - 4, rand.nextInt(8) - 4, rand.nextInt(8) - 4));
        }
        this.positionProvider.setOffsetY(0, 8);
        this.positionProvider.setOffsetXZ(-3, 3);
        for (i = 0; i < 80; ++i) {
            DecorationHelper.generateSpeleothemCluster(this.positionProvider);
        }
        BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(world);
        LocationStorage location = new LocationStorage(worldStorage, new StorageUUID(UUID.randomUUID()), LocalRegion.getFromBlockPos(position), "underground_dungeon", EnumLocationType.DUNGEON);
        location.addBounds(new AxisAlignedBB(center).func_72314_b(6.0, 4.0, 6.0));
        location.setLayer(0);
        location.setSeed(rand.nextLong());
        location.setVisible(false);
        location.setDirty(true);
        worldStorage.getLocalStorageHandler().addLocalStorage(location);
        return true;
    }
}

