/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage.location;

import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.storage.ILocalStorage;
import thebetweenlands.api.storage.ILocalStorageHandler;
import thebetweenlands.api.storage.IWorldStorage;
import thebetweenlands.api.storage.LocalRegion;
import thebetweenlands.api.storage.StorageID;
import thebetweenlands.client.render.shader.postprocessing.GroundFog;
import thebetweenlands.client.render.shader.postprocessing.WorldShader;
import thebetweenlands.common.entity.EntitySplodeshroom;
import thebetweenlands.common.entity.EntityTinyWormEggSac;
import thebetweenlands.common.entity.EntityTriggeredFallingBlock;
import thebetweenlands.common.entity.EntityTriggeredSludgeWallJet;
import thebetweenlands.common.entity.mobs.EntityCryptCrawler;
import thebetweenlands.common.entity.mobs.EntityMovingSpawnerHole;
import thebetweenlands.common.entity.mobs.EntityShambler;
import thebetweenlands.common.entity.mobs.EntityWallLamprey;
import thebetweenlands.common.entity.mobs.EntityWallLivingRoot;
import thebetweenlands.common.network.datamanager.GenericDataManager;
import thebetweenlands.common.world.WorldProviderBetweenlands;
import thebetweenlands.common.world.biome.spawning.AreaMobSpawner;
import thebetweenlands.common.world.biome.spawning.BoxMobSpawner;
import thebetweenlands.common.world.biome.spawning.spawners.ConditionalSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.WallSpawnEntry;
import thebetweenlands.common.world.storage.location.EnumLocationType;
import thebetweenlands.common.world.storage.location.LocationAmbience;
import thebetweenlands.common.world.storage.location.LocationGuarded;
import thebetweenlands.common.world.storage.location.LocationStorage;

public class LocationSludgeWormDungeon
extends LocationGuarded {
    protected static final DataParameter<Float> GROUND_FOG_STRENGTH = GenericDataManager.createKey(LocationSludgeWormDungeon.class, DataSerializers.field_187193_c);
    private BlockPos structurePos;
    private final BoxMobSpawner mazeMobSpawner;
    private final BoxMobSpawner walkwaysMobSpawner;
    private boolean defeated = false;
    protected static final int MAX_FLOORS = 7;

    public LocationSludgeWormDungeon(IWorldStorage worldStorage, StorageID id, @Nullable LocalRegion region) {
        super(worldStorage, id, region, "sludge_worm_dungeon", EnumLocationType.SLUDGE_WORM_DUNGEON);
        this.dataManager.register(GROUND_FOG_STRENGTH, Float.valueOf(1.0f));
        this.setAmbience(new LocationAmbience(LocationAmbience.EnumLocationAmbience.SLUDGE_WORM_DUNGEON).setFogColor(new int[]{120, 120, 120}).setFogRange(4.0f, 45.0f).setCaveFog(false));
        this.mazeMobSpawner = new BoxMobSpawner(){
            private boolean[] playerOccupancy = new boolean[7];

            @Override
            protected void updateSpawnerChunks(WorldServer world, Set<ChunkPos> spawnerChunks) {
                super.updateSpawnerChunks(world, spawnerChunks);
                for (int i = 0; i < this.playerOccupancy.length; ++i) {
                    this.playerOccupancy[i] = false;
                }
                for (EntityPlayer player : world.field_73010_i) {
                    int floor = LocationSludgeWormDungeon.this.getFloor(player.func_180425_c());
                    if (floor < 0 || floor >= this.playerOccupancy.length || !LocationSludgeWormDungeon.this.isInside((Entity)player)) continue;
                    this.playerOccupancy[floor] = true;
                }
            }

            @Override
            public boolean isInsideSpawningArea(World world, BlockPos pos, boolean entityCount) {
                if (super.isInsideSpawningArea(world, pos, entityCount)) {
                    int floor = LocationSludgeWormDungeon.this.getFloor(pos);
                    return floor >= 0 && floor < this.playerOccupancy.length && this.playerOccupancy[floor];
                }
                return false;
            }
        };
        this.mazeMobSpawner.setMaxAreaEntities(80);
        this.mazeMobSpawner.setEntityCountFilter(entity -> !(entity instanceof EntityTriggeredFallingBlock));
        this.mazeMobSpawner.addSpawnEntry(new ConditionalSpawnEntry(0, new WallSpawnEntry(0, EntityMovingSpawnerHole.class, EntityMovingSpawnerHole::new, 90), ConditionalSpawnEntry.createSludgeDungeonPredicate(0)).setGroupSize(1, 1).setSpawnCheckRadius(8.0).setSpawningInterval(100).setHostile(true));
        this.mazeMobSpawner.addSpawnEntry(new ConditionalSpawnEntry(1, new AreaMobSpawner.BLSpawnEntry(1, EntityShambler.class, EntityShambler::new, 50), ConditionalSpawnEntry.createSludgeDungeonPredicate(1)).setGroupSize(1, 3).setSpawnCheckRadius(14.0).setSpawningInterval(200).setHostile(true));
        this.mazeMobSpawner.addSpawnEntry(new ConditionalSpawnEntry(2, new WallSpawnEntry(2, EntityWallLamprey.class, EntityWallLamprey::new, 100), ConditionalSpawnEntry.createSludgeDungeonPredicate(2)).setGroupSize(1, 1).setSpawnCheckRadius(8.0).setSpawningInterval(40).setHostile(true));
        this.mazeMobSpawner.addSpawnEntry(new ConditionalSpawnEntry(3, new AreaMobSpawner.BLSpawnEntry(3, EntityTinyWormEggSac.class, EntityTinyWormEggSac::new, 100), ConditionalSpawnEntry.createSludgeDungeonPredicate(2)).setGroupSize(1, 1).setSpawnCheckRadius(8.0).setSpawningInterval(160).setHostile(true));
        this.mazeMobSpawner.addSpawnEntry(new ConditionalSpawnEntry(4, new AreaMobSpawner.BLSpawnEntry(4, EntityTriggeredSludgeWallJet.class, EntityTriggeredSludgeWallJet::new, 100), ConditionalSpawnEntry.createSludgeDungeonPredicate(3)).setGroupSize(1, 1).setSpawnCheckRadius(10.0).setSpawningInterval(40).setHostile(true));
        this.mazeMobSpawner.addSpawnEntry(new ConditionalSpawnEntry(5, new WallSpawnEntry(5, EntityWallLivingRoot.class, EntityWallLivingRoot::new, 100), ConditionalSpawnEntry.createSludgeDungeonPredicate(4)).setGroupSize(1, 1).setSpawnCheckRadius(8.0).setSpawningInterval(40).setHostile(true));
        this.mazeMobSpawner.addSpawnEntry(new ConditionalSpawnEntry(6, new AreaMobSpawner.BLSpawnEntry(6, EntitySplodeshroom.class, EntitySplodeshroom::new, 100), ConditionalSpawnEntry.createSludgeDungeonPredicate(4)).setGroupSize(1, 1).setSpawnCheckRadius(8.0).setSpawningInterval(40).setHostile(true));
        this.mazeMobSpawner.addSpawnEntry(new ConditionalSpawnEntry(7, new AreaMobSpawner.BLSpawnEntry(7, EntityCryptCrawler.class, EntityCryptCrawler::new, 50), ConditionalSpawnEntry.createSludgeDungeonPredicate(5)).setGroupSize(1, 3).setSpawnCheckRadius(12.0).setSpawningInterval(240).setHostile(true));
        this.walkwaysMobSpawner = new BoxMobSpawner();
        this.walkwaysMobSpawner.setMaxAreaEntities(12);
        this.walkwaysMobSpawner.setEntityCountFilter(entity -> !(entity instanceof EntityCryptCrawler));
        this.walkwaysMobSpawner.addSpawnEntry(new AreaMobSpawner.BLSpawnEntry(1, EntityCryptCrawler.class, EntityCryptCrawler::new, 100).setGroupSize(1, 2).setSpawnCheckRadius(8.0).setSpawningInterval(200).setHostile(true));
    }

    public void setStructurePos(BlockPos pos) {
        this.structurePos = pos;
        this.setDirty(true);
    }

    public BlockPos getStructurePos() {
        return this.structurePos;
    }

    public boolean hasGroundFog(BlockPos pos) {
        BlockPos structurePos = this.getStructurePos();
        AxisAlignedBB mazeAabb = new AxisAlignedBB((double)structurePos.func_177958_n(), (double)structurePos.func_177956_o(), (double)structurePos.func_177952_p(), (double)(structurePos.func_177958_n() + 29), (double)(structurePos.func_177956_o() - 40 - 3), (double)(structurePos.func_177952_p() + 29));
        return mazeAabb.func_72326_a(new AxisAlignedBB(pos)) && this.dataManager.get(GROUND_FOG_STRENGTH).floatValue() > 0.01f;
    }

    public void setDefeated(boolean defeated) {
        this.defeated = defeated;
        this.setDirty(true);
    }

    public boolean isDefeated() {
        return this.defeated;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74776_a("groundFogStrength", this.dataManager.get(GROUND_FOG_STRENGTH).floatValue());
        nbt.func_74772_a("structurePos", this.structurePos.func_177986_g());
        nbt.func_74757_a("defeated", this.defeated);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.dataManager.set(GROUND_FOG_STRENGTH, Float.valueOf(nbt.func_74760_g("groundFogStrength")));
        this.structurePos = BlockPos.func_177969_a((long)nbt.func_74763_f("structurePos"));
        this.defeated = nbt.func_74767_n("defeated");
    }

    @Override
    protected void writeSharedNbt(NBTTagCompound nbt) {
        super.writeSharedNbt(nbt);
        nbt.func_74772_a("structurePos", this.structurePos.func_177986_g());
    }

    @Override
    protected void readSharedNbt(NBTTagCompound nbt) {
        super.readSharedNbt(nbt);
        this.structurePos = BlockPos.func_177969_a((long)nbt.func_74763_f("structurePos"));
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        World world = this.getWorldStorage().getWorld();
        if (!world.field_72995_K) {
            float fogStrength = this.dataManager.get(GROUND_FOG_STRENGTH).floatValue();
            if (this.defeated && fogStrength > 0.0f) {
                this.dataManager.set(GROUND_FOG_STRENGTH, Float.valueOf(Math.max(0.0f, fogStrength - 0.01f)));
                this.setDirty(true);
            } else if (!this.defeated && fogStrength < 1.0f) {
                this.dataManager.set(GROUND_FOG_STRENGTH, Float.valueOf(Math.min(1.0f, fogStrength + 0.01f)));
                this.setDirty(true);
            }
        }
        if (!this.defeated && world instanceof WorldServer && world.field_73011_w instanceof WorldProviderBetweenlands && world.func_82736_K().func_82766_b("doMobSpawning") && world.func_82737_E() % 4L == 0L) {
            boolean spawnHostiles = ((WorldProviderBetweenlands)world.field_73011_w).getCanSpawnHostiles();
            boolean spawnAnimals = ((WorldProviderBetweenlands)world.field_73011_w).getCanSpawnAnimals();
            BlockPos pos = this.getStructurePos();
            this.mazeMobSpawner.clearAreas();
            this.mazeMobSpawner.addArea(new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 29), (double)(pos.func_177956_o() - 40 - 3), (double)(pos.func_177952_p() + 29)));
            this.mazeMobSpawner.populate((WorldServer)world, spawnHostiles, spawnAnimals);
            this.walkwaysMobSpawner.clearAreas();
            this.walkwaysMobSpawner.addArea(new AxisAlignedBB((double)(pos.func_177958_n() - 3), (double)(pos.func_177956_o() - 43), (double)(pos.func_177952_p() - 3), (double)pos.func_177958_n(), (double)(pos.func_177956_o() - 24), (double)(pos.func_177952_p() + 29)));
            this.walkwaysMobSpawner.addArea(new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() - 43), (double)(pos.func_177952_p() - 3), (double)(pos.func_177958_n() + 29), (double)(pos.func_177956_o() - 24), (double)pos.func_177952_p()));
            this.walkwaysMobSpawner.populate((WorldServer)world, spawnHostiles, spawnAnimals);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addGroundFogVolumesToShader(WorldShader shader) {
        float globalStrength = this.dataManager.get(GROUND_FOG_STRENGTH).floatValue();
        if (globalStrength > 0.0f) {
            for (int floor = 0; floor < 7; ++floor) {
                float floorStrength = globalStrength / 7.0f * (float)(floor + 1);
                float fogBrightness = 0.25f;
                float inScattering = 0.035f - 0.015f * floorStrength;
                float extinction = 6.0f - 4.2f * floorStrength;
                float height = 4.0f + 8.0f * floorStrength;
                shader.addGroundFogVolume(new GroundFog.GroundFogVolume(new Vec3d((double)this.structurePos.func_177958_n(), (double)this.structurePos.func_177956_o() - 5.2 - (double)(floor * 6), (double)this.structurePos.func_177952_p()), new Vec3d(29.0, (double)height, 29.0), inScattering, extinction, fogBrightness, fogBrightness, fogBrightness));
            }
            return true;
        }
        return false;
    }

    public int getFloor(BlockPos pos) {
        return (this.structurePos.func_177956_o() - 1 - pos.func_177956_o()) / 6;
    }

    public void removeLocations() {
        ILocalStorageHandler handler = this.getWorldStorage().getLocalStorageHandler();
        handler.removeLocalStorage(this);
        handler.getLocalStorages(LocationStorage.class, this.getEnclosingBounds(), l -> l.getType() == EnumLocationType.SLUDGE_WORM_DUNGEON).forEach(location -> handler.removeLocalStorage((ILocalStorage)location));
    }
}

