/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.api;

import aurilux.titles.api.TitleInfo;
import aurilux.titles.api.capability.TitlesImpl;
import aurilux.titles.api.internal.DummyMethodHandler;
import aurilux.titles.api.internal.IInternalMethodHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;

public class TitlesAPI {
    private static final Map<String, TitleInfo> titlesMap = new HashMap<String, TitleInfo>();
    private static final Map<String, TitleInfo> archiveTitles = new HashMap<String, TitleInfo>();
    public static IInternalMethodHandler internalHandler = new DummyMethodHandler();

    public static void registerTitle(String key) {
        TitlesAPI.registerTitle(key, TitleInfo.TitleRarity.COMMON);
    }

    public static void registerTitle(String key, TitleInfo.TitleRarity titleRarity) {
        if (!titleRarity.equals((Object)TitleInfo.TitleRarity.UNIQUE)) {
            titlesMap.put(key, new TitleInfo(key, titleRarity));
        }
    }

    public static void addArchiveTitle(String key, TitleInfo.TitleRarity titleRarity) {
        archiveTitles.put(key, new TitleInfo(key, titleRarity));
    }

    public static Map<String, TitleInfo> getArchiveTitles() {
        return archiveTitles;
    }

    public static void addTitleToPlayer(EntityPlayer player, String key) {
        TitlesAPI.addTitleToPlayer(player, key, false);
    }

    public static void addTitleToPlayer(EntityPlayer player, String key, boolean announce) {
        TitleInfo titleInfo = titlesMap.get(key);
        if (titleInfo == null) {
            titleInfo = archiveTitles.get(key);
        }
        if (titleInfo == null || TitlesAPI.hasTitle(player, titleInfo)) {
            return;
        }
        TitlesAPI.getTitlesCap(player).add(titleInfo);
        if (announce) {
            internalHandler.sendChatMessageToAllPlayers("chat.title.add", player.func_145748_c_(), titleInfo);
        }
    }

    public static void removeTitleFromPlayer(EntityPlayer player, String key) {
        TitleInfo titleInfo = titlesMap.get(key);
        if (titleInfo != null && TitlesAPI.hasTitle(player, titleInfo)) {
            TitlesImpl.DefaultImpl cap = TitlesAPI.getTitlesCap(player);
            cap.remove(titleInfo);
            if (cap.getDisplayTitle().equals(titleInfo)) {
                cap.setDisplayTitle(TitleInfo.NULL_TITLE);
            }
        }
    }

    public static TitleInfo getTitleFromKey(String key) {
        if (key.equals(TitleInfo.NULL_TITLE.getKey())) {
            return TitleInfo.NULL_TITLE;
        }
        if (TitlesAPI.getRegisteredTitles().containsKey(key)) {
            return TitlesAPI.getRegisteredTitles().get(key);
        }
        if (TitlesAPI.getArchiveTitles().containsKey(key)) {
            return TitlesAPI.getArchiveTitles().get(key);
        }
        return internalHandler.getTitleFromKey(key);
    }

    public static TitleInfo getPlayerDisplayTitle(EntityPlayer player) {
        return TitlesAPI.getTitlesCap(player).getDisplayTitle();
    }

    public static void setPlayerDisplayTitle(EntityPlayer player, TitleInfo titleInfo) {
        TitlesAPI.getTitlesCap(player).setDisplayTitle(titleInfo);
    }

    public static boolean hasTitle(EntityPlayer player, TitleInfo titleInfo) {
        return TitlesAPI.getTitlesCap(player).getObtainedTitles().contains(titleInfo);
    }

    public static TitlesImpl.DefaultImpl getTitlesCap(EntityPlayer player) {
        return TitlesImpl.getCapability(player);
    }

    public static Map<String, TitleInfo> getRegisteredTitles() {
        return Collections.unmodifiableMap(titlesMap);
    }
}

