/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.api.capability;

import aurilux.titles.api.TitleInfo;
import aurilux.titles.api.TitlesAPI;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;

public class TitlesImpl {
    @CapabilityInject(value=ITitles.class)
    public static final Capability<ITitles> TITLES_CAPABILITY = null;
    public static final ResourceLocation NAME = new ResourceLocation("titles", "titles");

    public static void register() {
        CapabilityManager.INSTANCE.register(ITitles.class, (Capability.IStorage)new Storage(), DefaultImpl::new);
    }

    public static DefaultImpl getCapability(EntityPlayer player) {
        return (DefaultImpl)player.getCapability(TITLES_CAPABILITY, null);
    }

    public static class Provider
    implements ICapabilitySerializable<NBTTagCompound> {
        private ITitles instance = new DefaultImpl();

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == TITLES_CAPABILITY;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(this.hasCapability(capability, facing) ? TITLES_CAPABILITY.cast((Object)this.instance) : null);
        }

        public NBTTagCompound serializeNBT() {
            return (NBTTagCompound)this.instance.serializeNBT();
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.instance.deserializeNBT((NBTBase)nbt);
        }
    }

    public static class DefaultImpl
    implements ITitles {
        private final String SEL_TITLE = "selected_title";
        private final String OBT_TITLES = "obtained_titles";
        private final String FRAG_COUNT = "fragment_count";
        private Set<TitleInfo> obtainedTitles = new HashSet<TitleInfo>();
        private TitleInfo displayTitle = TitleInfo.NULL_TITLE;
        private int fragmentCount = 0;

        @Override
        public void add(TitleInfo info) {
            this.obtainedTitles.add(info);
        }

        @Override
        public void remove(TitleInfo info) {
            this.obtainedTitles.remove(info);
        }

        @Override
        public Set<TitleInfo> getObtainedTitles() {
            return this.obtainedTitles;
        }

        @Override
        public void setDisplayTitle(TitleInfo newTitle) {
            this.displayTitle = newTitle;
        }

        @Override
        public TitleInfo getDisplayTitle() {
            return this.displayTitle;
        }

        @Override
        public void addFragments(int num) {
            this.fragmentCount += num;
        }

        @Override
        public int getFragmentCount() {
            return this.fragmentCount;
        }

        @Override
        public void setFragmentCount(int count) {
            this.fragmentCount = count;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("fragment_count", this.getFragmentCount());
            nbt.func_74778_a("selected_title", this.getDisplayTitle().getKey());
            NBTTagList obtained = new NBTTagList();
            for (TitleInfo title : this.obtainedTitles) {
                obtained.func_74742_a((NBTBase)new NBTTagString(title.getKey()));
            }
            nbt.func_74782_a("obtained_titles", (NBTBase)obtained);
            return nbt;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.fragmentCount = nbt.func_74762_e("fragment_count");
            this.displayTitle = TitlesAPI.getTitleFromKey(nbt.func_74779_i("selected_title"));
            this.obtainedTitles.clear();
            NBTTagList obtained = nbt.func_150295_c("obtained_titles", 8);
            for (int i = 0; i < obtained.func_74745_c(); ++i) {
                TitleInfo titleInfo = TitlesAPI.getTitleFromKey(obtained.func_150307_f(i));
                if (titleInfo.equals(TitleInfo.NULL_TITLE)) continue;
                this.obtainedTitles.add(titleInfo);
            }
        }
    }

    private static class Storage
    implements Capability.IStorage<ITitles> {
        private Storage() {
        }

        @Nullable
        public NBTBase writeNBT(Capability<ITitles> capability, ITitles instance, EnumFacing side) {
            return null;
        }

        public void readNBT(Capability<ITitles> capability, ITitles instance, EnumFacing side, NBTBase nbt) {
        }
    }

    public static interface ITitles
    extends INBTSerializable<NBTTagCompound> {
        public void add(TitleInfo var1);

        public void remove(TitleInfo var1);

        public Set<TitleInfo> getObtainedTitles();

        public void setDisplayTitle(TitleInfo var1);

        public TitleInfo getDisplayTitle();

        public void addFragments(int var1);

        public int getFragmentCount();

        public void setFragmentCount(int var1);
    }
}

