/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.client.gui;

import aurilux.titles.api.TitleInfo;
import aurilux.titles.api.TitlesAPI;
import aurilux.titles.client.ModKeybindings;
import aurilux.titles.common.init.ContributorLoader;
import aurilux.titles.common.network.PacketDispatcher;
import aurilux.titles.common.network.messages.PacketSyncDisplayTitle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiTitleSelection
extends GuiScreen {
    private final ResourceLocation bgTexture = new ResourceLocation("titles", "textures/gui/titleselection.png");
    private final int numCols = 2;
    private final int numRows = 6;
    protected final int maxPerPage = 12;
    protected int page;
    protected int maxPages;
    private final int RANDOM_BUTTON = 13;
    private final int NONE_BUTTON = 14;
    private final int CANCEL_BUTTON = 15;
    private final int CONFIRM_BUTTON = 16;
    protected final int FIRST_PAGE = 17;
    protected final int PREV_PAGE = 18;
    protected final int NEXT_PAGE = 19;
    protected final int LAST_PAGE = 20;
    private final int xSize = 256;
    private final int ySize = 222;
    protected int guiLeft;
    protected int guiTop;
    protected final int buttonHeight = 20;
    private final int titleButtonWidth = 120;
    private int maxIndex;
    protected int leftOffset;
    protected int buttonFirstRowStart;
    protected int buttonTitleRowStart;
    protected int buttonSecondRowStart;
    protected EntityPlayer player;
    protected TitleInfo temporaryTitle;
    protected List<TitleInfo> titlesList;

    public GuiTitleSelection(EntityPlayer player) {
        this.player = player;
        this.temporaryTitle = TitlesAPI.getPlayerDisplayTitle(player);
        this.titlesList = this.getTitlesList();
    }

    public List<TitleInfo> getTitlesList() {
        String playerName = this.player.func_70005_c_();
        ArrayList<TitleInfo> temp = new ArrayList<TitleInfo>(TitlesAPI.getTitlesCap(this.player).getObtainedTitles());
        if (ContributorLoader.contributorTitleExists(playerName)) {
            temp.add(ContributorLoader.getContributorTitle(playerName));
        }
        Collections.sort(temp, new TitleInfo.RarityComparator());
        return temp;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.page = 0;
        this.maxPages = this.titlesList.size() / 12;
        this.guiLeft = (this.field_146294_l - 256) / 2;
        this.guiTop = (this.field_146295_m - 222) / 2;
        this.leftOffset = this.guiLeft + 8;
        this.buttonFirstRowStart = this.guiTop + 28;
        this.buttonTitleRowStart = this.guiTop + 53;
        this.buttonSecondRowStart = this.guiTop + 176;
        this.updateButtonList();
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.bgTexture);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, 256, 222);
        super.func_73863_a(mouseX, mouseY, f);
        String titledPlayerName = this.player.func_70005_c_();
        titledPlayerName = titledPlayerName + TitlesAPI.internalHandler.getFormattedTitle(this.temporaryTitle, true);
        this.func_73732_a(this.field_146289_q, titledPlayerName, this.field_146294_l / 2, this.guiTop + 11, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, this.page + 1 + "/" + (this.maxPages + 1), this.field_146294_l / 2, this.guiTop + 183, 0xFFFFFF);
        if (this.titlesList.size() == 0) {
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)this.getEmptyMessage(), (Object[])new Object[0]), this.field_146294_l / 2, this.guiTop + 105, 0xFFFFFF);
        }
    }

    protected String getEmptyMessage() {
        return "gui.titles.titleselection.empty";
    }

    protected void exitScreen(boolean update) {
        if (update) {
            PacketDispatcher.INSTANCE.sendToServer((IMessage)new PacketSyncDisplayTitle(this.player.func_110124_au(), this.temporaryTitle.getKey()));
        }
        this.field_146297_k.func_147108_a(null);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.updateButtonList();
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 15: {
                this.exitScreen(false);
                break;
            }
            case 16: {
                this.exitScreen(true);
                break;
            }
            case 13: {
                this.chooseRandomTitle();
                break;
            }
            case 14: {
                this.temporaryTitle = TitleInfo.NULL_TITLE;
                break;
            }
            case 17: {
                this.page = 0;
                break;
            }
            case 18: {
                --this.page;
                break;
            }
            case 19: {
                ++this.page;
                break;
            }
            case 20: {
                this.page = this.maxPages;
                break;
            }
            default: {
                this.temporaryTitle = this.titlesList.get(button.field_146127_k + this.page * 12);
            }
        }
    }

    private void chooseRandomTitle() {
        this.temporaryTitle = this.titlesList.size() <= 0 ? TitleInfo.NULL_TITLE : this.titlesList.get(this.player.field_70170_p.field_73012_v.nextInt(this.titlesList.size()));
    }

    protected void func_73869_a(char c, int ascii) throws IOException {
        super.func_73869_a(c, ascii);
        if (ModKeybindings.OPEN_TITLE_SELECTION.getKeyBinding().func_151463_i() == ascii || this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i() == ascii) {
            this.exitScreen(false);
        }
    }

    protected void updateButtonList() {
        this.field_146292_n.clear();
        this.maxIndex = Math.min((this.page + 1) * 12, this.titlesList.size());
        List<TitleInfo> titlesToDisplay = this.titlesList.subList(this.page * 12, this.maxIndex);
        for (int i = 0; i < titlesToDisplay.size(); ++i) {
            int col = i % 2;
            int row = i / 2;
            this.field_146292_n.add(new GuiButton(i, this.leftOffset + 120 * col, this.buttonTitleRowStart + row * 20, 120, 20, TitlesAPI.internalHandler.getFormattedTitle(titlesToDisplay.get(i))));
        }
        this.addChangeButtons();
        this.field_146292_n.add(new GuiButton(17, this.leftOffset, this.buttonSecondRowStart, 20, 20, "<<"));
        this.field_146292_n.add(new GuiButton(18, this.leftOffset + 22, this.buttonSecondRowStart, 20, 20, "<"));
        if (this.page == 0) {
            ((GuiButton)this.field_146292_n.get((int)(this.field_146292_n.size() - 2))).field_146124_l = false;
            ((GuiButton)this.field_146292_n.get((int)(this.field_146292_n.size() - 1))).field_146124_l = false;
        }
        this.field_146292_n.add(new GuiButton(19, this.leftOffset + 198, this.buttonSecondRowStart, 20, 20, ">"));
        this.field_146292_n.add(new GuiButton(20, this.leftOffset + 220, this.buttonSecondRowStart, 20, 20, ">>"));
        if (this.maxIndex == this.titlesList.size()) {
            ((GuiButton)this.field_146292_n.get((int)(this.field_146292_n.size() - 2))).field_146124_l = false;
            ((GuiButton)this.field_146292_n.get((int)(this.field_146292_n.size() - 1))).field_146124_l = false;
        }
    }

    protected void addChangeButtons() {
        this.field_146292_n.add(new GuiButton(13, this.leftOffset, this.buttonFirstRowStart, 60, 20, I18n.func_135052_a((String)"gui.titles.random", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(14, this.leftOffset + 180, this.buttonFirstRowStart, 60, 20, I18n.func_135052_a((String)"gui.titles.none", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(15, this.leftOffset + 45, this.buttonSecondRowStart, 60, 20, I18n.func_135052_a((String)"gui.titles.cancel", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(16, this.leftOffset + 135, this.buttonSecondRowStart, 60, 20, I18n.func_135052_a((String)"gui.titles.confirm", (Object[])new Object[0])));
    }
}

