/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.handler;

import aurilux.titles.api.TitleInfo;
import aurilux.titles.api.TitlesAPI;
import aurilux.titles.api.capability.TitlesImpl;
import aurilux.titles.common.network.PacketDispatcher;
import aurilux.titles.common.network.messages.PacketSyncAllDisplayTitles;
import aurilux.titles.common.network.messages.PacketSyncDisplayTitle;
import aurilux.titles.common.network.messages.PacketSyncTitleData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber(modid="titles")
public class CommonEventHandler {
    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(TitlesImpl.NAME, (ICapabilityProvider)new TitlesImpl.Provider());
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        NBTTagCompound data = TitlesImpl.getCapability(event.getOriginal()).serializeNBT();
        TitlesImpl.getCapability(event.getEntityPlayer()).deserializeNBT(data);
    }

    @SubscribeEvent
    public static void respawnEvent(PlayerEvent.PlayerRespawnEvent event) {
        EntityPlayer player = event.player;
        PacketDispatcher.INSTANCE.sendTo((IMessage)new PacketSyncTitleData(player), (EntityPlayerMP)player);
        PacketDispatcher.INSTANCE.sendTo((IMessage)new PacketSyncAllDisplayTitles(player), (EntityPlayerMP)player);
    }

    @SubscribeEvent
    public static void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        EntityPlayer player = event.player;
        PacketDispatcher.INSTANCE.sendTo((IMessage)new PacketSyncTitleData(player), (EntityPlayerMP)player);
        PacketDispatcher.INSTANCE.sendTo((IMessage)new PacketSyncAllDisplayTitles(player), (EntityPlayerMP)player);
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        PacketDispatcher.INSTANCE.sendTo((IMessage)new PacketSyncTitleData((EntityPlayer)player), player);
        PacketDispatcher.INSTANCE.sendTo((IMessage)new PacketSyncAllDisplayTitles((EntityPlayer)player), player);
        PacketDispatcher.INSTANCE.sendToAll((IMessage)new PacketSyncDisplayTitle(player.func_110124_au(), TitlesAPI.getPlayerDisplayTitle((EntityPlayer)player).getKey()));
    }

    @SubscribeEvent
    public static void onPlayerNameFormat(PlayerEvent.NameFormat event) {
        TitleInfo currentTitle = TitlesAPI.getPlayerDisplayTitle(event.getEntityPlayer());
        event.setDisplayname(event.getDisplayname() + TitlesAPI.internalHandler.getFormattedTitle(currentTitle, true));
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("titles")) {
            ConfigManager.sync((String)"titles", (Config.Type)Config.Type.INSTANCE);
        }
    }
}

