/*
 * Decompiled with CFR 0.152.
 */
package aurilux.titles.common.init;

import aurilux.titles.api.TitleInfo;
import aurilux.titles.api.TitlesAPI;
import aurilux.titles.common.Titles;
import com.google.common.io.ByteStreams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.io.IOUtils;

@Config(modid="titles", name="Titles/titles_config")
@Mod.EventBusSubscriber(modid="titles")
public class ModConfig {
    @Config.Comment(value={"Set to false if you do not want archive fragments to be added to loot"})
    public static boolean addFragmentsToLoot = true;
    private static final List<String> defaultTitles = Arrays.asList("archive.json", "titles.json", "minecraft.json");
    private static File configDir;

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("titles")) {
            ConfigManager.sync((String)"titles", (Config.Type)Config.Type.INSTANCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(FMLPreInitializationEvent event) {
        configDir = new File(event.getModConfigurationDirectory(), "titles");
        if (!configDir.exists()) {
            configDir.mkdir();
        }
        for (String fileName : defaultTitles) {
            File defaultTitleFile = new File(configDir, fileName);
            if (defaultTitleFile.exists()) continue;
            InputStream inputStream = null;
            FileOutputStream outputStream = null;
            try {
                inputStream = ModConfig.class.getResourceAsStream("/assets/titles/default_data/" + fileName);
                outputStream = new FileOutputStream(defaultTitleFile);
                ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                continue;
            }
            finally {
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly(outputStream);
                continue;
            }
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadTitles() {
        for (File titleFile : configDir.listFiles()) {
            String fileName = titleFile.getName();
            if (!fileName.endsWith(".json")) continue;
            JsonObject jsonObject = null;
            try {
                jsonObject = new JsonParser().parse((Reader)new FileReader(titleFile)).getAsJsonObject();
            }
            catch (IOException | IllegalArgumentException e) {
                Titles.LOGGER.warn("Unable to load titles. Either the file doesn't exist or the format is wrong.");
            }
            finally {
                if (jsonObject == null) continue;
                for (Map.Entry entry : jsonObject.entrySet()) {
                    TitleInfo.TitleRarity titleRarity = TitleInfo.TitleRarity.valueOf(((String)entry.getKey()).toUpperCase());
                    if (titleRarity.equals((Object)TitleInfo.TitleRarity.UNIQUE)) continue;
                    JsonArray titles = ((JsonElement)entry.getValue()).getAsJsonArray();
                    for (int i = 0; i < titles.size(); ++i) {
                        String key = titles.get(i).getAsString();
                        String modid = fileName.substring(0, fileName.indexOf("."));
                        if (modid.equals("archive")) {
                            TitlesAPI.addArchiveTitle(key, titleRarity);
                            continue;
                        }
                        TitlesAPI.registerTitle(modid + ":" + key, titleRarity);
                    }
                }
            }
        }
    }
}

