/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.handlers;

import com.tiviacz.travelersbackpack.handlers.ConfigHandler;
import com.tiviacz.travelersbackpack.handlers.LootHandler;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.items.ItemTravelersBackpack;
import com.tiviacz.travelersbackpack.util.IHasModel;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="travelersbackpack")
public class CommonEventHandler {
    @SubscribeEvent
    public static void onItemRegister(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModItems.ITEMS.toArray(new Item[0]));
    }

    @SubscribeEvent
    public static void onBlockRegister(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModBlocks.BLOCKS.toArray(new Block[0]));
    }

    @SubscribeEvent
    public static void onModelRegister(ModelRegistryEvent event) {
        for (Item item : ModItems.ITEMS) {
            if (!(item instanceof IHasModel)) continue;
            ((IHasModel)item).registerModels();
        }
        for (Block block : ModBlocks.BLOCKS) {
            if (!(block instanceof IHasModel)) continue;
            ((IHasModel)block).registerModels();
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("travelersbackpack")) {
            ConfigManager.sync((String)"travelersbackpack", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        for (int i = 0; i < event.getAffectedEntities().size(); ++i) {
            Entity entity = (Entity)event.getAffectedEntities().get(i);
            if (!(entity instanceof EntityItem) || !(((EntityItem)entity).func_92059_d().func_77973_b() instanceof ItemTravelersBackpack)) continue;
            event.getAffectedEntities().remove(i);
        }
    }

    @SubscribeEvent
    public static void addBackpackToLootTable(LootTableLoadEvent event) {
        if (ConfigHandler.server.enableLoot) {
            ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
            list.add(LootTableList.field_186428_j);
            list.add(LootTableList.field_186427_i);
            list.add(LootTableList.field_186426_h);
            CommonEventHandler.addLoot(event.getName(), LootTableList.field_186424_f, 2, "bat", event.getTable());
            CommonEventHandler.addLoot(event.getName(), LootTableList.field_186423_e, 11, "irongolem", event.getTable());
            list.forEach(loc -> CommonEventHandler.addLoot(event.getName(), loc, 25, "deluxe", event.getTable()));
        }
    }

    public static void addLoot(ResourceLocation name, ResourceLocation targetName, int meta, String backpackName, LootTable table) {
        if (name.equals((Object)targetName)) {
            ItemStack stack = new ItemStack(ModItems.TRAVELERS_BACKPACK, 1, meta);
            LootEntryItem entry = LootHandler.createItemEntry(stack, 3, 0, "loot_travelers_backpack_" + backpackName);
            table.getPool("main").addEntry((LootEntry)entry);
        }
    }
}

