/*
 * Decompiled with CFR 0.152.
 */
package uniquee.enchantments.simple;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentDamage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.common.config.Configuration;
import uniquee.enchantments.IToggleEnchantment;
import uniquee.enchantments.UniqueEnchantment;

public class EnchantmentAdvancedDamage
extends EnchantmentDamage
implements IToggleEnchantment {
    public static final UniqueEnchantment.DefaultData[] DATA = new UniqueEnchantment.DefaultData[]{new UniqueEnchantment.DefaultData("all", Enchantment.Rarity.VERY_RARE, true, 20, 2, 18), new UniqueEnchantment.DefaultData("undead", Enchantment.Rarity.RARE, true, 16, 2, 14), new UniqueEnchantment.DefaultData("arthropods", Enchantment.Rarity.RARE, true, 16, 2, 14)};
    private static final float[] DEFAULTS = new float[]{1.0f, 3.0f, 3.0f};
    UniqueEnchantment.DefaultData defaults;
    UniqueEnchantment.DefaultData actualData;
    public float scalar;
    boolean isEnabled = true;

    public EnchantmentAdvancedDamage(int damageTypeIn) {
        super(DATA[damageTypeIn].getRarity(), damageTypeIn, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        this.setRegistryName(DATA[damageTypeIn].getName());
        this.actualData = this.defaults = DATA[damageTypeIn];
        this.scalar = DEFAULTS[damageTypeIn];
    }

    public float func_152376_a(int level, EnumCreatureAttribute creatureType) {
        switch (this.field_77361_a) {
            case 0: {
                return this.scalar * (float)level;
            }
            case 1: {
                return creatureType == EnumCreatureAttribute.UNDEAD ? this.scalar * (float)level : 0.0f;
            }
            case 2: {
                return creatureType == EnumCreatureAttribute.ARTHROPOD ? this.scalar * (float)level : 0.0f;
            }
        }
        return 0.0f;
    }

    public String func_77320_a() {
        return "enchantment.uniquee." + this.defaults.getName();
    }

    public int func_77325_b() {
        return 5;
    }

    public boolean func_185261_e() {
        return this.actualData.isTreasure();
    }

    public int func_77321_a(int enchantmentLevel) {
        return this.actualData.getLevelCost(enchantmentLevel);
    }

    public int func_77317_b(int enchantmentLevel) {
        return this.func_77321_a(enchantmentLevel) + this.actualData.getRangeCost();
    }

    public Enchantment.Rarity func_77324_c() {
        return this.actualData.getRarity();
    }

    public void func_151368_a(EntityLivingBase user, Entity target, int level) {
        if (target instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)target;
            if (this.field_77361_a == 2 && entitylivingbase.func_70668_bt() == EnumCreatureAttribute.ARTHROPOD) {
                int i = 40 + user.func_70681_au().nextInt(15 * level);
                entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76421_d, i, 3));
            }
        }
    }

    @Override
    public String getConfigName() {
        switch (this.field_77361_a) {
            case 0: {
                return "base.ameliorated_sharpness";
            }
            case 1: {
                return "base.ameliorated_smite";
            }
            case 2: {
                return "base.ameliorated_arthropods";
            }
        }
        return "I_AM_ERROR";
    }

    @Override
    public void loadFromConfig(Configuration config) {
        this.isEnabled = config.get(this.getConfigName(), "enabled", true).getBoolean();
        this.actualData = new UniqueEnchantment.DefaultData(this.defaults, config, this.getConfigName());
        this.scalar = (float)config.get(this.getConfigName(), "scalar", (double)DEFAULTS[this.field_77361_a]).getDouble();
        config.getCategory(this.getConfigName()).setLanguageKey(this.func_77320_a());
    }
}

