/*
 * Decompiled with CFR 0.152.
 */
package uniquee.enchantments.unique;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import uniquee.UniqueEnchantments;
import uniquee.enchantments.UniqueEnchantment;
import uniquee.enchantments.type.IGraceEnchantment;
import uniquee.enchantments.unique.EnchantmentNaturesGrace;
import uniquee.enchantments.unique.EnchantmentWarriorsGrace;
import uniquee.utils.MiscUtil;

public class EnchantmentAlchemistsGrace
extends UniqueEnchantment
implements IGraceEnchantment {
    public static List<List<PotionEffect>> EFFECTS = new ObjectArrayList();
    public static int SECONDS = 4;

    public EnchantmentAlchemistsGrace() {
        super(new UniqueEnchantment.DefaultData("alchemistsgrace", Enchantment.Rarity.VERY_RARE, true, 20, 3, 18), EnumEnchantmentType.WEAPON, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND, EntityEquipmentSlot.OFFHAND});
    }

    public int func_77325_b() {
        return 4;
    }

    @Override
    protected boolean canApplyToItem(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemAxe || stack.func_77973_b() instanceof ItemHoe || EnumEnchantmentType.BOW.func_77557_a(stack.func_77973_b());
    }

    protected boolean func_77326_a(Enchantment ench) {
        return ench instanceof EnchantmentWarriorsGrace || ench instanceof EnchantmentNaturesGrace ? false : super.func_77326_a(ench);
    }

    public static void applyToEntity(Entity entity) {
        EntityLivingBase base;
        Object2IntMap.Entry<EntityEquipmentSlot> slot;
        if (entity instanceof EntityLivingBase && (slot = MiscUtil.getEnchantedItem(UniqueEnchantments.ALCHEMISTS_GRACE, base = (EntityLivingBase)entity)).getIntValue() > 0) {
            int level = slot.getIntValue();
            ObjectOpenHashSet potions = new ObjectOpenHashSet();
            for (int i = level; i >= 0; --i) {
                if (EFFECTS.size() <= i) continue;
                for (PotionEffect effect : EFFECTS.get(i)) {
                    if (!potions.add(effect.func_188419_a())) continue;
                    base.func_70690_d(new PotionEffect(effect.func_188419_a(), effect.func_76459_b() * level * (SECONDS * 20), effect.func_76458_c()));
                }
            }
        }
    }

    @Override
    public void loadData(Configuration config) {
        EFFECTS.clear();
        String[] potions = config.getStringList("effects", this.getConfigName(), new String[]{"1;minecraft:speed;1;4", "2;minecraft:haste;1;6", "2;minecraft:speed;2;6", "3;minecraft:resistance;1;8", "3;minecraft:haste;2;8", "4;minecraft:strength;2;10", "4;minecraft:resistance;2;10"}, "Which Potion Effects should be applied. Format: MinimumEnchantLevel;Potion;PotionLevel;BaseDuration");
        SECONDS = config.get(this.getConfigName(), "duration_scalar", 4, "How much the duration should be multiplied with (in seconds)").getInt();
        for (String s : potions) {
            Potion p;
            String[] split = s.split(";");
            if (split.length < 4 || (p = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation(split[1]))) == null) continue;
            try {
                int index = Integer.parseInt(split[0]);
                while (EFFECTS.size() <= index) {
                    EFFECTS.add((List<PotionEffect>)new ObjectArrayList());
                }
                EFFECTS.get(index).add(new PotionEffect(p, Integer.parseInt(split[3]), Integer.parseInt(split[2])));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

