/*
 * Decompiled with CFR 0.152.
 */
package uniquee.enchantments.unique;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Set;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;
import uniquee.UniqueEnchantments;
import uniquee.enchantments.UniqueEnchantment;
import uniquee.utils.MiscUtil;

public class EnchantmentClimateTranquility
extends UniqueEnchantment {
    public static UUID SPEED_UUID = UUID.fromString("7b8a3791-8f94-4127-82b2-26418679d551");
    public static double SPEED_SCALE = 0.1;
    public static int SLOW_TIME = 30;
    public static UUID ATTACK_UUID = UUID.fromString("b47bd399-5ad0-4f1d-a0eb-0a9146ff1734");
    public static double ATTACK_SCALE = 0.1;
    public static int BURN_TIME = 1;

    public EnchantmentClimateTranquility() {
        super(new UniqueEnchantment.DefaultData("climate_tranquility", Enchantment.Rarity.RARE, true, 20, 2, 12), EnumEnchantmentType.WEAPON, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND, EntityEquipmentSlot.OFFHAND});
    }

    @Override
    protected boolean canApplyToItem(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemAxe || EnumEnchantmentType.BOW.func_77557_a(stack.func_77973_b());
    }

    public int func_77325_b() {
        return 3;
    }

    @Override
    public void loadData(Configuration config) {
        SPEED_SCALE = config.get(this.getConfigName(), "speed_scale", 0.1).getDouble();
        SLOW_TIME = config.get(this.getConfigName(), "slow_duration", 30).getInt();
        ATTACK_SCALE = config.get(this.getConfigName(), "attack_scale", 0.1).getDouble();
        BURN_TIME = config.get(this.getConfigName(), "burn_time", 1).getInt();
    }

    public static void onClimate(EntityPlayer player) {
        Object2IntMap.Entry<EntityEquipmentSlot> slot = MiscUtil.getEnchantedItem(UniqueEnchantments.CLIMATE_TRANQUILITY, (EntityLivingBase)player);
        AbstractAttributeMap map = player.func_110140_aT();
        IAttributeInstance speed = map.func_111151_a(SharedMonsterAttributes.field_188790_f);
        IAttributeInstance damage = map.func_111151_a(SharedMonsterAttributes.field_111264_e);
        if (slot.getIntValue() <= 0) {
            speed.func_188479_b(SPEED_UUID);
            damage.func_188479_b(ATTACK_UUID);
            return;
        }
        int level = slot.getIntValue();
        Set effects = BiomeDictionary.getTypes((Biome)player.field_70170_p.func_180494_b(player.func_180425_c()));
        boolean hasHot = effects.contains(BiomeDictionary.Type.HOT) || effects.contains(BiomeDictionary.Type.NETHER);
        boolean hasCold = effects.contains(BiomeDictionary.Type.COLD);
        if (hasHot && !hasCold) {
            AttributeModifier speedMod = new AttributeModifier(SPEED_UUID, "Climate Boost", SPEED_SCALE * (double)level, 2);
            if (!speed.func_180374_a(speedMod)) {
                speed.func_111121_a(speedMod);
            }
        } else {
            speed.func_188479_b(SPEED_UUID);
        }
        if (hasCold && !hasHot) {
            AttributeModifier damageMod = new AttributeModifier(ATTACK_UUID, "Climate Boost", ATTACK_SCALE * (double)level, 2);
            if (!damage.func_180374_a(damageMod)) {
                damage.func_111121_a(damageMod);
            }
        } else {
            damage.func_188479_b(ATTACK_UUID);
        }
    }
}

