/*
 * Decompiled with CFR 0.152.
 */
package uniquee.handler;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2BooleanLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntitySpectralArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import uniquee.UniqueEnchantments;
import uniquee.api.crops.CropHarvestRegistry;
import uniquee.enchantments.complex.EnchantmentEnderMending;
import uniquee.enchantments.complex.EnchantmentMomentum;
import uniquee.enchantments.complex.EnchantmentPerpetualStrike;
import uniquee.enchantments.complex.EnchantmentSmartAss;
import uniquee.enchantments.complex.EnchantmentSpartanWeapon;
import uniquee.enchantments.complex.EnchantmentSwiftBlade;
import uniquee.enchantments.curse.EnchantmentDeathsOdium;
import uniquee.enchantments.curse.EnchantmentPestilencesOdium;
import uniquee.enchantments.simple.EnchantmentBerserk;
import uniquee.enchantments.simple.EnchantmentBoneCrusher;
import uniquee.enchantments.simple.EnchantmentFocusImpact;
import uniquee.enchantments.simple.EnchantmentRange;
import uniquee.enchantments.simple.EnchantmentSagesBlessing;
import uniquee.enchantments.simple.EnchantmentSwift;
import uniquee.enchantments.simple.EnchantmentVitae;
import uniquee.enchantments.unique.EnchantmentAlchemistsGrace;
import uniquee.enchantments.unique.EnchantmentAresBlessing;
import uniquee.enchantments.unique.EnchantmentClimateTranquility;
import uniquee.enchantments.unique.EnchantmentCloudwalker;
import uniquee.enchantments.unique.EnchantmentDemetersSoul;
import uniquee.enchantments.unique.EnchantmentEcological;
import uniquee.enchantments.unique.EnchantmentEnderMarksmen;
import uniquee.enchantments.unique.EnchantmentFastFood;
import uniquee.enchantments.unique.EnchantmentIcarusAegis;
import uniquee.enchantments.unique.EnchantmentIfritsGrace;
import uniquee.enchantments.unique.EnchantmentMidasBlessing;
import uniquee.enchantments.unique.EnchantmentNaturesGrace;
import uniquee.enchantments.unique.EnchantmentWarriorsGrace;
import uniquee.handler.ai.AISpecialFindPlayer;
import uniquee.utils.HarvestEntry;
import uniquee.utils.MiscUtil;
import uniquee.utils.Triple;

public class EntityEvents {
    public static final EntityEvents INSTANCE = new EntityEvents();
    List<Tuple<Enchantment, String[]>> tooltips = new ObjectArrayList();
    List<Triple<Enchantment, ToIntFunction<ItemStack>, String>> anvilHelpers = new ObjectArrayList();

    public void registerStorageTooltip(Enchantment ench, String translation, String tag) {
        this.tooltips.add((Tuple<Enchantment, String[]>)new Tuple((Object)ench, (Object)new String[]{translation, tag}));
    }

    public void registerAnvilHelper(Enchantment ench, ToIntFunction<ItemStack> helper, String tag) {
        this.anvilHelpers.add(Triple.create(ench, helper, tag));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onToolTipEvent(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Object2IntMap<Enchantment> enchantments = MiscUtil.getEnchantments(stack);
        int m = this.tooltips.size();
        for (int i = 0; i < m; ++i) {
            Tuple<Enchantment, String[]> entry = this.tooltips.get(i);
            if (enchantments.getInt(entry.func_76341_a()) <= 0) continue;
            String[] names = (String[])entry.func_76340_b();
            event.getToolTip().add(I18n.func_135052_a((String)names[0], (Object[])new Object[]{EntityEvents.getInt(stack, names[1], 0)}));
        }
    }

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityEnderman) {
            EntityAITasks tasks = ((EntityEnderman)entity).field_70715_bh;
            for (EntityAITasks.EntityAITaskEntry task : new ObjectArrayList((Collection)tasks.field_75782_a)) {
                if (task.field_75731_b != 1 || !(task.field_75733_a instanceof EntityAINearestAttackableTarget)) continue;
                tasks.func_85156_a(task.field_75733_a);
                tasks.func_75776_a(1, (EntityAIBase)new AISpecialFindPlayer((EntityEnderman)entity));
            }
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(TickEvent.PlayerTickEvent event) {
        ItemStack stack;
        int level;
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        EntityPlayer player = event.player;
        if (event.side == Side.SERVER) {
            HarvestEntry entry;
            ItemStack stack2;
            int level2;
            int level3;
            if (player.func_110143_aJ() < player.func_110138_aP() && (level3 = MiscUtil.getEnchantmentLevel(UniqueEnchantments.NATURES_GRACE, player.func_184582_a(EntityEquipmentSlot.CHEST))) > 0 && player.field_70170_p.func_82737_E() % (long)MathHelper.func_76128_c((double)Math.sqrt(EnchantmentNaturesGrace.DELAY / level3)) == 0L && player.func_110142_aN().func_94550_c() == null && EntityEvents.hasBlockCount(player.field_70170_p, player.func_180425_c(), 4, EnchantmentNaturesGrace.FLOWERS)) {
                player.func_70691_i(EnchantmentNaturesGrace.HEALING.getAsFloat(level3));
            }
            if (player.field_70170_p.func_82737_E() % 100L == 0L) {
                EntityEquipmentSlot[] slots = MiscUtil.getEquipmentSlotsFor(UniqueEnchantments.ENDER_MENDING);
                for (int i = 0; i < slots.length; ++i) {
                    int stored;
                    ItemStack stack3 = player.func_184582_a(slots[i]);
                    int level4 = MiscUtil.getEnchantmentLevel(UniqueEnchantments.ENDER_MENDING, stack3);
                    if (level4 <= 0 || !stack3.func_77951_h() || (stored = EntityEvents.getInt(stack3, "ender_mending", 0)) <= 0) continue;
                    int toRemove = Math.min(stack3.func_77952_i(), stored);
                    stack3.func_77964_b(stack3.func_77952_i() - toRemove);
                    EntityEvents.setInt(stack3, "ender_mending", stored - toRemove);
                }
            }
            if (player.field_70170_p.func_82737_E() % 30L == 0L) {
                EnchantmentClimateTranquility.onClimate(player);
            }
            if (player.field_70170_p.func_82737_E() % 10L == 0L && (level2 = MiscUtil.getEnchantmentLevel(UniqueEnchantments.ICARUS_AEGIS, stack2 = player.func_184582_a(EntityEquipmentSlot.CHEST))) > 0) {
                stack2.func_77978_p().func_74757_a(EnchantmentIcarusAegis.FLYING_TAG, player.func_184613_cA());
            }
            if (player.field_70170_p.func_82737_E() % 40L == 0L && (level3 = MiscUtil.getCombinedEnchantmentLevel(UniqueEnchantments.PESTILENCES_ODIUM, (EntityLivingBase)player)) > 0) {
                List living = player.field_70170_p.func_72872_a(EntityAgeable.class, new AxisAlignedBB(player.func_180425_c()).func_186662_g(EnchantmentPestilencesOdium.RADIUS));
                int m = living.size();
                for (int i = 0; i < m; ++i) {
                    ((EntityAgeable)living.get(i)).func_70690_d(new PotionEffect(UniqueEnchantments.PESTILENCES_ODIUM_POTION, 200, level3));
                }
            }
            if (player.field_70170_p.func_82737_E() % 20L == 0L && (entry = EnchantmentDemetersSoul.getNextIndex(player)) != null) {
                EnumActionResult result = entry.harvest(player.field_70170_p, player);
                if (result == EnumActionResult.FAIL) {
                    NBTTagList list = EnchantmentDemetersSoul.getCrops(player);
                    int m = list.func_74745_c();
                    for (int i = 0; i < m; ++i) {
                        if (!entry.matches(list.func_150305_b(i))) continue;
                        list.func_74744_a(i--);
                        break;
                    }
                } else if (result == EnumActionResult.SUCCESS) {
                    player.func_71020_j(0.06f);
                }
            }
        }
        if ((level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.CLOUD_WALKER, stack = player.func_184582_a(EntityEquipmentSlot.FEET))) > 0) {
            if (player.func_70093_af()) {
                int value = EntityEvents.getInt(stack, "cloud", EnchantmentCloudwalker.TICKS.get(level));
                if (value <= 0) {
                    return;
                }
                player.field_70181_x = player.field_71075_bZ.field_75100_b ? 0.15 : 0.0;
                player.func_180430_e(player.field_70143_R, 1.0f);
                player.field_70143_R = 0.0f;
                if (!player.func_184812_l_()) {
                    EntityEvents.setInt(stack, "cloud", value - 1);
                }
            } else {
                EntityEvents.setInt(stack, "cloud", EnchantmentCloudwalker.TICKS.get(level));
            }
        }
        Boolean cache = null;
        EntityEquipmentSlot[] slots = MiscUtil.getEquipmentSlotsFor(UniqueEnchantments.ECOLOGICAL);
        for (int i = 0; i < slots.length; ++i) {
            ItemStack equipStack = player.func_184582_a(slots[i]);
            level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.ECOLOGICAL, equipStack);
            if (level <= 0 || !equipStack.func_77951_h() || player.field_70170_p.func_82737_E() % (long)Math.max(1, (int)((double)EnchantmentEcological.SPEED / Math.sqrt((double)level / EnchantmentEcological.SCALE))) != 0L || !(cache == null ? (cache = Boolean.valueOf(EntityEvents.hasBlockCount(player.field_70170_p, player.func_180425_c(), 1, EnchantmentEcological.STATES))) != false : cache != false)) continue;
            equipStack.func_77972_a(-1, (EntityLivingBase)player);
        }
    }

    @SubscribeEvent
    public void onXPPickup(PlayerPickupXpEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player == null) {
            return;
        }
        int maxLevel = 0;
        Object2BooleanLinkedOpenHashMap values = new Object2BooleanLinkedOpenHashMap();
        int foundItems = 0;
        EntityEquipmentSlot[] slots = MiscUtil.getEquipmentSlotsFor(UniqueEnchantments.ENDER_MENDING);
        for (int i = 0; i < slots.length; ++i) {
            ItemStack stack = player.func_184582_a(slots[i]);
            if (stack.func_190926_b()) continue;
            int level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.ENDER_MENDING, stack);
            if (level > 0) {
                values.put((Object)stack, true);
                ++foundItems;
                maxLevel = Math.max(maxLevel, level);
                continue;
            }
            if (!stack.func_77951_h() || MiscUtil.getEnchantmentLevel(Enchantments.field_185296_A, stack) <= 0) continue;
            values.put((Object)stack, false);
        }
        if (values.isEmpty() || foundItems <= 0) {
            return;
        }
        int xp = event.getOrb().field_70530_e;
        int totalXP = (int)(((float)xp * 1.0f - EnchantmentEnderMending.ABSORBTION_RATIO.getAsFloat(maxLevel)) * 2.0f);
        xp -= totalXP / 2;
        int usedXP = 0;
        for (Object2BooleanMap.Entry entry : values.object2BooleanEntrySet()) {
            ItemStack stack = (ItemStack)entry.getKey();
            if (!stack.func_77951_h()) continue;
            int used = Math.min(totalXP - usedXP, stack.func_77952_i());
            stack.func_77964_b(stack.func_77952_i() - used);
            if ((usedXP += used) < totalXP) continue;
            break;
        }
        if (totalXP <= usedXP) {
            player.func_71001_a((Entity)event.getOrb(), 1);
            event.getOrb().func_70106_y();
            event.setCanceled(true);
            player.func_71023_q(xp);
            return;
        }
        totalXP -= usedXP;
        usedXP = 0;
        int perItem = Math.max(1, totalXP / foundItems);
        for (Object2BooleanMap.Entry entry : values.object2BooleanEntrySet()) {
            if (!entry.getBooleanValue()) continue;
            ItemStack stack = (ItemStack)entry.getKey();
            int stored = EntityEvents.getInt(stack, "ender_mending", 0);
            int left = Math.min(Math.min(totalXP - usedXP, perItem), EnchantmentEnderMending.LIMIT - stored);
            if (left <= 0) continue;
            usedXP += left;
            EntityEvents.setInt(stack, "ender_mending", stored + left);
        }
        perItem = totalXP - usedXP;
        if (perItem > 0) {
            player.func_71023_q(perItem / 2);
        }
        player.func_71001_a((Entity)event.getOrb(), 1);
        event.getOrb().func_70106_y();
        event.setCanceled(true);
        player.func_71023_q(xp);
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        double value;
        if (event.getEntityPlayer() == null) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        ItemStack held = player.func_184614_ca();
        int level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.MOMENTUM, held);
        if (level > 0 && this.isMining(player)) {
            NBTTagCompound nbt = player.getEntityData();
            long worldTime = player.field_70170_p.func_82737_E();
            long time = nbt.func_74763_f("last_mined");
            int count = nbt.func_74762_e("mined");
            if (worldTime - time > (long)EnchantmentMomentum.MAX_DELAY || worldTime < time) {
                count = 0;
                nbt.func_74768_a("mined", 0);
            }
            event.setNewSpeed((float)((double)event.getNewSpeed() + (double)event.getNewSpeed() * ((double)level * ((double)count / EnchantmentMomentum.SCALAR) / (double)event.getOriginalSpeed())));
            nbt.func_74772_a("last_mined", worldTime);
        }
        if ((level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.RANGE, held)) > 0 && (value = player.func_110140_aT().func_111151_a(EntityPlayer.REACH_DISTANCE).func_111125_b()) * value < player.func_174831_c(event.getPos())) {
            event.setNewSpeed(event.getNewSpeed() * (1.0f - EnchantmentRange.REDUCTION.getDevided(level)));
        }
    }

    public boolean isMining(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            return (Boolean)ReflectionHelper.getPrivateValue(PlayerInteractionManager.class, (Object)((EntityPlayerMP)player).field_71134_c, (String)"isDestroyingBlock", (String)"field_73088_d");
        }
        return true;
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        ItemStack held = event.getPlayer().func_184614_ca();
        int level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.SMART_ASS, held);
        if (level > 0 && EnchantmentSmartAss.VALID_STATES.test(event.getState())) {
            Block block = event.getState().func_177230_c();
            int limit = EnchantmentSmartAss.STATS.get(level);
            World world = event.getWorld();
            IBlockState lastState = null;
            BlockPos lastPos = null;
            for (int i = 1; i < limit; ++i) {
                BlockPos pos = event.getPos().func_177981_b(i);
                IBlockState state = world.func_180495_p(pos);
                if (state.func_177230_c() != block) continue;
                lastState = state;
                lastPos = pos;
            }
            if (lastState != null && MiscUtil.harvestBlock(event, lastState, lastPos)) {
                event.setCanceled(true);
                return;
            }
        }
        if ((level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.SAGES_BLESSING, held)) > 0) {
            event.setExpToDrop((int)((double)event.getExpToDrop() + (double)event.getExpToDrop() * ((double)level * EnchantmentSagesBlessing.XP_BOOST)));
        }
        if ((level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.MOMENTUM, held)) > 0) {
            int max = EnchantmentMomentum.CAP + level;
            NBTTagCompound nbt = event.getPlayer().getEntityData();
            nbt.func_74768_a("mined", Math.min(max, nbt.func_74762_e("mined") + 1));
        }
    }

    @SubscribeEvent
    public void onBlockLoot(BlockEvent.HarvestDropsEvent event) {
        int stored;
        int gold;
        if (event.getHarvester() == null) {
            return;
        }
        ItemStack stack = event.getHarvester().func_184614_ca();
        int level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.MIDAS_BLESSING, stack);
        if (level > 0 && (gold = EntityEvents.getInt(stack, EnchantmentMidasBlessing.GOLD_COUNTER, 0)) > 0 && EntityEvents.isGem(event.getState())) {
            EntityEvents.setInt(stack, EnchantmentMidasBlessing.GOLD_COUNTER, Math.max(0, gold -= (int)(Math.ceil((double)EnchantmentMidasBlessing.LEVEL_SCALAR / (double)level) + (double)EnchantmentMidasBlessing.BASE_COST)));
            int multiplier = 1 + level;
            ObjectArrayList newDrops = new ObjectArrayList();
            for (ItemStack drop : event.getDrops()) {
                EntityEvents.growStack(drop, drop.func_190916_E() * multiplier, (List<ItemStack>)newDrops);
            }
            event.getDrops().clear();
            event.getDrops().addAll(newDrops);
        }
        if ((level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.IFRIDS_GRACE, stack)) > 0 && (stored = EntityEvents.getInt(stack, EnchantmentIfritsGrace.LAVA_COUNT, 0)) > 0) {
            boolean ore = EntityEvents.isOre(event.getState());
            int smelted = 0;
            List stacks = event.getDrops();
            int m = stacks.size();
            for (int i = 0; i < m; ++i) {
                ItemStack toBurn = ((ItemStack)stacks.get(i)).func_77946_l();
                toBurn.func_190920_e(1);
                ItemStack burned = FurnaceRecipes.func_77602_a().func_151395_a(toBurn).func_77946_l();
                if (burned.func_190926_b()) continue;
                burned.func_190920_e(burned.func_190916_E() * ((ItemStack)stacks.get(i)).func_190916_E());
                stacks.set(i, burned);
                ++smelted;
            }
            if (smelted > 0) {
                EntityEvents.setInt(stack, EnchantmentIfritsGrace.LAVA_COUNT, Math.max(0, stored -= MathHelper.func_76123_f((float)(smelted * (ore ? 5 : 1) * EnchantmentIfritsGrace.SCALAR / level))));
            }
        }
    }

    @SubscribeEvent
    public void onItemClick(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack = event.getItemStack();
        if (!event.getWorld().field_72995_K && stack.func_77973_b() instanceof ItemMap && MiscUtil.getEnchantmentLevel(UniqueEnchantments.ENDER_LIBRARIAN, stack) > 0) {
            ItemMap map = (ItemMap)stack.func_77973_b();
            MapData data = map.func_77873_a(stack, event.getWorld());
            if (data == null || data.field_76200_c != event.getWorld().field_73011_w.getDimension()) {
                return;
            }
            int x = data.field_76201_a;
            int z = data.field_76199_b;
            BlockPos position = null;
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt != null) {
                NBTTagList list = nbt.func_150295_c("Decorations", 10);
                int m = list.func_74745_c();
                for (int i = 0; i < m; ++i) {
                    NBTTagCompound nbtData = list.func_150305_b(i);
                    if (!nbtData.func_74779_i("id").equalsIgnoreCase("+")) continue;
                    position = new BlockPos(nbtData.func_74762_e("x") - 20, 255, nbtData.func_74762_e("z") - 20);
                }
            }
            if (position != null) {
                BlockPos pos = event.getWorld().func_175672_r(position);
                event.getEntityPlayer().func_70634_a((double)((float)pos.func_177958_n() + 0.5f), (double)Math.max(event.getWorld().func_181545_F(), pos.func_177956_o() + 1), (double)((float)pos.func_177952_p() + 0.5f));
            } else {
                int limit = 64 * (1 << data.field_76197_d) * 2;
                int xOffset = (int)((event.getWorld().field_73012_v.nextDouble() - 0.5) * (double)limit);
                int zOffset = (int)((event.getWorld().field_73012_v.nextDouble() - 0.5) * (double)limit);
                BlockPos pos = event.getWorld().func_175672_r(new BlockPos(x + xOffset, 255, z + zOffset));
                event.getEntityPlayer().func_70634_a((double)((float)pos.func_177958_n() + 0.5f), (double)Math.max(event.getWorld().func_181545_F(), pos.func_177956_o() + 1), (double)((float)pos.func_177952_p() + 0.5f));
            }
            stack.func_190918_g(1);
        }
    }

    @SubscribeEvent
    public void onBlockClick(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntityPlayer().func_70093_af()) {
            int level;
            IBlockState state = event.getWorld().func_180495_p(event.getPos());
            if (state.func_177230_c() instanceof BlockAnvil) {
                ItemStack stack = event.getItemStack();
                Object2IntMap<Enchantment> enchantments = MiscUtil.getEnchantments(stack);
                int m = this.anvilHelpers.size();
                for (int i = 0; i < m; ++i) {
                    int found;
                    Triple<Enchantment, ToIntFunction<ItemStack>, String> entry = this.anvilHelpers.get(i);
                    if (enchantments.getInt((Object)entry.getKey()) <= 0 || (found = EntityEvents.consumeItems(event.getEntityPlayer(), entry.getValue(), Integer.MAX_VALUE)) <= 0) continue;
                    EntityEvents.setInt(stack, entry.getExtra(), found + EntityEvents.getInt(stack, entry.getExtra(), 0));
                    event.setCancellationResult(EnumActionResult.SUCCESS);
                    event.setCanceled(true);
                }
            }
            if ((level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.DEMETERS_SOUL, event.getItemStack())) > 0 && CropHarvestRegistry.INSTANCE.isValid(state.func_177230_c()) && !event.getWorld().field_72995_K) {
                HarvestEntry entry = new HarvestEntry(event.getWorld().field_73011_w.getDimension(), event.getPos().func_177986_g());
                NBTTagList list = EnchantmentDemetersSoul.getCrops(event.getEntityPlayer());
                boolean found = false;
                int m = list.func_74745_c();
                for (int i = 0; i < m; ++i) {
                    if (!entry.matches(list.func_150305_b(i))) continue;
                    found = true;
                    list.func_74744_a(i--);
                    break;
                }
                if (!found) {
                    list.func_74742_a((NBTBase)entry.save());
                }
                event.getEntityPlayer().func_146105_b((ITextComponent)new TextComponentTranslation("tooltip.uniqee.crops." + (found ? "removed" : "added") + ".name", new Object[0]), false);
                event.setCancellationResult(EnumActionResult.SUCCESS);
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public void onEntityHit(LivingAttackEvent event) {
        Entity entity = event.getSource().func_76346_g();
        EnchantmentAlchemistsGrace.applyToEntity(entity);
    }

    @SubscribeEvent
    public void onEntityAttack(LivingHurtEvent event) {
        double value;
        EntityPlayer player;
        ItemStack stack;
        int level;
        Entity entity = event.getSource().func_76346_g();
        if (entity instanceof EntityLivingBase) {
            IAttributeInstance attr;
            EntityLivingBase base = (EntityLivingBase)entity;
            Object2IntMap<Enchantment> enchantments = MiscUtil.getEnchantments(base.func_184614_ca());
            if (enchantments.getInt((Object)UniqueEnchantments.BERSERKER) > 0) {
                event.setAmount(event.getAmount() * (1.0f + (float)EnchantmentBerserk.SCALAR * (base.func_110138_aP() / base.func_110143_aJ())));
            }
            if ((level = enchantments.getInt((Object)UniqueEnchantments.SWIFT_BLADE)) > 0 && (attr = base.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_188790_f)) != null) {
                event.setAmount(event.getAmount() * (1.0f + (float)Math.log10(attr.func_111126_e() / EnchantmentSwiftBlade.SCALAR * (double)level)));
            }
            if ((level = enchantments.getInt((Object)UniqueEnchantments.FOCUS_IMPACT)) > 0 && (attr = base.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_188790_f)) != null) {
                event.setAmount(event.getAmount() * (1.0f + (float)Math.log10(EnchantmentFocusImpact.SCALAR * (double)level / (attr.func_111126_e() * attr.func_111126_e()))));
            }
            if ((level = enchantments.getInt((Object)UniqueEnchantments.PERPETUAL_STRIKE)) > 0) {
                ItemStack held = base.func_184614_ca();
                int count = EntityEvents.getInt(held, "strikes", 0);
                int lastEntity = EntityEvents.getInt(held, "hit_id", 0);
                if (lastEntity != event.getEntityLiving().func_145782_y()) {
                    count = 0;
                    EntityEvents.setInt(held, "hit_id", event.getEntityLiving().func_145782_y());
                }
                event.setAmount((float)((double)event.getAmount() * (1.0 + (double)(level * count) * EnchantmentPerpetualStrike.SCALAR)));
                EntityEvents.setInt(held, "strikes", count + 1);
            }
            if ((level = MiscUtil.getEnchantedItem(UniqueEnchantments.CLIMATE_TRANQUILITY, base).getIntValue()) > 0) {
                Set effects = BiomeDictionary.getTypes((Biome)base.field_70170_p.func_180494_b(base.func_180425_c()));
                boolean hasHot = effects.contains(BiomeDictionary.Type.HOT) || effects.contains(BiomeDictionary.Type.NETHER);
                boolean hasCold = effects.contains(BiomeDictionary.Type.COLD);
                if (hasHot && !hasCold) {
                    event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76421_d, EnchantmentClimateTranquility.SLOW_TIME * level, level));
                } else if (hasCold && !hasHot) {
                    event.getEntityLiving().func_70015_d(level * EnchantmentClimateTranquility.BURN_TIME);
                }
            }
            if (event.getEntityLiving() instanceof AbstractSkeleton && (level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.BONE_CRUSH, base.func_184614_ca())) > 0 && EnchantmentBoneCrusher.isNotArmored((AbstractSkeleton)event.getEntityLiving())) {
                event.setAmount((float)((double)event.getAmount() * (1.0 + EnchantmentBoneCrusher.SCALAR * (double)level)));
            }
        }
        if (entity instanceof EntityPlayer && (level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.RANGE, stack = (player = (EntityPlayer)entity).func_184614_ca())) > 0 && (value = player.func_110140_aT().func_111151_a(EntityPlayer.REACH_DISTANCE).func_111125_b()) * value < player.func_70068_e(event.getEntity())) {
            event.setAmount(event.getAmount() * (1.0f - EnchantmentRange.REDUCTION.getDevided(level)));
        }
    }

    @SubscribeEvent
    public void onEntityDamage(LivingDamageEvent event) {
        int consume;
        int feathers;
        ItemStack stack;
        EntityLivingBase base;
        int level;
        Entity entity = event.getSource().func_76346_g();
        if (entity instanceof EntityLivingBase && (level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.SPARTAN_WEAPON, (base = (EntityLivingBase)entity).func_184614_ca())) > 0 && base.func_184592_cb().func_77973_b() instanceof ItemShield) {
            event.setAmount(event.getAmount() + event.getAmount() * ((float)EnchantmentSpartanWeapon.SCALAR * (float)level));
        }
        if (event.getSource() == DamageSource.field_188406_j && (level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.ICARUS_AEGIS, stack = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST))) > 0 && (feathers = EntityEvents.getInt(stack, EnchantmentIcarusAegis.FEATHER_TAG, 0)) >= (consume = (int)Math.ceil((double)EnchantmentIcarusAegis.SCALAR / (double)level))) {
            EntityEvents.setInt(stack, EnchantmentIcarusAegis.FEATHER_TAG, feathers -= consume);
            event.setCanceled(true);
            return;
        }
        if (event.getAmount() >= event.getEntityLiving().func_110143_aJ()) {
            ItemStack stack2;
            int level2;
            DamageSource source = event.getSource();
            if (!source.func_82725_o() && source != DamageSource.field_76379_h && (level2 = MiscUtil.getEnchantmentLevel(UniqueEnchantments.ARES_BLESSING, stack2 = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST))) > 0 && stack2.func_77984_f()) {
                float damage = event.getAmount();
                stack2.func_77972_a((int)((double)damage * (EnchantmentAresBlessing.SCALAR / (double)level2)), event.getEntityLiving());
                event.setCanceled(true);
                return;
            }
            Object2IntMap.Entry<EntityEquipmentSlot> slot = MiscUtil.getEnchantedItem(UniqueEnchantments.PHOENIX_BLESSING, event.getEntityLiving());
            if (slot.getIntValue() > 0) {
                EntityLivingBase living = event.getEntityLiving();
                living.func_70691_i(living.func_110138_aP());
                living.func_70674_bp();
                if (living instanceof EntityPlayer) {
                    ((EntityPlayer)living).func_71024_bL().func_75122_a(Short.MAX_VALUE, 1.0f);
                }
                living.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 900, 1));
                living.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 100, 1));
                living.field_70170_p.func_72960_a((Entity)living, (byte)35);
                event.getEntityLiving().func_184582_a((EntityEquipmentSlot)slot.getKey()).func_190918_g(1);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        int consume;
        int feathers;
        ItemStack stack = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST);
        int level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.ICARUS_AEGIS, stack);
        if (level > 0 && stack.func_77978_p().func_74767_n(EnchantmentIcarusAegis.FLYING_TAG) && (feathers = EntityEvents.getInt(stack, EnchantmentIcarusAegis.FEATHER_TAG, 0)) >= (consume = (int)Math.ceil((double)EnchantmentIcarusAegis.SCALAR / (double)level))) {
            EntityEvents.setInt(stack, EnchantmentIcarusAegis.FEATHER_TAG, feathers -= consume);
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onEntityKilled(LivingDeathEvent event) {
        Object2IntMap.Entry<EntityEquipmentSlot> ench;
        ItemStack stack;
        int amount;
        EntityLivingBase base;
        int level;
        Entity entity = event.getSource().func_76346_g();
        if (entity instanceof EntityLivingBase && (level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.WARRIORS_GRACE, (base = (EntityLivingBase)entity).func_184614_ca())) > 0 && (amount = Math.min((stack = base.func_184614_ca()).func_77952_i(), MathHelper.func_76143_f((double)(Math.sqrt(event.getEntityLiving().func_110138_aP() * (float)level) * EnchantmentWarriorsGrace.DURABILITY_GAIN)))) > 0) {
            stack.func_77972_a(-amount, base);
        }
        if ((ench = MiscUtil.getEnchantedItem(UniqueEnchantments.DEATHS_ODIUM, event.getEntityLiving())).getIntValue() > 0) {
            ItemStack stack2 = event.getEntityLiving().func_184582_a((EntityEquipmentSlot)ench.getKey());
            EntityEvents.setInt(stack2, "curse_storage", EntityEvents.getInt(stack2, "curse_storage", 0) + 1);
            IAttributeInstance instance = event.getEntityLiving().func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a);
            AttributeModifier mod = instance.func_111127_a(EnchantmentDeathsOdium.REMOVE_UUID);
            float toRemove = 0.0f;
            if (mod != null) {
                toRemove = (float)((double)toRemove + mod.func_111164_d());
                instance.func_111124_b(mod);
            }
            NBTTagCompound nbt = event.getEntityLiving().getEntityData().func_74775_l("PlayerPersisted");
            event.getEntityLiving().getEntityData().func_74782_a("PlayerPersisted", (NBTBase)nbt);
            nbt.func_74776_a("curse_storage", toRemove - 1.0f);
        }
    }

    @SubscribeEvent
    public void onRespawn(PlayerEvent.Clone event) {
        float f = event.getEntityPlayer().getEntityData().func_74775_l("PlayerPersisted").func_74760_g("curse_storage");
        if (f != 0.0f) {
            event.getEntityLiving().func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier(EnchantmentDeathsOdium.REMOVE_UUID, "odiums_curse", (double)f, 0));
        }
    }

    @SubscribeEvent
    public void onXPDrop(LivingExperienceDropEvent event) {
        if (event.getAttackingPlayer() == null) {
            return;
        }
        int level = MiscUtil.getEnchantedItem(UniqueEnchantments.SAGES_BLESSING, (EntityLivingBase)event.getAttackingPlayer()).getIntValue();
        if (level > 0) {
            event.setDroppedExperience((int)((double)event.getDroppedExperience() + (double)event.getDroppedExperience() * ((double)level * EnchantmentSagesBlessing.XP_BOOST)));
        }
    }

    @SubscribeEvent
    public void onLootingLevel(LootingLevelEvent event) {
        int level;
        Entity entity = event.getDamageSource().func_76346_g();
        if (entity instanceof EntityLivingBase && event.getEntityLiving() instanceof AbstractSkeleton && (level = MiscUtil.getEnchantmentLevel(UniqueEnchantments.BONE_CRUSH, ((EntityLivingBase)entity).func_184614_ca())) > 0 && EnchantmentBoneCrusher.isNotArmored((AbstractSkeleton)event.getEntityLiving())) {
            event.setLootingLevel(event.getLootingLevel() + 1 + level);
        }
    }

    @SubscribeEvent
    public void onEntityDrops(LivingDropsEvent event) {
        EntityPlayer base;
        int level;
        Entity entity = event.getSource().func_76346_g();
        if (entity instanceof EntityPlayer && event.getEntityLiving() instanceof EntityAnimal && (level = MiscUtil.getEnchantedItem(UniqueEnchantments.FAST_FOOD, (EntityLivingBase)(base = (EntityPlayer)entity)).getIntValue()) > 0) {
            base.func_71024_bL().func_75122_a(EnchantmentFastFood.NURISHMENT.get(level), (float)(EnchantmentFastFood.SATURATION * (double)level));
            event.setCanceled(true);
        }
        if (event.getEntityLiving().func_70644_a(UniqueEnchantments.PESTILENCES_ODIUM_POTION)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onArrowHit(ProjectileImpactEvent.Arrow event) {
        RayTraceResult result = event.getRayTraceResult();
        if (result.field_72313_a != RayTraceResult.Type.ENTITY || !(result.field_72308_g instanceof EntityLivingBase) || event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        EntityArrow arrow = event.getArrow();
        EnchantmentAlchemistsGrace.applyToEntity(arrow.field_70250_c);
        if (arrow.field_70250_c instanceof EntityPlayer) {
            EntityLivingBase hitEntity = (EntityLivingBase)result.field_72308_g;
            EntityPlayer player = (EntityPlayer)arrow.field_70250_c;
            Object2IntMap.Entry<EntityEquipmentSlot> slot = MiscUtil.getEnchantedItem(UniqueEnchantments.ENDERMARKSMEN, (EntityLivingBase)player);
            if (slot.getIntValue() > 0) {
                int level = slot.getIntValue();
                ItemStack stack = player.func_184582_a((EntityEquipmentSlot)slot.getKey());
                arrow.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
                player.func_191521_c(EntityEvents.getArrowStack(arrow));
                int needed = Math.min((int)((double)level * EnchantmentEnderMarksmen.SCALAR), stack.func_77952_i());
                if (needed > 0) {
                    stack.func_77972_a(-needed, (EntityLivingBase)player);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEquippementSwapped(LivingEquipmentChangeEvent event) {
        AbstractAttributeMap attribute = event.getEntityLiving().func_110140_aT();
        Multimap<String, AttributeModifier> mods = this.createModifiersFromStack(event.getFrom(), event.getSlot());
        if (!mods.isEmpty()) {
            attribute.func_111148_a(mods);
        }
        if (!(mods = this.createModifiersFromStack(event.getTo(), event.getSlot())).isEmpty()) {
            attribute.func_111147_b(mods);
        }
    }

    private Multimap<String, AttributeModifier> createModifiersFromStack(ItemStack stack, EntityEquipmentSlot slot) {
        int value;
        HashMultimap mods = HashMultimap.create();
        Object2IntMap<Enchantment> enchantments = MiscUtil.getEnchantments(stack);
        int level = enchantments.getInt((Object)UniqueEnchantments.VITAE);
        if (level > 0 && MiscUtil.getSlotsFor(UniqueEnchantments.VITAE).contains(slot)) {
            mods.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(EnchantmentVitae.getForSlot(slot), "Vitae Boost", (double)level * EnchantmentVitae.HEALTH_BOOST, 0));
        }
        if ((level = enchantments.getInt((Object)UniqueEnchantments.SWIFT)) > 0 && MiscUtil.getSlotsFor(UniqueEnchantments.SWIFT).contains(slot)) {
            mods.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(EnchantmentSwift.SPEED_MOD, "Swift Boost", EnchantmentSwift.SPEED_BONUS.getAsDouble(level), 2));
        }
        if ((level = enchantments.getInt((Object)UniqueEnchantments.RANGE)) > 0 && MiscUtil.getSlotsFor(UniqueEnchantments.RANGE).contains(slot)) {
            mods.put((Object)EntityPlayer.REACH_DISTANCE.func_111108_a(), (Object)new AttributeModifier(EnchantmentRange.RANGE_MOD, "Range Boost", (double)EnchantmentRange.RANGE.getAsFloat(level), 0));
        }
        if ((level = enchantments.getInt((Object)UniqueEnchantments.DEATHS_ODIUM)) > 0 && MiscUtil.getSlotsFor(UniqueEnchantments.DEATHS_ODIUM).contains(slot) && (value = EntityEvents.getInt(stack, "curse_storage", 0)) > 0) {
            mods.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(EnchantmentDeathsOdium.getForSlot(slot), "Death Odiums Restore", (double)value, 0));
        }
        return mods;
    }

    public static int getInt(ItemStack stack, String tagName, int defaultValue) {
        NBTTagCompound nbt = stack.func_77978_p();
        return nbt == null || !nbt.func_74764_b(tagName) ? defaultValue : nbt.func_74762_e(tagName);
    }

    public static void setInt(ItemStack stack, String tagName, int value) {
        stack.func_77983_a(tagName, (NBTBase)new NBTTagInt(value));
    }

    public static long getLong(ItemStack stack, String tagName, long defaultValue) {
        NBTTagCompound nbt = stack.func_77978_p();
        return nbt == null || !nbt.func_74764_b(tagName) ? defaultValue : nbt.func_74763_f(tagName);
    }

    public static void setLong(ItemStack stack, String tagName, long value) {
        stack.func_77983_a(tagName, (NBTBase)new NBTTagLong(value));
    }

    public static void growStack(ItemStack source, int size, List<ItemStack> output) {
        while (size > 0) {
            ItemStack stack = source.func_77946_l();
            stack.func_190920_e(Math.min(size, stack.func_77976_d()));
            output.add(stack);
            size -= stack.func_190916_E();
        }
    }

    public static ItemStack getArrowStack(EntityArrow arrow) {
        try {
            return (ItemStack)ReflectionHelper.findMethod(EntityArrow.class, (String)"getArrowStack", (String)"func_184550_j", (Class[])new Class[0]).invoke((Object)arrow, new Object[0]);
        }
        catch (Exception exception) {
            if (arrow instanceof EntitySpectralArrow) {
                return new ItemStack(Items.field_185166_h);
            }
            if (arrow instanceof EntityTippedArrow) {
                NBTTagCompound nbt = new NBTTagCompound();
                arrow.func_70014_b(nbt);
                if (nbt.func_74764_b("CustomPotionEffects")) {
                    ItemStack stack = new ItemStack(Items.field_185167_i);
                    stack.func_77983_a("CustomPotionEffects", nbt.func_74781_a("CustomPotionEffects"));
                    return stack;
                }
                return new ItemStack(Items.field_151032_g);
            }
            return ItemStack.field_190927_a;
        }
    }

    public static boolean isOre(IBlockState state) {
        Item item = Item.func_150898_a((Block)state.func_177230_c());
        if (item == Items.field_190931_a) {
            return false;
        }
        for (int id : OreDictionary.getOreIDs((ItemStack)new ItemStack(item, 1, item.func_77647_b(state.func_177230_c().func_176201_c(state))))) {
            if (!OreDictionary.getOreName((int)id).startsWith("ore")) continue;
            return true;
        }
        return false;
    }

    public static boolean isGem(IBlockState state) {
        Item item = Item.func_150898_a((Block)state.func_177230_c());
        if (item == Items.field_190931_a) {
            return false;
        }
        for (int id : OreDictionary.getOreIDs((ItemStack)new ItemStack(item, 1, item.func_77647_b(state.func_177230_c().func_176201_c(state))))) {
            String gem = OreDictionary.getOreName((int)id);
            if (!gem.startsWith("ore") || !OreDictionary.doesOreNameExist((String)("gem" + gem.substring(3)))) continue;
            return true;
        }
        return false;
    }

    public static int consumeItems(EntityPlayer player, ToIntFunction<ItemStack> validator, int limit) {
        int found = 0;
        NonNullList inv = player.field_71071_by.field_70462_a;
        int m = inv.size();
        for (int i = 0; i < m; ++i) {
            ItemStack stack = (ItemStack)inv.get(i);
            int value = validator.applyAsInt(stack);
            if (value <= 0) continue;
            int left = limit - found;
            if (left >= stack.func_190916_E() * value) {
                found += stack.func_190916_E() * value;
                if (stack.func_77973_b().hasContainerItem(stack)) {
                    inv.set(i, (Object)stack.func_77973_b().getContainerItem(stack));
                    continue;
                }
                inv.set(i, (Object)ItemStack.field_190927_a);
            } else if (left / value > 0) {
                stack.func_190918_g(left / value);
                found += left;
            }
            if (found >= limit) break;
        }
        return found;
    }

    public static boolean hasBlockCount(World world, BlockPos pos, int limit, Predicate<IBlockState> validator) {
        BlockPos.MutableBlockPos newPos = new BlockPos.MutableBlockPos();
        int found = 0;
        for (int y = 0; y <= 1; ++y) {
            for (int x = -4; x <= 4; ++x) {
                for (int z = -4; z <= 4; ++z) {
                    newPos.func_181079_c(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                    if (!validator.test(world.func_180495_p((BlockPos)newPos)) || ++found < limit) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static int getXP(EntityPlayer player) {
        return EntityEvents.getXPForLvl(player.field_71068_ca) + (int)(player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static int getXPForLvl(int level) {
        if (level < 0) {
            return Integer.MAX_VALUE;
        }
        if (level <= 15) {
            return level * level + 6 * level;
        }
        if (level <= 30) {
            return (int)((double)(level * level) * 2.5 - 40.5 * (double)level + 360.0);
        }
        return (int)((double)(level * level) * 4.5 - 162.5 * (double)level + 2220.0);
    }

    public static int getLvlForXP(int totalXP) {
        int result = 0;
        while (EntityEvents.getXPForLvl(result) <= totalXP) {
            ++result;
        }
        return --result;
    }
}

