/*
 * Decompiled with CFR 0.152.
 */
package uniquee.utils;

import it.unimi.dsi.fastutil.objects.AbstractObject2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class MiscUtil {
    public static int getEnchantmentLevel(Enchantment ench, ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        NBTTagList list = stack.func_77986_q();
        if (list.func_82582_d()) {
            return 0;
        }
        int id = Enchantment.func_185258_b((Enchantment)ench);
        int m = list.func_74745_c();
        for (int i = 0; i < m; ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            if (tag.func_74762_e("id") != id) continue;
            return tag.func_74762_e("lvl");
        }
        return 0;
    }

    public static int getCombinedEnchantmentLevel(Enchantment ench, EntityLivingBase base) {
        EntityEquipmentSlot[] slots = MiscUtil.getEquipmentSlotsFor(ench);
        if (slots.length <= 0) {
            return 0;
        }
        int totalLevel = 0;
        for (int i = 0; i < slots.length; ++i) {
            totalLevel += MiscUtil.getEnchantmentLevel(ench, base.func_184582_a(slots[i]));
        }
        return totalLevel;
    }

    public static Object2IntMap<Enchantment> getEnchantments(ItemStack stack) {
        if (stack.func_190926_b()) {
            return Object2IntMaps.emptyMap();
        }
        NBTTagList list = stack.func_77986_q();
        if (list.func_82582_d()) {
            return Object2IntMaps.emptyMap();
        }
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        int m = list.func_74745_c();
        for (int i = 0; i < m; ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            Enchantment enchantment = Enchantment.func_185262_c((int)tag.func_74765_d("id"));
            if (enchantment == null) continue;
            map.put((Object)enchantment, tag.func_74762_e("lvl"));
        }
        return map;
    }

    public static EntityEquipmentSlot[] getEquipmentSlotsFor(Enchantment ench) {
        try {
            return (EntityEquipmentSlot[])ReflectionHelper.getPrivateValue(Enchantment.class, (Object)ench, (String)"applicableEquipmentTypes", (String)"field_185263_a");
        }
        catch (Exception exception) {
            return new EntityEquipmentSlot[0];
        }
    }

    public static Set<EntityEquipmentSlot> getSlotsFor(Enchantment ench) {
        Object[] slots = MiscUtil.getEquipmentSlotsFor(ench);
        return slots.length <= 0 ? Collections.emptySet() : new ObjectOpenHashSet(slots);
    }

    public static Object2IntMap.Entry<EntityEquipmentSlot> getEnchantedItem(Enchantment enchantment, EntityLivingBase base) {
        EntityEquipmentSlot[] slots = MiscUtil.getEquipmentSlotsFor(enchantment);
        if (slots.length <= 0) {
            return new AbstractObject2IntMap.BasicEntry(null, 0);
        }
        for (int i = 0; i < slots.length; ++i) {
            int level = MiscUtil.getEnchantmentLevel(enchantment, base.func_184582_a(slots[i]));
            if (level <= 0) continue;
            return new AbstractObject2IntMap.BasicEntry((Object)slots[i], level);
        }
        return new AbstractObject2IntMap.BasicEntry(null, 0);
    }

    public static boolean harvestBlock(BlockEvent.BreakEvent event, IBlockState state, BlockPos pos) {
        if (!(event.getPlayer() instanceof EntityPlayerMP)) {
            return false;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getPlayer();
        ItemStack stack = event.getPlayer().func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b().onBlockStartBreak(stack, pos, (EntityPlayer)player)) {
            return false;
        }
        World world = event.getWorld();
        world.func_180498_a((EntityPlayer)player, 2001, pos, Block.func_176210_f((IBlockState)state));
        boolean flag1 = false;
        if (player.func_184812_l_()) {
            flag1 = MiscUtil.removeBlock(world, pos, (EntityPlayer)player, false);
            player.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
        } else {
            ItemStack itemstack1 = player.func_184614_ca();
            ItemStack itemstack2 = itemstack1.func_190926_b() ? ItemStack.field_190927_a : itemstack1.func_77946_l();
            boolean flag = state.func_177230_c().canHarvestBlock((IBlockAccess)world, pos, (EntityPlayer)player);
            if (!itemstack1.func_190926_b()) {
                itemstack1.func_179548_a(world, state, pos, (EntityPlayer)player);
                if (itemstack1.func_190926_b()) {
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)itemstack2, (EnumHand)EnumHand.MAIN_HAND);
                }
            }
            if ((flag1 = MiscUtil.removeBlock(world, pos, (EntityPlayer)player, flag)) && flag) {
                state.func_177230_c().func_180657_a(world, (EntityPlayer)player, pos, state, world.func_175625_s(pos), itemstack2);
            }
        }
        if (!player.func_184812_l_() && flag1 && event.getExpToDrop() > 0) {
            state.func_177230_c().func_180637_b(world, pos, event.getExpToDrop());
        }
        return true;
    }

    private static boolean removeBlock(World world, BlockPos pos, EntityPlayer player, boolean canHarvest) {
        IBlockState iblockstate = world.func_180495_p(pos);
        boolean flag = iblockstate.func_177230_c().removedByPlayer(iblockstate, world, pos, player, canHarvest);
        if (flag) {
            iblockstate.func_177230_c().func_176206_d(world, pos, iblockstate);
        }
        return flag;
    }
}

