/*
 * Decompiled with CFR 0.152.
 */
package uniquee;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import uniquee.api.crops.CropHarvestRegistry;
import uniquee.client.EnchantmentLayer;
import uniquee.compat.FirstAidHandler;
import uniquee.enchantments.IToggleEnchantment;
import uniquee.enchantments.complex.EnchantmentEnderMending;
import uniquee.enchantments.complex.EnchantmentMomentum;
import uniquee.enchantments.complex.EnchantmentPerpetualStrike;
import uniquee.enchantments.complex.EnchantmentSmartAss;
import uniquee.enchantments.complex.EnchantmentSpartanWeapon;
import uniquee.enchantments.complex.EnchantmentSwiftBlade;
import uniquee.enchantments.curse.EnchantmentDeathsOdium;
import uniquee.enchantments.curse.EnchantmentPestilencesOdium;
import uniquee.enchantments.simple.EnchantmentAdvancedDamage;
import uniquee.enchantments.simple.EnchantmentBerserk;
import uniquee.enchantments.simple.EnchantmentBoneCrusher;
import uniquee.enchantments.simple.EnchantmentEnderEyes;
import uniquee.enchantments.simple.EnchantmentFocusImpact;
import uniquee.enchantments.simple.EnchantmentRange;
import uniquee.enchantments.simple.EnchantmentSagesBlessing;
import uniquee.enchantments.simple.EnchantmentSwift;
import uniquee.enchantments.simple.EnchantmentTreasurersEyes;
import uniquee.enchantments.simple.EnchantmentVitae;
import uniquee.enchantments.unique.EnchantmentAlchemistsGrace;
import uniquee.enchantments.unique.EnchantmentAresBlessing;
import uniquee.enchantments.unique.EnchantmentClimateTranquility;
import uniquee.enchantments.unique.EnchantmentCloudwalker;
import uniquee.enchantments.unique.EnchantmentDemetersSoul;
import uniquee.enchantments.unique.EnchantmentEcological;
import uniquee.enchantments.unique.EnchantmentEnderLibrarian;
import uniquee.enchantments.unique.EnchantmentEnderMarksmen;
import uniquee.enchantments.unique.EnchantmentEndestReap;
import uniquee.enchantments.unique.EnchantmentFastFood;
import uniquee.enchantments.unique.EnchantmentIcarusAegis;
import uniquee.enchantments.unique.EnchantmentIfritsGrace;
import uniquee.enchantments.unique.EnchantmentMidasBlessing;
import uniquee.enchantments.unique.EnchantmentNaturesGrace;
import uniquee.enchantments.unique.EnchantmentPhoenixBlessing;
import uniquee.enchantments.unique.EnchantmentWarriorsGrace;
import uniquee.handler.EntityEvents;
import uniquee.handler.potion.PotionPestilencesOdium;

@Mod(modid="uniquee", name="Unique Enchantments", version="1.9.0", guiFactory="uniquee.handler.ConfigHandler", acceptedMinecraftVersions="[1.12.2]")
public class UniqueEnchantments {
    static List<IToggleEnchantment> ENCHANTMENTS = new ObjectArrayList();
    public static Enchantment BERSERKER = new EnchantmentBerserk();
    public static Enchantment ADV_SHARPNESS = new EnchantmentAdvancedDamage(0);
    public static Enchantment ADV_SMITE = new EnchantmentAdvancedDamage(1);
    public static Enchantment ADV_BANE_OF_ARTHROPODS = new EnchantmentAdvancedDamage(2);
    public static Enchantment VITAE = new EnchantmentVitae();
    public static Enchantment SWIFT = new EnchantmentSwift();
    public static Enchantment SAGES_BLESSING = new EnchantmentSagesBlessing();
    public static Enchantment ENDER_EYES = new EnchantmentEnderEyes();
    public static Enchantment FOCUS_IMPACT = new EnchantmentFocusImpact();
    public static Enchantment BONE_CRUSH = new EnchantmentBoneCrusher();
    public static Enchantment RANGE = new EnchantmentRange();
    public static Enchantment TREASURERS_EYES = new EnchantmentTreasurersEyes();
    public static Enchantment SWIFT_BLADE = new EnchantmentSwiftBlade();
    public static Enchantment SPARTAN_WEAPON = new EnchantmentSpartanWeapon();
    public static Enchantment PERPETUAL_STRIKE = new EnchantmentPerpetualStrike();
    public static Enchantment CLIMATE_TRANQUILITY = new EnchantmentClimateTranquility();
    public static Enchantment MOMENTUM = new EnchantmentMomentum();
    public static Enchantment ENDER_MENDING = new EnchantmentEnderMending();
    public static Enchantment SMART_ASS = new EnchantmentSmartAss();
    public static Enchantment WARRIORS_GRACE = new EnchantmentWarriorsGrace();
    public static Enchantment ENDERMARKSMEN = new EnchantmentEnderMarksmen();
    public static Enchantment ARES_BLESSING = new EnchantmentAresBlessing();
    public static Enchantment ALCHEMISTS_GRACE = new EnchantmentAlchemistsGrace();
    public static Enchantment CLOUD_WALKER = new EnchantmentCloudwalker();
    public static Enchantment FAST_FOOD = new EnchantmentFastFood();
    public static Enchantment NATURES_GRACE = new EnchantmentNaturesGrace();
    public static Enchantment ECOLOGICAL = new EnchantmentEcological();
    public static Enchantment PHOENIX_BLESSING = new EnchantmentPhoenixBlessing();
    public static Enchantment MIDAS_BLESSING = new EnchantmentMidasBlessing();
    public static Enchantment IFRIDS_GRACE = new EnchantmentIfritsGrace();
    public static Enchantment ICARUS_AEGIS = new EnchantmentIcarusAegis();
    public static Enchantment ENDER_LIBRARIAN = new EnchantmentEnderLibrarian();
    public static Enchantment DEMETERS_SOUL = new EnchantmentDemetersSoul();
    public static Enchantment ENDEST_REAP = new EnchantmentEndestReap();
    public static Enchantment PESTILENCES_ODIUM = new EnchantmentPestilencesOdium();
    public static Enchantment DEATHS_ODIUM = new EnchantmentDeathsOdium();
    public static Potion PESTILENCES_ODIUM_POTION = new PotionPestilencesOdium();
    public static Configuration CONFIG;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        UniqueEnchantments.registerEnchantments(BERSERKER, ADV_SHARPNESS, ADV_SMITE, ADV_BANE_OF_ARTHROPODS, VITAE, SWIFT, SAGES_BLESSING, ENDER_EYES, FOCUS_IMPACT, BONE_CRUSH, RANGE, TREASURERS_EYES);
        UniqueEnchantments.registerEnchantments(SWIFT_BLADE, SPARTAN_WEAPON, PERPETUAL_STRIKE, CLIMATE_TRANQUILITY, MOMENTUM, ENDER_MENDING, SMART_ASS);
        UniqueEnchantments.registerEnchantments(WARRIORS_GRACE, ENDERMARKSMEN, ARES_BLESSING, ALCHEMISTS_GRACE, CLOUD_WALKER, FAST_FOOD, NATURES_GRACE, ECOLOGICAL, PHOENIX_BLESSING, MIDAS_BLESSING, IFRIDS_GRACE, ICARUS_AEGIS, ENDER_LIBRARIAN, DEMETERS_SOUL, ENDEST_REAP);
        UniqueEnchantments.registerEnchantments(PESTILENCES_ODIUM, DEATHS_ODIUM);
        ForgeRegistries.POTIONS.register((IForgeRegistryEntry)PESTILENCES_ODIUM_POTION);
        MinecraftForge.EVENT_BUS.register((Object)EntityEvents.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)FirstAidHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)this);
        CONFIG = new Configuration(event.getSuggestedConfigurationFile());
        EntityEvents.INSTANCE.registerStorageTooltip(MIDAS_BLESSING, "tooltip.uniqee.stored.gold.name", EnchantmentMidasBlessing.GOLD_COUNTER);
        EntityEvents.INSTANCE.registerStorageTooltip(IFRIDS_GRACE, "tooltip.uniqee.stored.lava.name", EnchantmentIfritsGrace.LAVA_COUNT);
        EntityEvents.INSTANCE.registerStorageTooltip(ICARUS_AEGIS, "tooltip.uniqee.stored.feather.name", EnchantmentIcarusAegis.FEATHER_TAG);
        EntityEvents.INSTANCE.registerStorageTooltip(ENDER_MENDING, "tooltip.uniqee.stored.repair.name", "ender_mending");
        EntityEvents.INSTANCE.registerStorageTooltip(ENDEST_REAP, "tooltip.unqiuee.stored.reap.name", "reap_storage");
        EntityEvents.INSTANCE.registerAnvilHelper(MIDAS_BLESSING, EnchantmentMidasBlessing.VALIDATOR, EnchantmentMidasBlessing.GOLD_COUNTER);
        EntityEvents.INSTANCE.registerAnvilHelper(IFRIDS_GRACE, EnchantmentIfritsGrace.VALIDATOR, EnchantmentIfritsGrace.LAVA_COUNT);
        EntityEvents.INSTANCE.registerAnvilHelper(ICARUS_AEGIS, EnchantmentIcarusAegis.VALIDATOR, EnchantmentIcarusAegis.FEATHER_TAG);
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent event) {
        for (IToggleEnchantment ench : ENCHANTMENTS) {
            ench.loadIncompats();
        }
        UniqueEnchantments.loadConfig();
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.onClientLoad();
        }
        CropHarvestRegistry.INSTANCE.init();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new ReloadCommand());
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientLoad() {
        RenderManager manager = Minecraft.func_71410_x().func_175598_ae();
        for (RenderPlayer renderPlayer : manager.getSkinMap().values()) {
            renderPlayer.func_177094_a((LayerRenderer)new EnchantmentLayer());
        }
        for (Map.Entry entry : manager.field_78729_o.entrySet()) {
            if (!(entry.getValue() instanceof RenderLivingBase) || !AbstractSkeleton.class.isAssignableFrom((Class)entry.getKey()) && !EntityZombie.class.isAssignableFrom((Class)entry.getKey())) continue;
            ((RenderLivingBase)entry.getValue()).func_177094_a((LayerRenderer)new EnchantmentLayer());
        }
    }

    @SubscribeEvent
    public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent evt) {
        if (evt.getModID().equalsIgnoreCase("uniquee")) {
            return;
        }
        try {
            for (IToggleEnchantment ench : ENCHANTMENTS) {
                ench.loadFromConfig(CONFIG);
            }
            CONFIG.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadConfig() {
        try {
            CONFIG.load();
            for (IToggleEnchantment ench : ENCHANTMENTS) {
                ench.loadFromConfig(CONFIG);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            CONFIG.save();
        }
    }

    public static void registerEnchantments(Enchantment ... enchantments) {
        ForgeRegistries.ENCHANTMENTS.registerAll((IForgeRegistryEntry[])enchantments);
        for (Enchantment enchantment : enchantments) {
            if (!(enchantment instanceof IToggleEnchantment)) continue;
            ENCHANTMENTS.add((IToggleEnchantment)enchantment);
        }
    }

    public static class ReloadCommand
    extends CommandBase {
        public String func_71517_b() {
            return "uniquee";
        }

        public String func_71518_a(ICommandSender sender) {
            return "reloads the Unique Enchantments Config";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            sender.func_145747_a((ITextComponent)new TextComponentString("Reloading Config"));
            UniqueEnchantments.loadConfig();
            sender.func_145747_a((ITextComponent)new TextComponentString("Reloaded Config"));
        }
    }
}

