/*
 * Decompiled with CFR 0.152.
 */
package uniquee.enchantments.unique;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import uniquee.UniqueEnchantments;
import uniquee.enchantments.UniqueEnchantment;

public class EnchantmentEndestReap
extends UniqueEnchantment {
    public static final String REAP_STORAGE = "reap_storage";
    public static double BONUS_DAMAGE_LEVEL = 0.7;
    public static double REAP_MULTIPLIER = 0.005;
    static final Set<ResourceLocation> VALID_MOBS = new ObjectOpenHashSet();

    public EnchantmentEndestReap() {
        super(new UniqueEnchantment.DefaultData("endest_reap", Enchantment.Rarity.RARE, 4, true, 30, 6, 20), EnumEnchantmentType.WEAPON, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND, EntityEquipmentSlot.OFFHAND});
    }

    @Override
    public void loadIncompats() {
        this.addIncomats(Enchantments.field_185302_k, Enchantments.field_185296_A, UniqueEnchantments.ADV_SHARPNESS, UniqueEnchantments.ENDER_MENDING, UniqueEnchantments.SPARTAN_WEAPON, UniqueEnchantments.SAGES_BLESSING);
    }

    @Override
    public void loadData(Configuration config) {
        BONUS_DAMAGE_LEVEL = config.get(this.getConfigName(), "bonus_damage_level", 0.7).getDouble();
        REAP_MULTIPLIER = config.get(this.getConfigName(), "reap_multiplier", 0.005).getDouble();
        String[] result = config.get(this.getConfigName(), "validMobs", new String[]{"minecraft:ender_dragon", "minecraft:wither", "minecraft:shulker", "minecraft:elder_guardian", "minecraft:ravager", "minecraft:evoker"}).getStringList();
        VALID_MOBS.clear();
        for (int i = 0; i < result.length; ++i) {
            try {
                VALID_MOBS.add(new ResourceLocation(result[i]));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isValid(Entity entity) {
        return VALID_MOBS.contains(EntityList.func_191306_a(entity.getClass()));
    }
}

