/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.util;

import com.google.common.collect.ImmutableList;
import com.oitsjustjose.vtweaks.enchantment.Enchantments;
import com.oitsjustjose.vtweaks.util.HelperFunctions;
import com.oitsjustjose.vtweaks.util.ModConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IVanillaRecipeFactory;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@JEIPlugin
public class JEICompat
implements IModPlugin {
    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }

    public void register(IModRegistry registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IVanillaRecipeFactory factory = jeiHelpers.getVanillaRecipeFactory();
        if (ModConfig.misc.enableHorseArmorRecipes) {
            this.addAnvilRecipe(factory, registry, new ItemStack((Item)Items.field_151165_aa), new ItemStack((Item)Items.field_151165_aa), new ItemStack(Items.field_151138_bX));
            this.addAnvilRecipe(factory, registry, new ItemStack((Item)Items.field_151149_ai), new ItemStack((Item)Items.field_151149_ai), new ItemStack(Items.field_151136_bY));
            this.addAnvilRecipe(factory, registry, new ItemStack((Item)Items.field_151173_ae), new ItemStack((Item)Items.field_151173_ae), new ItemStack(Items.field_151125_bZ));
        }
        if (ModConfig.enchantments.enableLumbering) {
            ArrayList<ItemStack> axes = new ArrayList<ItemStack>();
            axes.add(new ItemStack(Items.field_151006_E));
            if (Loader.isModLoaded((String)"toolbox")) {
                for (String s : new String[]{"null", "diamond", "emerald", "quartz", "prismarine", "ender_pearl", "lapis", "biotite", "amethyst", "ruby", "peridot", "topaz", "tanzanite", "malachite", "sapphire", "amber", "obsidian", "aquamarine"}) {
                    NBTTagCompound comp = new NBTTagCompound();
                    comp.func_74778_a("ADORNMENT", s);
                    comp.func_74778_a("Haft", "wood");
                    comp.func_74778_a("Handle", "wood");
                    comp.func_74778_a("Head", "gold");
                    ItemStack toolboxAxe = new ItemStack((Item)Objects.requireNonNull(ForgeRegistries.ITEMS.getValue(new ResourceLocation("toolbox", "axe"))));
                    toolboxAxe.func_77982_d(comp);
                    axes.add(toolboxAxe);
                }
            }
            this.addAnvilRecipe(factory, registry, new ItemStack(Items.field_151099_bA), axes, HelperFunctions.getEnchantedBook(Enchantments.getInstance().lumbering));
        }
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
    }

    private void addAnvilRecipe(IVanillaRecipeFactory factory, IModRegistry registry, ItemStack inputLeft, ItemStack inputRight, ItemStack output) {
        ArrayList<ItemStack> rightTemp = new ArrayList<ItemStack>();
        ArrayList<ItemStack> outputTemp = new ArrayList<ItemStack>();
        rightTemp.add(inputRight);
        outputTemp.add(output);
        registry.addRecipes((Collection)ImmutableList.of((Object)factory.createAnvilRecipe(inputLeft, rightTemp, outputTemp)), "minecraft.anvil");
    }

    private void addAnvilRecipe(IVanillaRecipeFactory factory, IModRegistry registry, ItemStack inputLeft, ArrayList<ItemStack> inputRight, ItemStack output) {
        ArrayList<ItemStack> outputTemp = new ArrayList<ItemStack>();
        for (int i = 0; i < inputRight.size(); ++i) {
            outputTemp.add(output);
        }
        registry.addRecipes((Collection)ImmutableList.of((Object)factory.createAnvilRecipe(inputLeft, inputRight, outputTemp)), "minecraft.anvil");
    }
}

