/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.advancements;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.advancements.AbstractCriterionTrigger;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;

public class VampireActionTrigger
extends AbstractCriterionTrigger<Instance> {
    public static final ResourceLocation ID = new ResourceLocation("vampirism", "vampire_action");

    public VampireActionTrigger() {
        super(ID, Listeners::new);
    }

    @Nonnull
    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        Action action = Action.NONE;
        if (json.has("action")) {
            String name = json.get("action").getAsString();
            try {
                action = Action.valueOf(name.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                VampirismMod.log.w("VampireActionTrigger", "Action %s does not exist", name);
            }
        } else {
            VampirismMod.log.w("VampireActionTrigger", "Action not specified", new Object[0]);
        }
        return new Instance(action);
    }

    public void trigger(EntityPlayerMP player, Action action) {
        Listeners listeners = (Listeners)this.listenersForPlayers.get(player.func_192039_O());
        if (listeners != null) {
            listeners.trigger(action);
        }
    }

    static class Listeners
    extends AbstractCriterionTrigger.GenericListeners<Instance> {
        Listeners(PlayerAdvancements playerAdvancementsIn) {
            super(playerAdvancementsIn);
        }

        void trigger(Action action) {
            List list = null;
            for (ICriterionTrigger.Listener listener : this.playerListeners) {
                if (!((Instance)listener.func_192158_a()).trigger(action)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener listener1 : list) {
                    listener1.func_192159_a(this.playerAdvancements);
                }
            }
        }
    }

    static class Instance
    extends AbstractCriterionInstance {
        @Nonnull
        private final Action action;

        Instance(@Nonnull Action action) {
            super(ID);
            this.action = action;
        }

        boolean trigger(Action action) {
            return this.action == action;
        }
    }

    public static enum Action {
        SNIPED_IN_BAT,
        POISONOUS_BITE,
        PERFORM_RITUAL_INFUSION,
        BAT,
        SUCK_BLOOD,
        NONE;

    }
}

