/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.config;

import com.google.common.collect.ImmutableMap;
import de.teamlapen.vampirism.VampirismMod;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.StringUtils;

public class BloodGrinderValueLoader {
    private static final String TAG = "BloodValueGrinderLoader";
    private static final Map<ResourceLocation, Integer> bloodValues = new HashMap<ResourceLocation, Integer>();

    public static void init(File configDir) {
        File bloodConfigFile = new File(configDir, "vampirism_blood_values_grinder.txt");
        try {
            bloodValues.putAll(BloodGrinderValueLoader.loadBloodValuesFromReader(new InputStreamReader(BloodGrinderValueLoader.class.getResourceAsStream("/blood_values_grinder/default_blood_values.txt")), "default_blood_values.txt"));
        }
        catch (IOException e) {
            VampirismMod.log.bigWarning(TAG, "Could not read default blood grinder values, this should not happen and destroys the mod experience", new Object[0]);
            VampirismMod.log.e(TAG, e, "Exception", new Object[0]);
        }
        if (bloodConfigFile.exists()) {
            try {
                bloodValues.putAll(BloodGrinderValueLoader.loadBloodValuesFromReader(new FileReader(bloodConfigFile), bloodConfigFile.getName()));
                VampirismMod.log.i(TAG, "Successfully loaded additional blood grinder value file", new Object[0]);
            }
            catch (IOException e) {
                VampirismMod.log.e(TAG, "Could not read blood grinder values from config file %s", bloodConfigFile.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<ResourceLocation, Integer> loadBloodValuesFromReader(Reader r, String file) throws IOException {
        HashMap<ResourceLocation, Integer> bloodValues = new HashMap<ResourceLocation, Integer>();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(r);
            while ((line = br.readLine()) != null) {
                int val;
                if (line.startsWith("#") || StringUtils.isBlank((CharSequence)line)) continue;
                String[] p = line.split("=");
                if (p.length != 2) {
                    VampirismMod.log.w("ReadBlood", "Line %s  in %s is not formatted properly", line, file);
                    continue;
                }
                try {
                    val = Integer.parseInt(p[1]);
                }
                catch (NumberFormatException e) {
                    VampirismMod.log.w("ReadBlood", "Line %s  in %s is not formatted properly", line, file);
                    continue;
                }
                bloodValues.put(new ResourceLocation(p[0]), val);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            r.close();
        }
        return bloodValues;
    }

    public static void loadBloodValuesModCompat(String modid) {
        if (!Loader.isModLoaded((String)modid)) {
            return;
        }
        try {
            bloodValues.putAll(BloodGrinderValueLoader.loadBloodValuesFromReader(new InputStreamReader(BloodGrinderValueLoader.class.getResourceAsStream("/blood_values_grinder/" + modid + ".txt")), modid + ".txt"));
        }
        catch (IOException e) {
            VampirismMod.log.e(TAG, e, "[ModCompat]Could not read default blood values for mod %s, this should not happen", modid);
        }
        catch (NullPointerException e) {
            VampirismMod.log.e(TAG, e, "[ModCompat]Could not find packed (in JAR) blood value file for mod %s", modid);
        }
    }

    public static Map<ResourceLocation, Integer> getBloodGrinderValues() {
        return ImmutableMap.copyOf(bloodValues);
    }
}

