/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.config.Configs;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.world.gen.village.VillagePieceModChurch;
import de.teamlapen.vampirism.world.gen.village.VillagePieceTotem;
import de.teamlapen.vampirism.world.gen.village.VillagePieceTrainer;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModVillages {
    @GameRegistry.ObjectHolder(value="vampirism:hunter_expert")
    public static final VillagerRegistry.VillagerProfession profession_hunter_expert = (VillagerRegistry.VillagerProfession)UtilLib.getNull();
    @GameRegistry.ObjectHolder(value="vampirism:vampire_expert")
    public static final VillagerRegistry.VillagerProfession profession_vampire_expert = (VillagerRegistry.VillagerProfession)UtilLib.getNull();
    private static final String TAG = "ModVillages";

    static void init() {
        ModVillages.registerCreationHandlers();
        ModVillages.registerPieces();
        ModVillages.registerTrades();
    }

    private static void registerPieces() {
        MapGenStructureIO.func_143031_a(VillagePieceTrainer.class, (String)"Vampirism-TR");
        MapGenStructureIO.func_143031_a(VillagePieceModChurch.class, (String)"Vampirism-MC");
        MapGenStructureIO.func_143031_a(VillagePieceTotem.class, (String)"Vampirism-To");
    }

    private static void registerCreationHandlers() {
        if (!Configs.disable_all_worldgen) {
            VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillagePieceTrainer.CreationHandler());
            VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillagePieceModChurch.CreationHandler());
            VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillagePieceTotem.CreationHandler());
        }
    }

    static void modifyVillageSize(MapGenBase mapGenVillage) {
        if (mapGenVillage instanceof MapGenVillage) {
            try {
                ReflectionHelper.setPrivateValue(MapGenVillage.class, (Object)((MapGenVillage)mapGenVillage), (Object)Configs.village_size, (String[])new String[]{"size", "field_75054_f"});
            }
            catch (ReflectionHelper.UnableToAccessFieldException e) {
                VampirismMod.log.e(TAG, e, "Could not modify field 'terrainType' in MapGenVillage", new Object[0]);
            }
            try {
                ReflectionHelper.setPrivateValue(MapGenVillage.class, (Object)((MapGenVillage)mapGenVillage), (Object)Configs.village_density, (String[])new String[]{"distance", "field_82665_g"});
            }
            catch (ReflectionHelper.UnableToAccessFieldException e) {
                VampirismMod.log.e(TAG, e, "Could not modify field for village density in MapGenVillage", new Object[0]);
            }
            try {
                ReflectionHelper.setPrivateValue(MapGenVillage.class, (Object)((MapGenVillage)mapGenVillage), (Object)Configs.village_min_dist, (String[])new String[]{"minTownSeparation", "field_82666_h"});
            }
            catch (ReflectionHelper.UnableToAccessFieldException e) {
                VampirismMod.log.e(TAG, e, "Could not modify field for village min dist in MapGenVillage", new Object[0]);
            }
            VampirismMod.log.d(TAG, "Modified MapGenVillage fields.", new Object[0]);
        } else {
            VampirismMod.log.e(TAG, "VillageGen (%s) is not an instance of MapGenVillage, can't modify gen", mapGenVillage);
        }
    }

    private static void registerTrades() {
        VillagerRegistry.VillagerProfession priest = (VillagerRegistry.VillagerProfession)ForgeRegistries.VILLAGER_PROFESSIONS.getValue(new ResourceLocation("minecraft", "priest"));
        if (priest != null) {
            VillagerRegistry.VillagerCareer hunterPriest = new VillagerRegistry.VillagerCareer(priest, "vampirism.hunter_priest");
            hunterPriest.addTrade(1, new EntityVillager.ITradeList[]{new EntityVillager.EmeraldForItems(Items.field_151043_k, new EntityVillager.PriceInfo(8, 10))});
            hunterPriest.addTrade(2, new EntityVillager.ITradeList[]{new EntityVillager.ListItemForEmeralds((Item)ModItems.holy_water_bottle, new EntityVillager.PriceInfo(-8, -2))});
            hunterPriest.addTrade(3, new EntityVillager.ITradeList[]{new EntityVillager.ListItemForEmeralds(ModItems.holy_water_bottle.setTier(new ItemStack((Item)ModItems.holy_water_bottle), IItemWithTier.TIER.ENHANCED), new EntityVillager.PriceInfo(-5, -1))});
            hunterPriest.addTrade(3, new EntityVillager.ITradeList[]{new EntityVillager.ListItemForEmeralds((Item)ModItems.holy_salt, new EntityVillager.PriceInfo(-10, -3))});
            hunterPriest.addTrade(4, new EntityVillager.ITradeList[]{new EntityVillager.ListItemForEmeralds(Items.field_151062_by, new EntityVillager.PriceInfo(3, 11))});
        } else {
            VampirismMod.log.w(TAG, "Did not find vanilla priest profession", new Object[0]);
        }
        VillagerRegistry.VillagerCareer normal_hunter_expert = new VillagerRegistry.VillagerCareer(profession_hunter_expert, "vampirism.hunter_expert");
        normal_hunter_expert.addTrade(1, new EntityVillager.ITradeList[]{new EntityVillager.EmeraldForItems((Item)ModItems.vampire_fang, new EntityVillager.PriceInfo(20, 30))});
        normal_hunter_expert.addTrade(2, new EntityVillager.ITradeList[]{new EntityVillager.EmeraldForItems((Item)ModItems.vampire_book, new EntityVillager.PriceInfo(1, 1))});
        VillagerRegistry.VillagerCareer normal_vampire_expert = new VillagerRegistry.VillagerCareer(profession_vampire_expert, "vampirism.vampire_expert");
        normal_vampire_expert.addTrade(1, new EntityVillager.ITradeList[]{new EntityVillager.EmeraldForItems((Item)ModItems.vampire_fang, new EntityVillager.PriceInfo(20, 30))});
        normal_vampire_expert.addTrade(2, new EntityVillager.ITradeList[]{new EntityVillager.EmeraldForItems((Item)ModItems.vampire_book, new EntityVillager.PriceInfo(1, 1))});
    }

    static void registerProfessions(IForgeRegistry<VillagerRegistry.VillagerProfession> registry) {
        registry.register((IForgeRegistryEntry)new VillagerRegistry.VillagerProfession("vampirism:hunter_expert", "vampirism:textures/entity/villager_hunter_expert.png", "vampirism:textures/entity/villager_hunter_expert_zombie.png"));
        registry.register((IForgeRegistryEntry)new VillagerRegistry.VillagerProfession("vampirism:vampire_expert", "vampirism:textures/entity/villager_vampire_expert.png", "vampirism:textures/entity/villager_vampire_expert_zombie.png"));
    }
}

