/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.lib.network.ISyncable;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.BiteableEntry;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.entity.ExtendedCreatureDefaultImpl;
import de.teamlapen.vampirism.entity.converted.VampirismEntityRegistry;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.potion.PotionSanguinare;
import de.teamlapen.vampirism.util.REFERENCE;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class ExtendedCreature
implements ISyncable.ISyncableEntityCapabilityInst,
IExtendedCreatureVampirism {
    @CapabilityInject(value=IExtendedCreatureVampirism.class)
    public static final Capability<IExtendedCreatureVampirism> CAP = null;
    private static final String TAG = "ExtendedCreature";
    private static final String KEY_BLOOD = "bloodLevel";
    private static final String KEY_MAX_BLOOD = "maxBlood";
    private static final String POISONOUS_BLOOD = "poisonousBlood";
    private final EntityCreature entity;
    private final boolean canBecomeVampire;
    private boolean poisonousBlood;
    private boolean markForBloodCalculation = false;
    private int maxBlood;
    private int blood;

    public static IExtendedCreatureVampirism get(EntityCreature mob) {
        return (IExtendedCreatureVampirism)mob.getCapability(CAP, null);
    }

    public static void registerCapability() {
        CapabilityManager.INSTANCE.register(IExtendedCreatureVampirism.class, (Capability.IStorage)new Storage(), ExtendedCreatureDefaultImpl.class);
    }

    public static <Q extends EntityCreature> ICapabilityProvider createNewCapability(final Q creature) {
        return new ICapabilitySerializable<NBTTagCompound>(){
            Function<Q, IExtendedCreatureVampirism> constructor;
            IExtendedCreatureVampirism inst;
            {
                this.constructor = VampirismAPI.entityRegistry().getCustomExtendedCreatureConstructor(creature);
                this.inst = this.constructor == null ? new ExtendedCreature(creature) : this.constructor.apply(creature);
            }

            public void deserializeNBT(NBTTagCompound nbt) {
                CAP.getStorage().readNBT(CAP, (Object)this.inst, null, (NBTBase)nbt);
            }

            public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                return (T)(CAP.equals(capability) ? CAP.cast((Object)this.inst) : null);
            }

            public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                return CAP.equals(capability);
            }

            public NBTTagCompound serializeNBT() {
                return (NBTTagCompound)CAP.getStorage().writeNBT(CAP, (Object)this.inst, null);
            }
        };
    }

    public ExtendedCreature(EntityCreature entity) {
        this.entity = entity;
        BiteableEntry entry = VampirismAPI.entityRegistry().getEntry(entity);
        if (entry != null && entry.blood > 0) {
            this.maxBlood = entry.blood;
            this.canBecomeVampire = entry.convertible;
        } else {
            if (entry == null) {
                this.markForBloodCalculation = true;
            }
            this.maxBlood = -1;
            this.canBecomeVampire = false;
        }
        this.blood = this.maxBlood;
        this.poisonousBlood = false;
    }

    @Override
    public boolean canBeBitten(IVampire biter) {
        return this.getBlood() > 0;
    }

    @Override
    public boolean canBecomeVampire() {
        return this.canBecomeVampire;
    }

    @Override
    public int getBlood() {
        return this.blood;
    }

    @Override
    public void setBlood(int blood) {
        if (blood >= 0 && blood <= this.getMaxBlood() && this.getBlood() != -1) {
            this.blood = blood;
        }
    }

    @Override
    public float getBloodLevelRelative() {
        return (float)this.getBlood() / (float)this.getMaxBlood();
    }

    @Override
    public float getBloodSaturation() {
        return 1.0f;
    }

    @Override
    public ResourceLocation getCapKey() {
        return REFERENCE.EXTENDED_CREATURE_KEY;
    }

    @Override
    public EntityCreature getEntity() {
        return this.entity;
    }

    @Override
    public int getMaxBlood() {
        return this.maxBlood;
    }

    private void setMaxBlood(int blood) {
        this.maxBlood = blood;
        this.blood = blood;
    }

    @Override
    public int getTheEntityID() {
        return this.entity.func_145782_y();
    }

    @Override
    public void loadUpdateFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b(KEY_BLOOD)) {
            this.setBlood(nbt.func_74762_e(KEY_BLOOD));
        }
        if (nbt.func_74764_b(KEY_MAX_BLOOD)) {
            this.setBlood(nbt.func_74762_e(KEY_MAX_BLOOD));
        }
        if (nbt.func_74764_b(POISONOUS_BLOOD)) {
            this.setPoisonousBlood(nbt.func_74767_n(POISONOUS_BLOOD));
        }
    }

    @Override
    @Nullable
    public IConvertedCreature makeVampire() {
        if (this.canBecomeVampire()) {
            this.blood = 0;
            IConvertedCreature c = VampirismAPI.entityRegistry().convert(this.entity);
            if (c != null) {
                Entity e = (Entity)c;
                this.entity.func_70106_y();
                this.entity.func_130014_f_().func_72838_d(e);
            }
            return c;
        }
        return null;
    }

    @Override
    public int onBite(IVampire biter) {
        if (this.getBlood() <= 0) {
            return 0;
        }
        int amt = Math.max(1, this.getMaxBlood() / (biter instanceof VampirePlayer ? 6 : 2));
        if (amt >= this.blood) {
            amt = this.blood > 1 && biter.isAdvancedBiter() ? this.blood - 1 : this.blood;
        }
        this.blood -= amt;
        boolean killed = false;
        boolean converted = false;
        if (this.blood == 0) {
            if (this.canBecomeVampire && this.entity.func_70681_au().nextBoolean()) {
                if (VampirismMod.isRealism()) {
                    PotionSanguinare.addRandom((EntityLivingBase)this.entity, false);
                } else {
                    this.makeVampire();
                }
                converted = true;
            } else {
                this.entity.func_70097_a(DamageSource.field_76376_m, 1000.0f);
                killed = true;
            }
        }
        this.sync();
        if (this.entity instanceof EntityAgeable && ((EntityAgeable)this.entity).func_70874_b() < 0) {
            amt = Math.round((float)amt / 3.0f);
        }
        if (biter.isAdvancedBiter() && this.entity.func_70681_au().nextInt(4) == 0) {
            amt = 2 * amt;
        }
        return amt;
    }

    @Override
    public void onUpdate() {
        if (!this.entity.func_130014_f_().field_72995_K && this.blood > 0 && this.blood < this.getMaxBlood() && this.entity.field_70173_aa % 40 == 8) {
            this.entity.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 41));
            this.entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 41, 2));
            if (this.entity.func_70681_au().nextInt(Balance.mobProps.BLOOD_REGEN_CHANCE) == 0) {
                this.setBlood(this.getBlood() + 1);
            }
        }
        if (this.markForBloodCalculation) {
            BiteableEntry entry = VampirismEntityRegistry.getBiteableEntryManager().calculate(this.entity);
            if (entry != null) {
                this.setMaxBlood(entry.blood);
            }
            this.markForBloodCalculation = false;
        }
    }

    public String toString() {
        return super.toString() + " for entity (" + this.entity.toString() + ") [B" + this.blood + ",MB" + this.maxBlood + ",CV" + this.canBecomeVampire + "]";
    }

    @Override
    public void writeFullUpdateToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a(KEY_BLOOD, this.getBlood());
        nbt.func_74768_a(KEY_MAX_BLOOD, this.getBlood());
        nbt.func_74757_a(POISONOUS_BLOOD, this.hasPoisonousBlood());
    }

    private void loadNBTData(NBTTagCompound compound) {
        if (compound.func_74764_b(KEY_MAX_BLOOD)) {
            this.setMaxBlood(compound.func_74762_e(KEY_MAX_BLOOD));
        }
        if (compound.func_74764_b(KEY_BLOOD)) {
            this.setBlood(compound.func_74762_e(KEY_BLOOD));
        }
        if (compound.func_74764_b(POISONOUS_BLOOD)) {
            this.setPoisonousBlood(compound.func_74767_n(POISONOUS_BLOOD));
        }
    }

    private void saveNBTData(NBTTagCompound compound) {
        compound.func_74768_a(KEY_BLOOD, this.blood);
        compound.func_74768_a(KEY_MAX_BLOOD, this.maxBlood);
        compound.func_74757_a(POISONOUS_BLOOD, this.poisonousBlood);
    }

    private void sync() {
        HelperLib.sync(this, (Entity)this.getEntity(), false);
    }

    private void sync(NBTTagCompound data) {
        HelperLib.sync(this, data, (Entity)this.getEntity(), false);
    }

    @Override
    public boolean hasPoisonousBlood() {
        return this.poisonousBlood;
    }

    @Override
    public void setPoisonousBlood(boolean poisonous) {
        if (poisonous == !this.poisonousBlood) {
            this.poisonousBlood = poisonous;
            this.sync();
        }
    }

    private static class Storage
    implements Capability.IStorage<IExtendedCreatureVampirism> {
        private Storage() {
        }

        public void readNBT(Capability<IExtendedCreatureVampirism> capability, IExtendedCreatureVampirism instance, EnumFacing side, NBTBase nbt) {
            ((ExtendedCreature)instance).loadNBTData((NBTTagCompound)nbt);
        }

        public NBTBase writeNBT(Capability<IExtendedCreatureVampirism> capability, IExtendedCreatureVampirism instance, EnumFacing side) {
            NBTTagCompound nbt = new NBTTagCompound();
            ((ExtendedCreature)instance).saveNBTData(nbt);
            return nbt;
        }
    }
}

