/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.ai;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.village.Village;
import net.minecraft.village.VillageDoorInfo;

public class EntityAIMoveThroughVillageCustom
extends EntityAIBase {
    private final int randomTicksToResize;
    private final EntityCreature theEntity;
    private double movementSpeed;
    private Path entityPathNavigate;
    @Nullable
    private VillageDoorInfo doorInfo;
    private boolean isNocturnal;
    private List<VillageDoorInfo> doorList = NonNullList.func_191196_a();

    public EntityAIMoveThroughVillageCustom(EntityCreature theEntityIn, double movementSpeedIn, boolean isNocturnalIn, int randomTicksToResize) {
        this.theEntity = theEntityIn;
        this.movementSpeed = movementSpeedIn;
        this.isNocturnal = isNocturnalIn;
        this.randomTicksToResize = randomTicksToResize;
        this.func_75248_a(1);
        if (!(theEntityIn.func_70661_as() instanceof PathNavigateGround)) {
            throw new IllegalArgumentException("Unsupported mob for MoveThroughVillageGoal");
        }
    }

    public void func_75251_c() {
        if (this.doorInfo != null && (this.theEntity.func_70661_as().func_75500_f() || this.theEntity.func_174818_b(this.doorInfo.func_179852_d()) < 16.0)) {
            this.doorList.add(this.doorInfo);
        }
    }

    public boolean func_75253_b() {
        if (this.theEntity.func_70661_as().func_75500_f() || this.doorInfo == null) {
            return false;
        }
        float f = this.theEntity.field_70130_N + 4.0f;
        return this.theEntity.func_174818_b(this.doorInfo.func_179852_d()) > (double)(f * f);
    }

    public boolean func_75250_a() {
        this.resizeDoorList();
        if (this.isNocturnal && this.theEntity.func_130014_f_().func_72935_r()) {
            return false;
        }
        Village village = this.theEntity.func_130014_f_().func_175714_ae().func_176056_a(new BlockPos((Entity)this.theEntity), 0);
        if (village == null) {
            return false;
        }
        this.doorInfo = this.findNearestDoor(village);
        if (this.doorInfo == null) {
            return false;
        }
        PathNavigateGround pathnavigateground = (PathNavigateGround)this.theEntity.func_70661_as();
        boolean flag = pathnavigateground.func_179686_g();
        pathnavigateground.func_179688_b(false);
        this.entityPathNavigate = pathnavigateground.func_179680_a(this.doorInfo.func_179852_d());
        pathnavigateground.func_179688_b(flag);
        if (this.entityPathNavigate != null) {
            return true;
        }
        Vec3d vec3d = RandomPositionGenerator.func_75464_a((EntityCreature)this.theEntity, (int)10, (int)7, (Vec3d)new Vec3d((double)this.doorInfo.func_179852_d().func_177958_n(), (double)this.doorInfo.func_179852_d().func_177956_o(), (double)this.doorInfo.func_179852_d().func_177952_p()));
        if (vec3d == null) {
            return false;
        }
        pathnavigateground.func_179688_b(false);
        this.entityPathNavigate = this.theEntity.func_70661_as().func_75488_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
        pathnavigateground.func_179688_b(flag);
        return this.entityPathNavigate != null;
    }

    public void func_75249_e() {
        this.theEntity.func_70661_as().func_75484_a(this.entityPathNavigate, this.movementSpeed);
    }

    private boolean doesDoorListContain(@Nonnull VillageDoorInfo doorInfoIn) {
        for (VillageDoorInfo villagedoorinfo : this.doorList) {
            if (!doorInfoIn.func_179852_d().equals((Object)villagedoorinfo.func_179852_d())) continue;
            return true;
        }
        return false;
    }

    private VillageDoorInfo findNearestDoor(Village villageIn) {
        VillageDoorInfo villagedoorinfo = null;
        int i = Integer.MAX_VALUE;
        for (VillageDoorInfo villagedoorinfo1 : villageIn.func_75558_f()) {
            int j = villagedoorinfo1.func_75474_b(MathHelper.func_76128_c((double)this.theEntity.field_70165_t), MathHelper.func_76128_c((double)this.theEntity.field_70163_u), MathHelper.func_76128_c((double)this.theEntity.field_70161_v));
            if (j >= i || this.doesDoorListContain(villagedoorinfo1)) continue;
            villagedoorinfo = villagedoorinfo1;
            i = j;
        }
        return villagedoorinfo;
    }

    private void resizeDoorList() {
        if (this.doorList.size() > 5 && this.theEntity.func_70681_au().nextInt(this.randomTicksToResize) == 0) {
            this.doorList.remove(0);
        }
    }
}

