/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.convertible.IConvertingHandler;
import de.teamlapen.vampirism.api.items.IVampireFinisher;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.core.ModPotions;
import de.teamlapen.vampirism.entity.DamageHandler;
import de.teamlapen.vampirism.entity.EntityCrossbowArrow;
import de.teamlapen.vampirism.entity.EntitySoulOrb;
import de.teamlapen.vampirism.entity.converted.DefaultConvertingHandler;
import de.teamlapen.vampirism.util.Helper;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityConvertedHorse
extends EntityHorse
implements IConvertedCreature<EntityHorse> {
    private EnumStrength garlicCache = EnumStrength.NONE;
    private EntityHorse entityCreature;
    private boolean sundamageCache;
    private boolean dropSoul = false;
    protected boolean vulnerableToFire = true;

    public EntityConvertedHorse(World world) {
        super(world);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return VReference.VAMPIRE_CREATURE_ATTRIBUTE;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.875f;
    }

    @Override
    public EntityLivingBase getRepresentingEntity() {
        return this;
    }

    public String func_70005_c_() {
        return UtilLib.translate("entity.vampirism.vampire.name") + " " + UtilLib.translate("entity.Horse.name");
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        if (forSpawnCount) {
            return true;
        }
        return super.isCreatureType(type, forSpawnCount);
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        this.getConvertedHelper().dropConvertedItems((EntityCreature)this, this.entityCreature, wasRecentlyHit, lootingModifier);
    }

    protected IConvertingHandler.IDefaultHelper getConvertedHelper() {
        IConvertingHandler handler = VampirismAPI.entityRegistry().getEntry((EntityCreature)this.entityCreature).convertingHandler;
        if (handler instanceof ConvertingHandler) {
            return ((ConvertingHandler)handler).getHelper();
        }
        return null;
    }

    protected boolean func_70692_ba() {
        return !this.func_110248_bS();
    }

    @Override
    public boolean doesResistGarlic(EnumStrength strength) {
        return !strength.isStrongerThan(EnumStrength.NONE);
    }

    @Override
    public void drinkBlood(int amt, float saturationMod, boolean useRemaining) {
        this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, amt * 20));
    }

    @Override
    public EnumStrength isGettingGarlicDamage(boolean forceRefresh) {
        if (forceRefresh) {
            this.garlicCache = Helper.getGarlicStrength((Entity)this);
        }
        return this.garlicCache;
    }

    @Override
    public boolean isGettingSundamage(boolean forceRefresh) {
        if (!forceRefresh) {
            return this.sundamageCache;
        }
        this.sundamageCache = Helper.gettingSundamge((EntityLivingBase)this);
        return this.sundamageCache;
    }

    @Override
    public boolean isIgnoringSundamage() {
        return this.func_70644_a(ModPotions.sunscreen);
    }

    @Override
    public boolean useBlood(int amt, boolean allowPartial) {
        this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, amt * 20));
        return true;
    }

    @Override
    public boolean wantsBlood() {
        return false;
    }

    public void func_70636_d() {
        if (this.field_70173_aa % 40 == 1) {
            this.isGettingGarlicDamage(true);
        }
        if (this.field_70173_aa % 8 == 2) {
            this.isGettingSundamage(true);
        }
        if (!this.field_70170_p.field_72995_K) {
            double dmg;
            if (this.isGettingSundamage() && this.field_70173_aa % 40 == 11 && (dmg = this.func_110148_a(VReference.sunDamage).func_111126_e()) > 0.0) {
                this.func_70097_a(VReference.SUNDAMAGE, (float)dmg);
            }
            if (this.isGettingGarlicDamage() != EnumStrength.NONE) {
                DamageHandler.affectVampireGarlicAmbient(this, this.isGettingGarlicDamage(), this.field_70173_aa);
            }
            if (this.func_70089_S() && this.func_70090_H()) {
                this.func_70050_g(300);
                if (this.field_70173_aa % 16 == 4) {
                    this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 80, 0));
                }
            }
        }
        super.func_70636_d();
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (cause.func_76364_f() instanceof EntityCrossbowArrow && Helper.isHunter(cause.func_76346_g())) {
            this.dropSoul = true;
        } else if (cause.func_76364_f() instanceof EntityPlayer && Helper.isHunter(cause.func_76364_f())) {
            ItemStack weapon = ((EntityPlayer)cause.func_76364_f()).func_184614_ca();
            if (!weapon.func_190926_b() && weapon.func_77973_b() instanceof IVampireFinisher) {
                this.dropSoul = true;
            }
        } else {
            this.dropSoul = false;
        }
    }

    protected void func_70609_aI() {
        if (this.field_70725_aQ == 19 && !this.field_70170_p.field_72995_K && this.dropSoul && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
            this.field_70170_p.func_72838_d((Entity)new EntitySoulOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, EntitySoulOrb.TYPE.VAMPIRE));
        }
        super.func_70609_aI();
    }

    public boolean func_70097_a(DamageSource damageSource, float amount) {
        if (this.vulnerableToFire) {
            if (DamageSource.field_76372_a.equals(damageSource)) {
                return this.func_70097_a(VReference.VAMPIRE_IN_FIRE, this.calculateFireDamage(amount));
            }
            if (DamageSource.field_76370_b.equals(damageSource)) {
                return this.func_70097_a(VReference.VAMPIRE_ON_FIRE, this.calculateFireDamage(amount));
            }
        }
        return super.func_70097_a(damageSource, amount);
    }

    protected float calculateFireDamage(float amount) {
        return amount;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityCreature.class, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, VReference.HUNTER_FACTION), 10.0f, 1.0, 1.1));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIRestrictSun((EntityCreature)this));
        this.field_70728_aV = 2;
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, true, false, null)));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCreature.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(VReference.sunDamage).func_111128_a(Balance.mobProps.VAMPIRE_MOB_SUN_DAMAGE);
    }

    protected void updateEnttityAttributes() {
        IConvertingHandler.IDefaultHelper helper = this.getConvertedHelper();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(helper.getConvertedMaxHealth(this.entityCreature));
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(helper.getConvertedKnockbackResistance(this.entityCreature));
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(helper.getConvertedSpeed(this.entityCreature));
    }

    protected void setEntityCreature(EntityHorse creature) {
        this.entityCreature = creature;
    }

    public static class ConvertingHandler
    extends DefaultConvertingHandler<EntityHorse> {
        public ConvertingHandler() {
            super(null);
        }

        @Override
        public IConvertedCreature<EntityHorse> createFrom(EntityHorse entity) {
            EntityConvertedHorse converted = new EntityConvertedHorse(entity.field_70170_p);
            this.copyImportantStuff(converted, entity);
            converted.func_184221_a(MathHelper.func_180182_a((Random)converted.field_70146_Z));
            converted.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 200, 2));
            return converted;
        }

        protected void copyImportantStuff(EntityConvertedHorse converted, EntityHorse entity) {
            NBTTagCompound nbt = new NBTTagCompound();
            entity.func_189511_e(nbt);
            converted.func_70020_e(nbt);
            converted.setEntityCreature(entity);
            converted.updateEnttityAttributes();
            converted.func_70606_j(converted.func_110138_aP() / 3.0f * 2.0f);
        }
    }
}

