/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IHunterWeaponRecipe;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ShapedHunterWeaponRecipe
implements IHunterWeaponRecipe {
    public final int recipeWidth;
    public final int recipeHeight;
    public final ItemStack[] recipeItems;
    private final int requiredHunterLevel;
    @Nonnull
    private final ISkill[] requiredHunterSkills;
    private final int requiredLavaUnits;
    @Nonnull
    private final ItemStack recipeOutput;

    public ShapedHunterWeaponRecipe(int width, int height, ItemStack[] input, @Nonnull ItemStack output, int requiredHunterLevel, @Nonnull ISkill[] requiredHunterSkills, int requiredLavaUnits) {
        assert (!output.func_190926_b());
        this.recipeWidth = width;
        this.recipeHeight = height;
        this.recipeItems = input;
        this.recipeOutput = output;
        this.requiredHunterLevel = requiredHunterLevel;
        this.requiredHunterSkills = requiredHunterSkills;
        this.requiredLavaUnits = requiredLavaUnits;
    }

    @Override
    public int getMinHunterLevel() {
        return this.requiredHunterLevel;
    }

    @Override
    @Nonnull
    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    @Override
    public int getRequiredLavaUnits() {
        return this.requiredLavaUnits;
    }

    @Override
    @Nonnull
    public ISkill[] getRequiredSkills() {
        return this.requiredHunterSkills;
    }

    @Override
    public boolean matches(InventoryCrafting inv, World worldIn) {
        for (int x = 0; x <= 4 - this.recipeWidth; ++x) {
            for (int y = 0; y <= 4 - this.recipeHeight; ++y) {
                if (this.checkMatch(inv, x, y, true)) {
                    return true;
                }
                if (!this.checkMatch(inv, x, y, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(InventoryCrafting inv, int startRow, int startColumn, boolean flip) {
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                int k = x - startRow;
                int l = y - startColumn;
                ItemStack itemStack = ItemStack.field_190927_a;
                if (k >= 0 && l >= 0 && k < this.recipeWidth && l < this.recipeHeight) {
                    itemStack = flip ? this.recipeItems[this.recipeWidth - k - 1 + l * this.recipeWidth] : this.recipeItems[k + l * this.recipeWidth];
                }
                ItemStack itemstack1 = inv.func_70463_b(x, y);
                if (itemStack.func_190926_b() && itemstack1.func_190926_b()) continue;
                if (itemStack.func_190926_b() || itemstack1.func_190926_b()) {
                    return false;
                }
                if (itemStack.func_77973_b() != itemstack1.func_77973_b()) {
                    return false;
                }
                if (itemStack.func_77960_j() == Short.MAX_VALUE || itemStack.func_77960_j() == itemstack1.func_77960_j()) continue;
                return false;
            }
        }
        return true;
    }
}

