/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import com.google.common.collect.Multimap;
import de.teamlapen.vampirism.items.VampirismItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class VampirismItemWeapon
extends VampirismItem {
    private final float attackDamage;
    private final Item.ToolMaterial material;
    private final float attackSpeed;

    public VampirismItemWeapon(String regName, Item.ToolMaterial material) {
        this(regName, material, 0.4f);
    }

    public VampirismItemWeapon(String regName, Item.ToolMaterial material, float attackSpeedModifier) {
        this(regName, material, attackSpeedModifier, 3.0f + material.func_78000_c());
    }

    public VampirismItemWeapon(String regName, Item.ToolMaterial material, float attackSpeedModifier, float attackDamage) {
        super(regName);
        this.material = material;
        this.field_77777_bU = 1;
        this.func_77656_e(material.func_77997_a());
        this.attackDamage = attackDamage;
        this.attackSpeed = attackSpeedModifier;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (flagIn.func_194127_a()) {
            tooltip.add("ModDamage: " + this.getAttackDamage(stack));
            tooltip.add("ModSpeed: " + this.getAttackSpeed(stack));
        }
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(equipmentSlot, stack);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.getAttackDamage(stack), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)(-(1.0f - this.getAttackSpeed(stack))), 1));
        }
        return multimap;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemStack mat = this.material.getRepairItemStack();
        if (!mat.func_190926_b() && OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    public int func_77619_b() {
        return this.material.func_77995_e();
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(1, attacker);
        return true;
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if ((double)state.func_185887_b(worldIn, pos) != 0.0) {
            stack.func_77972_a(2, entityLiving);
        }
        return true;
    }

    protected float getAttackDamage(ItemStack stack) {
        return this.attackDamage;
    }

    protected float getAttackSpeed(ItemStack stack) {
        return this.attackSpeed;
    }
}

