/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.guide.pages;

import amerifrance.guideapi.api.IRecipeRenderer;
import amerifrance.guideapi.api.impl.Book;
import amerifrance.guideapi.api.impl.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.impl.abstraction.EntryAbstract;
import amerifrance.guideapi.api.util.GuiHelper;
import amerifrance.guideapi.gui.GuiBase;
import com.google.common.collect.Lists;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IHunterWeaponRecipe;
import de.teamlapen.vampirism.core.ModBlocks;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BasicWeaponTableRecipeRenderer<T extends IHunterWeaponRecipe>
implements IRecipeRenderer {
    private final Random rand = new Random();
    protected T recipe;
    protected List<String> tooltips = Lists.newArrayList();
    private long lastCycle = -1L;
    private int cycleIdx = 0;

    public BasicWeaponTableRecipeRenderer(T recipe) {
        this.recipe = recipe;
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, GuiBase guiBase, FontRenderer fontRendererObj) {
        Minecraft mc = Minecraft.func_71410_x();
        long time = mc.field_71441_e.func_82737_E();
        if (this.lastCycle < 0L || this.lastCycle < time - 20L) {
            if (this.lastCycle > 0L) {
                ++this.cycleIdx;
                this.cycleIdx = Math.max(0, this.cycleIdx);
            }
            this.lastCycle = mc.field_71441_e.func_82737_E();
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("vampirismguide", "textures/gui/weapon_table_recipe.png"));
        guiBase.func_73729_b(guiLeft + 42, guiTop + 43, 0, 0, 110, 75);
        guiBase.func_73732_a(fontRendererObj, ModBlocks.weapon_table.func_149732_F(), guiLeft + guiBase.xSize / 2, guiTop + 12, 0);
        guiBase.func_73732_a(fontRendererObj, "\u00a7o" + this.getRecipeName() + "\u00a7r", guiLeft + guiBase.xSize / 2, guiTop + 14 + fontRendererObj.field_78288_b, 0);
        int outputX = 105 + (guiLeft + guiBase.xSize / 7);
        int outputY = 34 + (guiTop + guiBase.xSize / 5);
        ItemStack stack = this.recipe.getRecipeOutput();
        if (!stack.func_190926_b() && stack.func_77952_i() == Short.MAX_VALUE) {
            NonNullList subItems = NonNullList.func_191196_a();
            stack.func_77973_b().func_150895_a(stack.func_77973_b().func_77640_w(), subItems);
            stack = (ItemStack)subItems.get(this.getRandomizedCycle(0, subItems.size()));
        }
        GuiHelper.drawItemStack((ItemStack)stack, (int)outputX, (int)outputY);
        if (GuiHelper.isMouseBetween((int)mouseX, (int)mouseY, (int)outputX, (int)outputY, (int)15, (int)15)) {
            this.tooltips = GuiHelper.getTooltip((ItemStack)this.recipe.getRecipeOutput());
        }
        if (this.recipe.getRequiredLavaUnits() > 0) {
            GuiHelper.drawItemStack((ItemStack)new ItemStack(Items.field_151129_at), (int)(outputX - 16), (int)(outputY + 21));
        }
        int y = guiTop + 120;
        if (this.recipe.getMinHunterLevel() > 1) {
            String level = UtilLib.translateFormatted("gui.vampirism.hunter_weapon_table.level", this.recipe.getMinHunterLevel());
            guiBase.func_73731_b(fontRendererObj, level, guiLeft + 40, y, Color.gray.getRGB());
            y += fontRendererObj.field_78288_b + 2;
        }
        if (this.recipe.getRequiredSkills().length > 0) {
            StringBuilder skills = new StringBuilder();
            for (ISkill skill : this.recipe.getRequiredSkills()) {
                skills.append("\n\u00a7o").append(UtilLib.translate(skill.getUnlocalizedName())).append("\u00a7r ");
            }
            String skillText = UtilLib.translateFormatted("gui.vampirism.hunter_weapon_table.skill", skills.toString());
            fontRendererObj.func_78279_b(skillText, guiLeft + 40, y, 110, Color.gray.getRGB());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawExtras(Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, GuiBase guiBase, FontRenderer fontRendererObj) {
        guiBase.func_146283_a(this.tooltips, mouseX, mouseY);
        this.tooltips.clear();
    }

    @SideOnly(value=Side.CLIENT)
    protected void drawStack(ItemStack stack, int index, int stackX, int stackY, int mouseX, int mouseY) {
        if (!stack.func_190926_b()) {
            if (stack.func_77952_i() == Short.MAX_VALUE) {
                NonNullList subItems = NonNullList.func_191196_a();
                stack.func_77973_b().func_150895_a(stack.func_77973_b().func_77640_w(), subItems);
                stack = (ItemStack)subItems.get(this.getRandomizedCycle(index, subItems.size()));
            }
            GuiHelper.drawItemStack((ItemStack)stack, (int)stackX, (int)stackY);
            if (GuiHelper.isMouseBetween((int)mouseX, (int)mouseY, (int)stackX, (int)stackY, (int)15, (int)15)) {
                this.tooltips = GuiHelper.getTooltip((ItemStack)stack);
            }
        }
    }

    protected int getRandomizedCycle(int index, int max) {
        this.rand.setSeed(index);
        return (index + this.rand.nextInt(max) + this.cycleIdx) % max;
    }

    protected String getRecipeName() {
        return UtilLib.translate("text.shaped.crafting");
    }
}

