/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.skills;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.DefaultSkill;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class VampirismSkill<T extends IFactionPlayer>
extends DefaultSkill<T> {
    private String description = null;

    public VampirismSkill(IPlayableFaction<T> faction) {
        super(faction);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getIconLoc() {
        return null;
    }

    @Override
    public String getLocalizedDescription() {
        return this.description == null ? null : UtilLib.translate(this.description);
    }

    @Override
    public String getUnlocalizedName() {
        return "text.vampirism.skill." + this.getRegistryName().func_110623_a();
    }

    public void setHasDefaultDescription() {
        this.description = "text.vampirism.skill." + this.getRegistryName().func_110623_a() + ".desc";
    }

    public static class SimpleVampireSkill
    extends VampirismSkill<IVampirePlayer> {
        private final int u;
        private final int v;

        @Deprecated
        public SimpleVampireSkill(String id, int u, int v, boolean desc) {
            this(new ResourceLocation("vampirism", id), u, v, desc);
        }

        public SimpleVampireSkill(ResourceLocation id, int u, int v, boolean desc) {
            super(VReference.VAMPIRE_FACTION);
            this.setRegistryName(id);
            this.u = u;
            this.v = v;
            if (desc) {
                this.setHasDefaultDescription();
            }
        }

        @Override
        public int getMinU() {
            return this.u;
        }

        @Override
        public int getMinV() {
            return this.v;
        }
    }

    public static class SimpleHunterSkill
    extends VampirismSkill<IHunterPlayer> {
        private final int u;
        private final int v;

        public SimpleHunterSkill(ResourceLocation id, int u, int v, boolean desc) {
            super(VReference.HUNTER_FACTION);
            this.setRegistryName(id);
            this.u = u;
            this.v = v;
            if (desc) {
                this.setHasDefaultDescription();
            }
        }

        @Deprecated
        public SimpleHunterSkill(String id, int u, int v, boolean desc) {
            this(new ResourceLocation("vampirism", id), u, v, desc);
        }

        @Override
        public int getMinU() {
            return this.u;
        }

        @Override
        public int getMinV() {
            return this.v;
        }
    }
}

