/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.potion.blood;

import com.google.common.collect.Lists;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.items.IBloodPotionCategory;
import de.teamlapen.vampirism.api.items.IBloodPotionEffect;
import de.teamlapen.vampirism.api.items.IBloodPotionRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

class BloodPotionCategory
implements IBloodPotionCategory {
    @Nullable
    private final String unlocDesc;
    private final String id;
    private final List<ItemStack> exactItems = NonNullList.func_191196_a();
    private final List<Item> items = Lists.newLinkedList();
    private final List<IBloodPotionRegistry.WeightedEffect> effects = Lists.newArrayList();

    BloodPotionCategory(String id, @Nullable String unlocDesc) {
        this.unlocDesc = unlocDesc;
        this.id = id;
    }

    public void addEffect(IBloodPotionEffect effect, int weight) {
        this.effects.add(new IBloodPotionRegistry.WeightedEffect(effect, weight));
    }

    @Override
    public void addItem(Item item) {
        this.items.add(item);
    }

    @Override
    public void addItem(Block block) {
        this.items.add(Item.func_150898_a((Block)block));
    }

    @Override
    public void addItemExact(@Nonnull ItemStack stack) {
        this.exactItems.add(stack);
    }

    @Override
    public void addItems(Object ... items) {
        for (Object item : items) {
            if (item instanceof Item) {
                this.addItem((Item)item);
                continue;
            }
            if (item instanceof Block) {
                this.addItem((Block)item);
                continue;
            }
            if (item instanceof ItemStack) {
                this.addItemExact((ItemStack)item);
                continue;
            }
            VampirismMod.log.w("BloodPotionCategory", "Failed to add item '%s' of unkown type", item);
        }
    }

    @Override
    public boolean containsItem(@Nonnull ItemStack stack) {
        Item item = stack.func_77973_b();
        if (this.items.contains(item)) {
            return true;
        }
        for (ItemStack next : this.exactItems) {
            if (stack.func_77973_b() != next.func_77973_b() || stack.func_77952_i() != next.func_77952_i() || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)next)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<IBloodPotionRegistry.WeightedEffect> getEffectsCopy() {
        ArrayList copied = Lists.newArrayList();
        for (IBloodPotionRegistry.WeightedEffect effect : this.effects) {
            copied.add(effect.copy());
        }
        return copied;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getUnlocDescription() {
        return this.unlocDesc == null ? "" : this.unlocDesc;
    }

    public String toString() {
        return "BloodPotionCategory{items=" + this.items + ", unlocDesc='" + this.unlocDesc + '\'' + ", exactItems=" + this.exactItems + '}';
    }
}

