/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tileentity;

import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.lib.lib.inventory.InventorySlot;
import de.teamlapen.lib.lib.tile.InventoryTileEntity;
import de.teamlapen.vampirism.api.general.BloodConversionRegistry;
import de.teamlapen.vampirism.core.ModFluids;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TileGrinder
extends InventoryTileEntity
implements ITickable {
    private int cooldownPull = 0;
    private int cooldownProcess = 0;
    private IItemHandler itemHandler = new InvWrapper((IInventory)this);

    private static boolean canProcess(ItemStack stack) {
        return BloodConversionRegistry.getImpureBloodValue(stack) > 0;
    }

    protected static List<EntityItem> getCaptureItems(World worldIn, BlockPos pos) {
        int posX = pos.func_177958_n();
        int posY = pos.func_177956_o();
        int posZ = pos.func_177952_p();
        return worldIn.func_175647_a(EntityItem.class, new AxisAlignedBB((double)posX, (double)posY + 0.5, (double)posZ, (double)posX + 1.0, (double)posY + 1.5, (double)posZ + 1.0), EntitySelectors.field_94557_a);
    }

    public TileGrinder() {
        super(new InventorySlot[]{new InventorySlot(TileGrinder::canProcess, 80, 34)});
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if ((facing == null || facing != EnumFacing.DOWN) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public String func_70005_c_() {
        return "tile.vampirism.blood_grinder.name";
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return (facing == null || facing != EnumFacing.DOWN) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.cooldownPull = tagCompound.func_74762_e("cooldown_pull");
        this.cooldownProcess = tagCompound.func_74762_e("cooldown_process");
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            --this.cooldownPull;
            if (this.cooldownPull <= 0) {
                this.cooldownPull = 10;
                this.updatePull();
            }
            --this.cooldownProcess;
            if (this.cooldownProcess <= 0) {
                this.cooldownProcess = 10;
                this.updateProcess();
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("cooldown_pull", this.cooldownPull);
        compound.func_74768_a("cooldown_process", this.cooldownProcess);
        return super.func_189515_b(compound);
    }

    private boolean pullItems() {
        IItemHandler handler = InventoryHelper.tryGetItemHandler((IBlockAccess)this.field_145850_b, this.field_174879_c.func_177984_a(), EnumFacing.DOWN);
        if (handler != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack extracted = handler.extractItem(i, 1, true);
                if (extracted.func_190926_b()) continue;
                for (int j = 0; j < this.itemHandler.getSlots(); ++j) {
                    ItemStack simulated = this.itemHandler.insertItem(j, extracted, true);
                    if (!simulated.func_190926_b()) continue;
                    extracted = handler.extractItem(i, 1, false);
                    this.itemHandler.insertItem(j, extracted, false);
                    return true;
                }
            }
        }
        for (EntityItem entityItem : TileGrinder.getCaptureItems(this.field_145850_b, this.field_174879_c)) {
            ItemStack stack = entityItem.func_92059_d();
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                ItemStack stack2 = this.itemHandler.insertItem(i, stack, true);
                if (!stack2.func_190926_b()) continue;
                stack2 = this.itemHandler.insertItem(i, stack, false);
                if (stack2.func_190916_E() < stack.func_190916_E()) {
                    entityItem.func_70106_y();
                } else {
                    entityItem.func_92058_a(stack2);
                }
                return true;
            }
        }
        return false;
    }

    private void updateProcess() {
        if (!this.func_191420_l()) {
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                int filled;
                ItemStack stack = this.itemHandler.extractItem(i, 1, true);
                int blood = BloodConversionRegistry.getImpureBloodValue(stack);
                if (blood <= 0) continue;
                FluidStack fluid = new FluidStack(ModFluids.impure_blood, blood);
                IFluidHandler handler = FluidUtil.getFluidHandler((World)this.func_145831_w(), (BlockPos)this.field_174879_c.func_177977_b(), (EnumFacing)EnumFacing.UP);
                if (handler == null || !((float)(filled = handler.fill(fluid, false)) >= 0.9f * (float)blood)) continue;
                ItemStack extractedStack = this.itemHandler.extractItem(i, 1, false);
                handler.fill(fluid, true);
                this.cooldownProcess = MathHelper.func_76125_a((int)(20 * filled / 100), (int)20, (int)100);
            }
        }
    }

    private boolean updatePull() {
        if (!this.isFull()) {
            boolean flag = this.pullItems();
            if (flag) {
                this.cooldownPull = 20;
            }
            return flag;
        }
        return false;
    }
}

