/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tileentity;

import de.teamlapen.lib.lib.util.SimpleSpawnerLogic;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.entity.hunter.EntityBasicHunter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.IFixableData;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileTent
extends TileEntity
implements ITickable {
    private SimpleSpawnerLogic spawnerLogic = new SimpleSpawnerLogic(){

        @Override
        public BlockPos getSpawnerPosition() {
            return TileTent.this.func_174877_v();
        }

        @Override
        public World getSpawnerWorld() {
            return TileTent.this.field_145850_b;
        }

        @Override
        protected void onReset() {
        }

        @Override
        protected void onSpawned(Entity e) {
            super.onSpawned(e);
            if (e instanceof EntityBasicHunter) {
                ((EntityBasicHunter)e).makeCampHunter(this.getSpawningBox());
            }
        }
    };
    private boolean spawn = false;

    public static IFixableData getTentFixer() {
        return new IFixableData(){

            @Nonnull
            public NBTTagCompound func_188217_a(NBTTagCompound compound) {
                String id = compound.func_74779_i("id");
                if ("vampirism:vampire_hunter".equals(id) || "vampirism:vampireHunter".equals(id)) {
                    compound.func_74778_a("id", "vampirism:tent");
                    NBTTagCompound logic = new NBTTagCompound();
                    logic.func_74778_a("id", "vampirism:vampire_hunter");
                    logic.func_74768_a("min_delay", compound.func_74762_e("min_delay"));
                    logic.func_74768_a("max_delay", compound.func_74762_e("max_delay"));
                    logic.func_74768_a("max_nearby", compound.func_74762_e("max_nearby"));
                    logic.func_74768_a("delay", compound.func_74762_e("delay"));
                    logic.func_74768_a("activate_range", compound.func_74762_e("activate_range"));
                    logic.func_74768_a("spawn_range", compound.func_74762_e("spawn_range"));
                    logic.func_74768_a("spawn_count", compound.func_74762_e("spawn_count"));
                    compound.func_74782_a("spawner_logic", (NBTBase)logic);
                    compound.func_82580_o("min_delay");
                    compound.func_82580_o("max_delay");
                    compound.func_82580_o("max_nearby");
                    compound.func_82580_o("delay");
                    compound.func_82580_o("activate_range");
                    compound.func_82580_o("spawn_range");
                    compound.func_82580_o("spawn_count");
                }
                return compound;
            }

            public int func_188216_a() {
                return 4;
            }
        };
    }

    public TileTent() {
        this.spawnerLogic.setEntityName(new ResourceLocation("vampirism", "vampire_hunter"));
        this.spawnerLogic.setActivateRange(64);
        this.spawnerLogic.setSpawnRange(6);
        this.spawnerLogic.setMinSpawnDelay(600);
        this.spawnerLogic.setMaxSpawnDelay(1000);
        this.spawnerLogic.setMaxNearbyEntities(2);
        this.spawnerLogic.setLimitTotalEntities(VReference.HUNTER_CREATURE_TYPE);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72314_b(1.0, 0.0, 1.0);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return null;
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean hasFastRenderer() {
        return super.hasFastRenderer();
    }

    public boolean isSpawner() {
        return this.spawn;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("spawner_logic")) {
            this.spawnerLogic.readFromNbt(nbt.func_74775_l("spawner_logic"));
        }
        this.spawn = nbt.func_74767_n("spawn");
    }

    public boolean func_145842_c(int id, int type) {
        return this.spawnerLogic.setDelayToMin(id) || super.func_145842_c(id, type);
    }

    public void setSpawn(boolean spawn) {
        this.spawn = spawn;
    }

    public void func_73660_a() {
        if (this.spawnerLogic.getSpawnedToday() >= Balance.general.HUNTER_CAMP_MAX_SPAWN) {
            this.spawnerLogic.setSpawn(false);
        }
        if (this.spawn) {
            this.spawnerLogic.updateSpawner();
            if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_72820_D() % 64L == 0L && this.field_145850_b.field_72982_D.func_176056_a(this.field_174879_c, 5) != null) {
                this.spawn = false;
            }
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound nbt = super.func_189515_b(compound);
        NBTTagCompound logic = new NBTTagCompound();
        this.spawnerLogic.writeToNbt(logic);
        nbt.func_74782_a("spawner_logic", (NBTBase)logic);
        nbt.func_74757_a("spawn", this.spawn);
        return nbt;
    }
}

