/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tileentity;

import de.teamlapen.lib.VampLib;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.IAggressiveVillager;
import de.teamlapen.vampirism.api.entity.IVillageCaptureEntity;
import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.event.VampirismVillageEvent;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.entity.EntityFactionVillager;
import de.teamlapen.vampirism.entity.EntityVampirism;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.converted.EntityConvertedVillager;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.hunter.EntityAggressiveVillager;
import de.teamlapen.vampirism.entity.hunter.EntityHunterBase;
import de.teamlapen.vampirism.entity.hunter.EntityHunterFactionVillager;
import de.teamlapen.vampirism.entity.hunter.EntityHunterTrainer;
import de.teamlapen.vampirism.entity.hunter.EntityHunterTrainerDummy;
import de.teamlapen.vampirism.entity.vampire.EntityVampireBase;
import de.teamlapen.vampirism.entity.vampire.EntityVampireFactionVillager;
import de.teamlapen.vampirism.potion.PotionSanguinare;
import de.teamlapen.vampirism.util.ModEventFactory;
import de.teamlapen.vampirism.world.villages.VampirismVillage;
import de.teamlapen.vampirism.world.villages.VampirismVillageHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ITickable;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileTotem
extends TileEntity
implements ITickable {
    private static final int NOTIFY_DISTANCE_SQ = 40000;
    private static final String TAG = "TileTotem";
    private static final int DURATION_PHASE_1 = 60;
    private final Random rng = new Random();
    private static final IntHashMap<HashMap<BlockPos, StructureBoundingBox>> vampireVillages = new IntHashMap();
    private final BossInfoServer captureInfo = new BossInfoServer((ITextComponent)new TextComponentTranslation("text.vampirism.village.bossinfo.capture", new Object[0]), BossInfo.Color.YELLOW, BossInfo.Overlay.PROGRESS);
    private boolean force_village_update = true;
    private boolean isComplete;
    private int defenderMax = 0;
    private boolean insideVillage;
    @SideOnly(value=Side.CLIENT)
    private long beamRenderCounter;
    @SideOnly(value=Side.CLIENT)
    private float beamRenderScale;
    private AxisAlignedBB affectedArea = null;
    private AxisAlignedBB affectedAreaReduced = null;
    @Nullable
    private IPlayableFaction controllingFaction;
    private float[] baseColors = EnumDyeColor.WHITE.func_193349_f();
    private float[] capturingColors = EnumDyeColor.WHITE.func_193349_f();
    @Nullable
    private IPlayableFaction forced_faction;
    private boolean forced_faction_check_trainer;
    private int forced_faction_timer = 0;
    @Nullable
    private IPlayableFaction capturingFaction;
    private CAPTURE_PHASE capture_phase = null;
    private int capture_abort_timer;
    private int capture_remainingEnemies_cache;
    private int capture_timer;

    public static boolean isInsideVampireAreaCached(int dimension, BlockPos pos) {
        HashMap map = (HashMap)vampireVillages.func_76041_a(dimension);
        if (map != null) {
            for (StructureBoundingBox bb : map.values()) {
                if (!bb.func_175898_b((Vec3i)pos)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static IVillageCaptureEntity makeAggressive(EntityVillager villager, @Nullable VampirismVillage v) {
        VampirismVillageEvent.MakeAggressive event = new VampirismVillageEvent.MakeAggressive(v, villager);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            IVillageCaptureEntity aggressive = event.getAggressiveVillager();
            if (aggressive != null) {
                villager.func_130014_f_().func_72838_d((Entity)aggressive);
                villager.func_70106_y();
            }
            return aggressive;
        }
        EntityAggressiveVillager hunter = EntityAggressiveVillager.makeHunter(villager);
        villager.func_130014_f_().func_72838_d((Entity)hunter);
        villager.func_70106_y();
        return hunter;
    }

    public static void clearCacheForDimension(int i) {
        Map m = (Map)vampireVillages.func_76041_a(i);
        if (m != null) {
            m.clear();
        }
    }

    public boolean canPlayerRemoveBlock(EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        IPlayableFaction faction = FactionPlayerHandler.get(player).getCurrentFaction();
        if (this.controllingFaction == null) {
            if (this.capturingFaction == null || this.capturingFaction.equals(faction)) {
                return true;
            }
            if (!this.field_145850_b.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("text.vampirism.village.totem_destroy.fail_other_capturing", new Object[0]), false);
            }
            return false;
        }
        if (this.capturingFaction != null) {
            if (!this.field_145850_b.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("text.vampirism.village.totem_destroy.fail_capture_in_progress", new Object[0]), false);
            }
            return false;
        }
        if (this.controllingFaction.equals(faction)) {
            return true;
        }
        if (!this.field_145850_b.field_72995_K) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("text.vampirism.village.totem_destroy.fail_other_faction", new Object[0]), false);
        }
        return false;
    }

    public void setDefaultFaction(IPlayableFaction newFaction, boolean checkForHunterTrainer) {
        if (this.controllingFaction != null || this.capturingFaction != null) {
            return;
        }
        this.forced_faction = newFaction;
        this.forced_faction_check_trainer = checkForHunterTrainer;
        this.forced_faction_timer = 20;
    }

    @SideOnly(value=Side.CLIENT)
    public float[] getBaseColors() {
        return this.baseColors;
    }

    public int getCaptureProgress() {
        return this.capturingFaction == null ? 0 : (this.capture_phase == CAPTURE_PHASE.PHASE_2 ? 80 : (int)((float)this.capture_timer / 60.0f * 80.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public float[] getCapturingColors() {
        return this.capturingColors;
    }

    @Nullable
    public IPlayableFaction getCapturingFaction() {
        return this.capturingFaction;
    }

    private void setCapturingFaction(@Nullable IPlayableFaction faction) {
        this.capturingFaction = faction;
        this.capturingColors = faction != null ? UtilLib.getColorComponents(faction.getColor()) : EnumDyeColor.WHITE.func_193349_f();
    }

    @Nullable
    public IPlayableFaction getControllingFaction() {
        return this.controllingFaction;
    }

    private void setControllingFaction(@Nullable IPlayableFaction faction) {
        this.controllingFaction = faction;
        this.baseColors = faction != null ? UtilLib.getColorComponents(faction.getColor()) : EnumDyeColor.WHITE.func_193349_f();
    }

    @Nullable
    public ITextComponent func_145748_c_() {
        if (this.capturingFaction != null) {
            return new TextComponentTranslation("text.vampirism.village.faction_capturing", new Object[]{new TextComponentTranslation(this.capturingFaction.getUnlocalizedNamePlural(), new Object[0])});
        }
        if (this.controllingFaction != null) {
            return new TextComponentTranslation("text.vampirism.village.faction_controlling", new Object[]{new TextComponentTranslation(this.controllingFaction.getUnlocalizedNamePlural(), new Object[0])});
        }
        return new TextComponentTranslation("text.vampirism.village.neutral", new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        nbt.func_74783_a("village_bb", UtilLib.bbToInt(this.getAffectedArea()));
        return nbt;
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        this.func_145839_a(tag);
        if (tag.func_74764_b("village_bb")) {
            StructureBoundingBox bb = new StructureBoundingBox(tag.func_74759_k("village_bb"));
            ModEventFactory.fireUpdateBoundingBoxEvent(this.getVillage(), bb);
            if (this.controllingFaction == VReference.VAMPIRE_FACTION) {
                this.registerVampireArea(bb);
            } else {
                this.unregisterVampireArea();
            }
        }
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    public void initiateCapture(@Nonnull IPlayableFaction faction, EntityPlayer player) {
        if (this.capturingFaction != null) {
            return;
        }
        if (faction.equals(this.controllingFaction)) {
            return;
        }
        this.updateTotem();
        if (!this.insideVillage) {
            if (this.controllingFaction != null) {
                this.capturingFaction = null;
                this.controllingFaction = null;
                this.capture_timer = 0;
                this.func_70296_d();
            }
            player.func_145747_a((ITextComponent)new TextComponentTranslation("text.vampirism.village.no_near_village", new Object[0]));
            return;
        }
        this.capture_abort_timer = 0;
        this.capturingFaction = faction;
        this.captureInfo.func_186739_a((ITextComponent)new TextComponentTranslation("text.vampirism.village.bossinfo.capture", new Object[0]));
        this.captureInfo.func_186745_a(BossInfo.Color.YELLOW);
        this.captureInfo.func_186735_a(0.0f);
        this.defenderMax = 0;
        if (this.controllingFaction == null) {
            this.capture_phase = CAPTURE_PHASE.PHASE_1_NEUTRAL;
            this.notifyNearbyPlayers((ITextComponent)new TextComponentTranslation("text.vampirism.village.neutral_village_under_attack", new Object[]{new TextComponentTranslation(faction.getUnlocalizedNamePlural(), new Object[0])}));
        } else {
            this.capture_phase = CAPTURE_PHASE.PHASE_1_OPPOSITE;
            this.notifyNearbyPlayers((ITextComponent)new TextComponentTranslation("text.vampirism.village.faction_village_under_attack", new Object[]{new TextComponentTranslation(this.controllingFaction.getUnlocalizedName(), new Object[0]), new TextComponentTranslation(faction.getUnlocalizedNamePlural(), new Object[0])}));
        }
        this.capture_timer = 0;
        this.force_village_update = true;
        this.func_70296_d();
        if (this.getVillage() != null && ModEventFactory.fireInitiateCaptureEvent(this.getVillage(), this.field_145850_b, this.controllingFaction, this.capturingFaction) && !this.field_145850_b.field_72995_K && this.capturingFaction == VReference.VAMPIRE_FACTION) {
            List villager = this.field_145850_b.func_72872_a(EntityVillager.class, this.getAffectedArea());
            for (EntityVillager v : villager) {
                if (v instanceof EntityFactionVillager || v.func_70681_au().nextInt(3) != 0) continue;
                TileTotem.makeAggressive(v, this.getVillage());
            }
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.unregisterVampireArea();
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        StructureBoundingBox bb = new StructureBoundingBox(UtilLib.bbToInt(this.getAffectedArea()));
        ModEventFactory.fireUpdateBoundingBoxEvent(this.getVillage(), bb);
        if (this.controllingFaction == VReference.VAMPIRE_FACTION) {
            this.registerVampireArea(bb);
        } else {
            this.unregisterVampireArea();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public void onTileRemoved() {
        VampirismVillage v = this.getVillage();
        if (v != null) {
            v.removeTotemAndReset(this.field_174879_c);
        }
        if (this.capturingFaction != null) {
            this.abortCapture(false);
        } else {
            this.updateBossinfoPlayers(null);
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        IFaction f;
        super.func_145839_a(compound);
        String controlling = compound.func_74779_i("controlling");
        String capturing = compound.func_74779_i("capturing");
        IPlayableFaction controllingFaction = null;
        IPlayableFaction capturingFaction = null;
        if (!"".equals(controlling)) {
            f = VampirismAPI.factionRegistry().getFactionByName(controlling);
            if (!(f instanceof IPlayableFaction)) {
                VampirismMod.log.w(TAG, "Stored faction %s does not exist or is not playable", controlling);
            } else {
                controllingFaction = (IPlayableFaction)f;
            }
        }
        if (!"".equals(capturing)) {
            f = VampirismAPI.factionRegistry().getFactionByName(capturing);
            if (!(f instanceof IPlayableFaction)) {
                VampirismMod.log.w(TAG, "Stored faction %s does not exist or is not playable", capturing);
            } else {
                capturingFaction = (IPlayableFaction)f;
            }
        }
        this.setControllingFaction(controllingFaction);
        this.setCapturingFaction(capturingFaction);
        if (capturingFaction != null) {
            this.capture_timer = compound.func_74762_e("timer");
            this.capture_abort_timer = compound.func_74762_e("abort_timer");
            this.capture_remainingEnemies_cache = compound.func_74762_e("rem_enem");
            this.capture_phase = CAPTURE_PHASE.valueOf(compound.func_74779_i("phase"));
        }
        this.force_village_update = true;
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.updateTotem();
            return true;
        }
        return super.func_145842_c(id, type);
    }

    @SideOnly(value=Side.CLIENT)
    public float shouldBeamRender() {
        if (!this.isComplete) {
            return 0.0f;
        }
        int i = (int)(this.field_145850_b.func_82737_E() - this.beamRenderCounter);
        this.beamRenderCounter = this.field_145850_b.func_82737_E();
        if (i > 1) {
            this.beamRenderScale -= (float)i / 40.0f;
            if (this.beamRenderScale < 0.0f) {
                this.beamRenderScale = 0.0f;
            }
        }
        this.beamRenderScale += 0.025f;
        if (this.beamRenderScale > 1.0f) {
            this.beamRenderScale = 1.0f;
        }
        return this.beamRenderScale;
    }

    public void func_73660_a() {
        int time = (int)this.field_145850_b.func_82737_E();
        if (this.field_145850_b.field_72995_K) {
            if (time % 10 == 4) {
                this.updateTotem();
            }
            if (this.capturingFaction != null && time % 40 == 9) {
                ++this.capture_timer;
            }
            if (this.controllingFaction != null && time % 10 == 7) {
                VampLib.proxy.getParticleHandler().spawnParticles(this.field_145850_b, ModParticles.GENERIC_PARTICLE, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 3, 30.0, this.field_145850_b.field_73012_v, 4, 20, this.controllingFaction.getColor());
            }
            return;
        }
        if (this.forced_faction != null) {
            if (this.forced_faction_timer > 0) {
                --this.forced_faction_timer;
            } else {
                List t;
                if (this.forced_faction != VReference.HUNTER_FACTION && this.forced_faction_check_trainer && (t = this.field_145850_b.func_72872_a(EntityHunterTrainer.class, this.getAffectedArea())).size() > 0) {
                    this.forced_faction = VReference.HUNTER_FACTION;
                }
                if (this.getVillage() == null) {
                    VampirismMod.log.w(TAG, "Freshly generated totem cannot find village", new Object[0]);
                } else {
                    this.capturingFaction = this.forced_faction;
                    this.completeCapture(false);
                }
                this.forced_faction = null;
            }
        }
        if (this.force_village_update || (long)(time % 80) == 0L) {
            this.updateTotem();
            this.force_village_update = false;
        }
        if (time % 1000 == 0) {
            this.updateAffectedArea();
        }
        if (this.capturingFaction != null) {
            if (time % 40 == 9) {
                List entities = this.field_145850_b.func_72872_a(EntityLivingBase.class, this.getAffectedArea());
                this.updateBossinfoPlayers(entities);
                int attacker = 0;
                int attackerPlayer = 0;
                int defender = 0;
                int defenderPlayer = 0;
                int neutral = 0;
                float attackStrength = 0.0f;
                float defenseStrength = 0.0f;
                for (Entity e : entities) {
                    IFaction f = VampirismAPI.factionRegistry().getFaction(e);
                    if (f == null || e instanceof EntityHunterTrainer) continue;
                    if (this.capturingFaction.equals(f)) {
                        ++attacker;
                        attackStrength += 1.0f;
                        if (!(e instanceof EntityPlayer)) continue;
                        ++attackerPlayer;
                        attackStrength += FactionPlayerHandler.get((EntityPlayer)e).getCurrentLevelRelative();
                        continue;
                    }
                    if (this.controllingFaction != null && this.controllingFaction.equals(f)) {
                        ++defender;
                        if (e instanceof EntityPlayer) {
                            ++defenderPlayer;
                            defenseStrength += FactionPlayerHandler.get((EntityPlayer)e).getCurrentLevelRelative();
                        }
                        if (e instanceof EntityConvertedVillager) {
                            defenseStrength += 0.5f;
                            continue;
                        }
                        if (e instanceof IAggressiveVillager) {
                            defenseStrength += 0.7f;
                            continue;
                        }
                        if (e instanceof EntityVillager) {
                            defenseStrength += 0.4f;
                            continue;
                        }
                        defenseStrength += 1.0f;
                        continue;
                    }
                    ++neutral;
                }
                if (attackerPlayer == 0) {
                    ++this.capture_abort_timer;
                } else {
                    this.capture_abort_timer = 0;
                    ++this.capture_timer;
                }
                if (this.capture_abort_timer > 7) {
                    this.abortCapture(true);
                } else {
                    switch (this.capture_phase) {
                        case PHASE_1_NEUTRAL: {
                            if (this.capture_timer < 60) break;
                            this.capture_timer = 1;
                            this.capture_phase = CAPTURE_PHASE.PHASE_2;
                            this.func_70296_d();
                            break;
                        }
                        case PHASE_1_OPPOSITE: {
                            if (this.capture_timer >= 60) {
                                this.capture_timer = 1;
                                this.capture_phase = CAPTURE_PHASE.PHASE_2;
                                this.func_70296_d();
                                this.notifyNearbyPlayers((ITextComponent)new TextComponentTranslation("text.vampirism.village.almost_captured", new Object[]{defender}));
                                break;
                            }
                            if (this.capture_timer % 2 != 0) break;
                            if (attackStrength * 1.1f > defenseStrength) {
                                this.spawnCaptureCreature(false);
                                break;
                            }
                            if (!(attackStrength < defenseStrength * 1.1f)) break;
                            this.spawnCaptureCreature(true);
                            break;
                        }
                        case PHASE_2: {
                            if (defender == 0) {
                                ++this.capture_timer;
                                if (this.capture_timer <= 4) break;
                                this.completeCapture(true);
                                break;
                            }
                            this.capture_timer = 1;
                            break;
                        }
                    }
                    this.handleBossBar(this.capture_phase, defender);
                }
            }
        } else {
            List l;
            VampirismVillage village;
            if (this.controllingFaction != null && time % 512 == 0 && (village = this.getVillage()) != null && (l = this.field_145850_b.func_72872_a(EntityVillager.class, this.getAffectedArea())).size() > 0) {
                Entity e;
                EntityVillager seed = (EntityVillager)l.get(((EntityVillager)l.get(0)).func_70681_au().nextInt(l.size()));
                int max = (int)Math.min((float)village.getVillage().func_75567_c() * 1.5f, 30.0f);
                if (l.size() < max) {
                    if (seed.func_70681_au().nextInt(15) == 0) {
                        if (this.controllingFaction.equals(VReference.HUNTER_FACTION)) {
                            this.spawnVillagerInVillage(new EntityHunterFactionVillager(this.field_145850_b), (Entity)seed, true, false);
                        } else if (this.controllingFaction.equals(VReference.VAMPIRE_FACTION)) {
                            this.spawnVillagerInVillage(new EntityVampireFactionVillager(this.field_145850_b), (Entity)seed, false, false);
                        } else {
                            VampirismVillageEvent.SpawnFactionVillager event = ModEventFactory.fireSpawnFactionVillagerEvent(village, seed, this.controllingFaction);
                            this.spawnVillagerInVillage(event.getVillager(), (Entity)seed, event.hasPoisonousBlood(), false);
                        }
                    } else {
                        boolean isConverted = this.controllingFaction != VReference.HUNTER_FACTION && seed.func_70681_au().nextBoolean();
                        VampirismVillageEvent.SpawnNewVillager event = ModEventFactory.fireSpawnNewVillagerEvent(village, seed, isConverted, this.controllingFaction);
                        if (event.getResult() != Event.Result.DENY) {
                            EntityVillager newVillager;
                            if (event.getResult() == Event.Result.ALLOW && event.getNewVillager() != null) {
                                newVillager = event.getNewVillager();
                            } else {
                                newVillager = new EntityVillager(this.field_145850_b);
                                newVillager.func_82149_j((Entity)seed);
                                newVillager.func_70873_a(seed.func_70874_b());
                            }
                            if (event.isWillBeConverted()) {
                                IConvertedCreature defenseStrength = ExtendedCreature.get((EntityCreature)newVillager).makeVampire();
                            } else {
                                this.spawnVillagerInVillage(newVillager, (Entity)seed, this.controllingFaction == VReference.HUNTER_FACTION, false);
                            }
                        }
                    }
                }
                int defenderNumMax = Math.min(6, village.getVillage().func_75567_c() / 5);
                List guards = new ArrayList();
                ResourceLocation entityId = null;
                if (this.controllingFaction.equals(VReference.HUNTER_FACTION)) {
                    guards = this.field_145850_b.func_72872_a(EntityHunterBase.class, this.getAffectedArea());
                    entityId = this.getEntityForFaction(this.controllingFaction);
                } else if (this.controllingFaction.equals(VReference.VAMPIRE_FACTION)) {
                    guards = this.field_145850_b.func_72872_a(EntityVampireBase.class, this.getAffectedArea());
                    entityId = this.getEntityForFaction(this.controllingFaction);
                }
                if (entityId != null && defenderNumMax > guards.size() && (e = EntityList.func_188429_b((ResourceLocation)entityId, (World)this.field_145850_b)) != null && !this.spawnEntityInVillage(e, null, false)) {
                    e.func_70106_y();
                }
            }
            if (this.controllingFaction != null && Balance.village.REPLACE_BLOCKS && time % 20 == 0) {
                this.getAffectedArea();
                int x = (int)(this.affectedArea.field_72340_a + (double)this.rng.nextInt((int)(this.affectedArea.field_72336_d - this.affectedArea.field_72340_a)));
                int z = (int)(this.affectedArea.field_72339_c + (double)this.rng.nextInt((int)(this.affectedArea.field_72334_f - this.affectedArea.field_72339_c)));
                BlockPos pos = new BlockPos(x, this.field_145850_b.func_189649_b(x, z) - 1, z);
                IBlockState b = this.field_145850_b.func_180495_p(pos);
                boolean flag = false;
                if (this.controllingFaction == VReference.VAMPIRE_FACTION) {
                    if (b.func_177230_c() == this.field_145850_b.func_180494_b((BlockPos)pos).field_76752_A.func_177230_c() && b.func_177230_c() != Blocks.field_150354_m) {
                        this.field_145850_b.func_175656_a(pos, ModBlocks.cursed_earth.func_176223_P());
                        if (this.field_145850_b.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150329_H) {
                            this.field_145850_b.func_175698_g(pos.func_177984_a());
                            flag = true;
                        }
                    }
                } else if (this.controllingFaction == VReference.HUNTER_FACTION && b.func_177230_c() == ModBlocks.cursed_earth) {
                    this.field_145850_b.func_175656_a(pos, this.field_145850_b.func_180494_b((BlockPos)pos).field_76752_A);
                    flag = true;
                }
                if (!flag) {
                    ModEventFactory.fireReplaceVillageBlockEvent(this.getVillage(), this.field_145850_b, b, pos, this.controllingFaction);
                }
            }
        }
    }

    public void updateTotem() {
        boolean complete = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c().equals((Object)ModBlocks.totem_base);
        if (complete != this.isComplete) {
            // empty if block
        }
        this.isComplete = complete;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.isComplete) {
            boolean insideVillageNew;
            VampirismVillage village = this.getVillage();
            boolean bl = insideVillageNew = village != null;
            if (insideVillageNew != this.insideVillage && !insideVillageNew) {
                this.capturingFaction = null;
                this.capture_timer = 0;
                this.func_70296_d();
            }
            this.insideVillage = insideVillageNew;
            if (this.insideVillage) {
                if (!this.updateVillage(village)) {
                    this.field_145850_b.func_175655_b(this.func_174877_v(), true);
                    return;
                }
                int x = this.field_174879_c.func_177958_n();
                int y = this.field_174879_c.func_177956_o() + 1;
                int z = this.field_174879_c.func_177952_p();
                BlockPos.MutableBlockPos pos1 = new BlockPos.MutableBlockPos();
                for (int i = y; i < 256; ++i) {
                    IBlockState blockState = this.field_145850_b.func_180495_p((BlockPos)pos1.func_181079_c(x, i, z));
                    if (blockState.func_177230_c().isAir(blockState, (IBlockAccess)this.field_145850_b, (BlockPos)pos1) || blockState.func_185904_a() == Material.field_151592_s || blockState.func_185887_b(this.field_145850_b, (BlockPos)pos1) == -1.0f) continue;
                    this.field_145850_b.func_175655_b((BlockPos)pos1, false);
                }
            }
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74778_a("controlling", this.controllingFaction == null ? "" : this.controllingFaction.name());
        compound.func_74778_a("capturing", this.capturingFaction == null ? "" : this.capturingFaction.name());
        if (this.capturingFaction != null) {
            compound.func_74768_a("timer", this.capture_timer);
            compound.func_74768_a("abort_timer", this.capture_abort_timer);
            compound.func_74778_a("phase", this.capture_phase.name());
            compound.func_74768_a("rem_enem", this.capture_remainingEnemies_cache);
        }
        return super.func_189515_b(compound);
    }

    private void abortCapture(boolean notifyPlayer) {
        this.setCapturingFaction(null);
        this.force_village_update = true;
        this.func_70296_d();
        this.informEntitiesAboutCaptureStop();
        if (notifyPlayer) {
            this.notifyNearbyPlayers((ITextComponent)new TextComponentTranslation("text.vampirism.village.village_capture_aborted", new Object[0]));
        }
        this.updateBossinfoPlayers(null);
        this.defenderMax = 0;
    }

    private void completeCapture(boolean notifyPlayer) {
        this.informEntitiesAboutCaptureStop();
        if (!this.field_145850_b.field_72995_K) {
            this.updateCreaturesOnCapture();
        }
        if (this.capturingFaction == null) {
            VampirismMod.log.w(TAG, "Completing null capture. That should not happen", new Object[0]);
            return;
        }
        this.setControllingFaction(this.capturingFaction);
        this.setCapturingFaction(null);
        this.force_village_update = true;
        this.func_70296_d();
        if (notifyPlayer) {
            this.notifyNearbyPlayers((ITextComponent)new TextComponentTranslation("text.vampirism.village.village_captured_by", new Object[]{new TextComponentTranslation(this.controllingFaction.getUnlocalizedNamePlural(), new Object[0])}));
        }
        this.updateBossinfoPlayers(null);
    }

    @Nonnull
    private AxisAlignedBB getAffectedArea() {
        if (this.affectedArea == null) {
            this.updateAffectedArea();
        }
        return this.affectedArea;
    }

    @Nonnull
    private AxisAlignedBB getAffectedAreaReduced() {
        if (this.affectedAreaReduced == null) {
            this.updateAffectedArea();
        }
        return this.affectedAreaReduced;
    }

    @Nullable
    private ResourceLocation getEntityForFaction(@Nonnull IFaction f) {
        if (f == VReference.HUNTER_FACTION) {
            return new ResourceLocation("vampirism:vampire_hunter");
        }
        if (f == VReference.VAMPIRE_FACTION) {
            return new ResourceLocation("vampirism:vampire");
        }
        return ModEventFactory.fireSpawnCaptureEntityEvent(this.getVillage(), f);
    }

    @Nullable
    private VampirismVillage getVillage() {
        return this.field_145850_b.field_72995_K ? null : VampirismVillageHelper.getNearestVillage(this.field_145850_b, this.field_174879_c, 10);
    }

    private void handleBossBar(CAPTURE_PHASE phase, int defenderLeft) {
        if (phase == CAPTURE_PHASE.PHASE_1_NEUTRAL || phase == CAPTURE_PHASE.PHASE_1_OPPOSITE) {
            this.captureInfo.func_186735_a((float)this.capture_timer / 60.0f);
        } else if (phase == CAPTURE_PHASE.PHASE_2) {
            if (this.defenderMax != 0) {
                if (defenderLeft > this.defenderMax) {
                    this.defenderMax = defenderLeft;
                }
                this.captureInfo.func_186735_a((float)defenderLeft / (float)this.defenderMax);
            } else {
                this.defenderMax = defenderLeft;
                this.captureInfo.func_186739_a((ITextComponent)new TextComponentTranslation("text.vampirism.village.defender_remaining", new Object[0]));
                this.captureInfo.func_186745_a(BossInfo.Color.WHITE);
            }
        }
    }

    private void informEntitiesAboutCaptureStop() {
        List list = this.field_145850_b.func_72872_a(EntityCreature.class, this.getAffectedArea());
        for (EntityCreature e : list) {
            if (!(e instanceof IVillageCaptureEntity)) continue;
            ((IVillageCaptureEntity)e).stopVillageAttackDefense();
        }
    }

    private void notifyNearbyPlayers(ITextComponent msg) {
        BlockPos pos = this.func_174877_v();
        for (EntityPlayer p : this.field_145850_b.func_175661_b(EntityPlayer.class, input -> input != null && input.func_174818_b(pos) < 40000.0)) {
            p.func_146105_b(msg, true);
        }
    }

    private void registerVampireArea(StructureBoundingBox box) {
        HashMap<BlockPos, StructureBoundingBox> map = (HashMap<BlockPos, StructureBoundingBox>)vampireVillages.func_76041_a(this.field_145850_b.field_73011_w.getDimension());
        if (map == null) {
            map = new HashMap<BlockPos, StructureBoundingBox>();
            vampireVillages.func_76038_a(this.field_145850_b.field_73011_w.getDimension(), map);
        }
        map.put(this.func_174877_v(), box);
    }

    private void spawnCaptureCreature(boolean attack) {
        ResourceLocation id;
        if (attack) {
            if (this.capturingFaction == null) {
                return;
            }
            id = this.getEntityForFaction(this.capturingFaction);
        } else {
            if (this.controllingFaction == null) {
                return;
            }
            id = this.getEntityForFaction(this.controllingFaction);
        }
        if (id == null) {
            VampirismMod.log.w(TAG, "No village capture entity registered for %s", attack ? this.capturingFaction : this.controllingFaction);
            return;
        }
        Entity e = EntityList.func_188429_b((ResourceLocation)id, (World)this.field_145850_b);
        if (e instanceof EntityVampireBase) {
            ((EntityVampireBase)e).setSpawnRestriction(EntityVampireBase.SpawnRestriction.SIMPLE);
        }
        if (e != null && !UtilLib.spawnEntityInWorld(this.field_145850_b, this.getAffectedAreaReduced(), e, 50, (List<EntityLivingBase>)this.field_145850_b.func_175661_b(EntityPlayer.class, EntitySelectors.field_180132_d))) {
            e.func_70106_y();
            e = null;
        }
        if (e instanceof IVillageCaptureEntity) {
            if (attack) {
                ((IVillageCaptureEntity)e).attackVillage(this.getAffectedArea());
            } else {
                ((IVillageCaptureEntity)e).defendVillage(this.getAffectedArea());
            }
        } else if (e != null) {
            VampirismMod.log.w(TAG, "Creature registered for village capture does not implement IVillageCaptureEntity", new Object[0]);
        } else {
            VampirismMod.log.t("Failed to spawn creature", new Object[0]);
        }
    }

    private boolean spawnEntityInVillage(@Nonnull Entity newEntity, @Nullable Entity entityToReplace, boolean removeEntityToReplace) {
        if (entityToReplace != null) {
            newEntity.func_82149_j(entityToReplace);
        } else {
            VampirismVillage village = this.getVillage();
            if (village == null) {
                return false;
            }
            Vec3d vec = village.getVillage().func_179862_a(village.getVillage().func_180608_a(), 2, 3, 2);
            if (vec == null) {
                return false;
            }
            if (!this.field_145850_b.func_175623_d(new BlockPos(vec))) {
                vec = vec.func_72441_c(0.0, 1.0, 0.0);
            }
            newEntity.func_70107_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        }
        if (entityToReplace != null && removeEntityToReplace) {
            this.field_145850_b.func_72900_e(entityToReplace);
        }
        this.field_145850_b.func_72838_d(newEntity);
        return true;
    }

    private boolean spawnVillagerInVillage(EntityVillager newVillager, @Nullable Entity entityToReplace, boolean poisonousBlood, boolean removeEntityToReplace) {
        if (newVillager == null) {
            return false;
        }
        if (!this.spawnEntityInVillage((Entity)newVillager, entityToReplace, removeEntityToReplace)) {
            return false;
        }
        if (entityToReplace instanceof EntityVillager) {
            newVillager.func_175449_a(((EntityVillager)entityToReplace).func_180486_cf(), (int)((EntityVillager)entityToReplace).func_110174_bM());
        } else {
            VampirismVillage village = this.getVillage();
            if (village == null) {
                return false;
            }
            newVillager.func_175449_a(village.getVillage().func_180608_a(), village.getVillage().func_75568_b());
        }
        newVillager.func_180482_a(this.field_145850_b.func_175649_E(new BlockPos((Entity)newVillager)), null);
        ExtendedCreature.get((EntityCreature)newVillager).setPoisonousBlood(poisonousBlood);
        return true;
    }

    private void unregisterVampireArea() {
        HashMap map = (HashMap)vampireVillages.func_76041_a(this.field_145850_b.field_73011_w.getDimension());
        if (map != null) {
            map.remove(this.func_174877_v());
        }
    }

    private void updateAffectedArea() {
        VampirismVillage v = this.getVillage();
        BlockPos b = v == null ? this.field_174879_c : v.getVillage().func_180608_a();
        int r = v == null ? 30 : v.getVillage().func_75568_b() + 15;
        AxisAlignedBB box = new AxisAlignedBB((double)(b.func_177958_n() - r), (double)(b.func_177956_o() - 10), (double)(b.func_177952_p() - r), (double)(b.func_177958_n() + r), (double)(b.func_177956_o() + 30), (double)(b.func_177952_p() + r));
        if (!box.func_72318_a(new Vec3d((Vec3i)this.field_174879_c))) {
            VampirismMod.log.d(TAG, "Totem outside of calculated village bb %s %s", box, this.field_174879_c);
        }
        double xLength = box.field_72336_d - box.field_72340_a;
        double zLength = box.field_72334_f - box.field_72339_c;
        double cX = 0.0;
        double cZ = 0.0;
        if (xLength > 100.0) {
            cX = 100.0 - xLength;
        } else if (xLength < 20.0) {
            cX = 20.0 - xLength;
        }
        if (zLength > 100.0) {
            cZ = 100.0 - zLength;
        } else if (zLength < 20.0) {
            cZ = 20.0 - zLength;
        }
        this.affectedArea = box.func_72314_b(cX / 2.0, 0.0, cZ / 2.0);
        this.affectedAreaReduced = this.affectedArea.func_72314_b(-10.0, 0.0, -10.0);
        if (!this.field_145850_b.field_72995_K) {
            this.func_70296_d();
        }
    }

    private void updateBossinfoPlayers(@Nullable List<Entity> includedPlayerEntities) {
        HashSet bossbar = new HashSet(this.captureInfo.func_186757_c());
        if (includedPlayerEntities != null) {
            for (Entity e : includedPlayerEntities) {
                if (!(e instanceof EntityPlayerMP) || bossbar.remove(e)) continue;
                this.captureInfo.func_186760_a((EntityPlayerMP)e);
            }
        }
        for (EntityPlayerMP p : bossbar) {
            this.captureInfo.func_186761_b(p);
        }
    }

    private void updateCreaturesOnCapture() {
        List villager = this.field_145850_b.func_72872_a(EntityVillager.class, this.getAffectedArea());
        if (this.getVillage() != null) {
            if (ModEventFactory.fireVillagerCaptureEvent(this.getVillage(), villager, this.controllingFaction, this.capturingFaction, this.getAffectedArea())) {
                return;
            }
            if (this.capturingFaction == VReference.HUNTER_FACTION) {
                List hunter = this.field_145850_b.func_72872_a(EntityHunterBase.class, this.getAffectedArea());
                if (this.controllingFaction == VReference.VAMPIRE_FACTION) {
                    int i = Math.max(2, hunter.size() / 2);
                    if (hunter.size() > 0) {
                        for (EntityVampirism e : hunter) {
                            if (i-- <= 0) continue;
                            this.spawnVillagerInVillage(new EntityVillager(this.field_145850_b), (Entity)e, true, true);
                        }
                    }
                    for (int o = i; o > 0; --o) {
                        this.spawnVillagerInVillage(new EntityVillager(this.field_145850_b), null, true, true);
                    }
                } else {
                    for (EntityVillager e : villager) {
                        ExtendedCreature.get((EntityCreature)e).setPoisonousBlood(true);
                    }
                }
                List huntertrainerdummy = this.field_145850_b.func_72872_a(EntityHunterTrainerDummy.class, this.getAffectedArea());
                for (EntityVampirism e : huntertrainerdummy) {
                    EntityHunterTrainer trainer = new EntityHunterTrainer(this.field_145850_b);
                    trainer.func_82149_j((Entity)e);
                    trainer.setHome(e.getHome());
                    this.field_145850_b.func_72900_e((Entity)e);
                    this.field_145850_b.func_72838_d((Entity)trainer);
                }
                this.spawnVillagerInVillage(new EntityHunterFactionVillager(this.field_145850_b), null, false, true);
            } else if (this.capturingFaction == VReference.VAMPIRE_FACTION) {
                for (EntityVillager e : villager) {
                    ExtendedCreature.get((EntityCreature)e).setPoisonousBlood(false);
                    if (e.func_70681_au().nextInt(2) == 1) continue;
                    PotionSanguinare.addRandom((EntityLivingBase)e, false);
                }
                List huntertrainer = this.field_145850_b.func_72872_a(EntityHunterTrainer.class, this.getAffectedArea());
                for (EntityHunterTrainer e : huntertrainer) {
                    EntityHunterTrainerDummy dummy = new EntityHunterTrainerDummy(this.field_145850_b);
                    dummy.func_82149_j((Entity)e);
                    dummy.setHome(e.getHome());
                    this.field_145850_b.func_72900_e((Entity)e);
                    this.field_145850_b.func_72838_d((Entity)dummy);
                }
                this.spawnVillagerInVillage(new EntityVampireFactionVillager(this.field_145850_b), null, false, true);
            }
        }
    }

    private boolean updateVillage(@Nonnull VampirismVillage village) {
        BlockPos totemLoc = village.getTotemLocation();
        if (totemLoc != null && !totemLoc.equals((Object)this.func_174877_v())) {
            return false;
        }
        village.registerTotem(this.field_174879_c);
        village.setControllingFaction(this.controllingFaction);
        village.setUnderAttack(this.capturingFaction != null);
        return true;
    }

    private static enum CAPTURE_PHASE {
        PHASE_1_NEUTRAL,
        PHASE_1_OPPOSITE,
        PHASE_2;

    }
}

