/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.base;

import io.github.strikerrocker.vt.VanillaTweaks;
import io.github.strikerrocker.vt.base.Feature;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

public abstract class Module {
    private List<Feature> features = new ArrayList<Feature>();
    private String name;
    private boolean requiresMCRestart;
    private String comments;
    private Configuration config;

    public Module(String name, String comments, boolean requiresMCRestart) {
        this.name = name;
        this.requiresMCRestart = requiresMCRestart;
        this.comments = comments;
        this.addFeatures();
    }

    public abstract void addFeatures();

    public void preInit() {
        this.features.stream().filter(Feature::usesEvents).forEach(arg_0 -> ((EventBus)MinecraftForge.EVENT_BUS).register(arg_0));
        this.features.stream().filter(Feature::usesEvents).forEach(feature -> VanillaTweaks.logger.debug("Registered Event Handler class" + feature.getClass().getName()));
        this.features.forEach(Feature::preInit);
    }

    public void setupConfig(FMLPreInitializationEvent event) {
        this.config = new Configuration(new File(event.getModConfigurationDirectory().toString() + "/VanillaTweaks/" + this.name + ".cfg"));
        this.config.load();
    }

    public void init() {
        this.features.forEach(Feature::init);
    }

    public void postInit() {
        this.features.forEach(Feature::postInit);
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void syncConfig() {
        String module = "general." + this.name;
        this.features.forEach(feature -> feature.syncConfig(this.config, module));
        this.config.setCategoryComment(module, this.comments);
        this.config.setCategoryRequiresMcRestart(module, this.requiresMCRestart);
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    protected void registerFeature(Feature feature) {
        this.features.add(feature);
    }

    public void registerPacket(SimpleNetworkWrapper network) {
        this.features.forEach(feature -> feature.registerPacket(network));
    }
}

