/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.enchantments;

import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentNimble
extends Enchantment {
    private static final UUID nimbleUUID = UUID.fromString("05b61a62-ae84-492e-8536-f365b7143296");

    EnchantmentNimble(String name) {
        super(Enchantment.Rarity.UNCOMMON, EnumEnchantmentType.ARMOR_FEET, new EntityEquipmentSlot[]{EntityEquipmentSlot.FEET});
        this.setRegistryName(name);
        this.func_77322_b(name);
    }

    @SubscribeEvent
    public void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        int enchantmentLevel = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)entity.func_184582_a(EntityEquipmentSlot.FEET));
        IAttributeInstance speedAttribute = entity.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d);
        AttributeModifier speedModifier = new AttributeModifier(nimbleUUID, "Nimble", (double)enchantmentLevel * (double)0.2f, 2);
        if (enchantmentLevel > 0) {
            if (speedAttribute.func_111127_a(nimbleUUID) == null) {
                speedAttribute.func_111121_a(speedModifier);
            }
        } else if (speedAttribute.func_111127_a(nimbleUUID) != null) {
            speedAttribute.func_111124_b(speedModifier);
        }
    }

    public int func_77321_a(int enchantmentLevel) {
        return 5 + (enchantmentLevel - 1) * 8;
    }

    public int func_77317_b(int enchantmentLevel) {
        return enchantmentLevel * 10 + 51;
    }

    public int func_77325_b() {
        return 3;
    }

    public boolean func_92089_a(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemArmor && ((ItemArmor)stack.func_77973_b()).field_77881_a.equals((Object)EntityEquipmentSlot.FEET);
    }
}

