/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.recipes.better;

import com.google.common.collect.Lists;
import io.github.strikerrocker.vt.base.Feature;
import io.github.strikerrocker.vt.recipes.better.DummyRecipe;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BetterRecipes
extends Feature {
    private boolean betterStairs;
    private boolean betterStoneTools;

    private static void addShapedRecipe(ItemStack output, Object ... params) {
        ResourceLocation baseLoc;
        ResourceLocation recipeLoc = baseLoc = new ResourceLocation("vt", output.func_77973_b().getRegistryName().func_110623_a());
        int index = 0;
        while (CraftingManager.field_193380_a.func_148741_d((Object)recipeLoc)) {
            recipeLoc = new ResourceLocation("vt", baseLoc.func_110623_a() + "_" + ++index);
        }
        CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])params);
        GameData.register_impl((IForgeRegistryEntry)new ShapedRecipes(output.func_77973_b().getRegistryName().toString(), primer.width, primer.height, primer.input, output).setRegistryName(recipeLoc));
    }

    private static void replaceStairsRecipe(ForgeRegistry<IRecipe> recipeRegistry, IRecipe r, ItemStack material) {
        BetterRecipes.removeRecipe(recipeRegistry, r);
        ItemStack stairsStack = r.func_77571_b();
        stairsStack.func_190920_e(8);
        BetterRecipes.addShapedRecipe(stairsStack, "S  ", "SS ", "SSS", Character.valueOf('S'), material);
    }

    private static void removeRecipe(ForgeRegistry<IRecipe> recipeRegistry, IRecipe r) {
        recipeRegistry.remove(r.getRegistryName());
        recipeRegistry.register((IForgeRegistryEntry)DummyRecipe.from(r));
    }

    @Override
    public void syncConfig(Configuration config, String category) {
        this.betterStairs = config.get(category, "betterStairs", true, "Want 8 stairs rather than 4 in stairs recipe?").getBoolean();
        this.betterStoneTools = config.get(category, "betterStoneTools", true, "Cobblestone used in stone tools doesn't make sense?").getBoolean();
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        ForgeRegistry recipeRegistry = (ForgeRegistry)ForgeRegistries.RECIPES;
        ArrayList recipes = Lists.newArrayList((Iterable)recipeRegistry.getValuesCollection());
        for (IRecipe recipe : recipes) {
            ItemStack output = recipe.func_77571_b();
            if (this.betterStairs && output.func_77973_b() instanceof ItemBlock) {
                this.replaceStairsRecipes(Block.func_149634_a((Item)output.func_77973_b()), (ForgeRegistry<IRecipe>)recipeRegistry, recipe);
            }
            if (!this.betterStoneTools) continue;
            String stickOreDict = "stickWood";
            String stone = "stone";
            if (output.func_77973_b() == Items.field_151049_t) {
                BetterRecipes.addShapedRecipe(new ItemStack(Items.field_151049_t), "SS", "ST", " T", Character.valueOf('S'), stone, Character.valueOf('T'), stickOreDict);
                BetterRecipes.removeRecipe((ForgeRegistry<IRecipe>)recipeRegistry, recipe);
                continue;
            }
            if (output.func_77973_b() == Items.field_151018_J) {
                BetterRecipes.addShapedRecipe(new ItemStack(Items.field_151018_J), "SS", " T", " T", Character.valueOf('S'), stone, Character.valueOf('T'), stickOreDict);
                BetterRecipes.removeRecipe((ForgeRegistry<IRecipe>)recipeRegistry, recipe);
                continue;
            }
            if (output.func_77973_b() == Items.field_151052_q) {
                BetterRecipes.addShapedRecipe(new ItemStack(Items.field_151052_q), "S", "S", "T", Character.valueOf('S'), stone, Character.valueOf('T'), stickOreDict);
                BetterRecipes.removeRecipe((ForgeRegistry<IRecipe>)recipeRegistry, recipe);
                continue;
            }
            if (output.func_77973_b() == Items.field_151051_r) {
                BetterRecipes.addShapedRecipe(new ItemStack(Items.field_151051_r), "S", "T", "T", Character.valueOf('S'), stone, Character.valueOf('T'), stickOreDict);
                BetterRecipes.removeRecipe((ForgeRegistry<IRecipe>)recipeRegistry, recipe);
                continue;
            }
            if (output.func_77973_b() != Items.field_151050_s) continue;
            BetterRecipes.addShapedRecipe(new ItemStack(Items.field_151050_s), "SSS", " T ", " T ", Character.valueOf('S'), stone, Character.valueOf('T'), stickOreDict);
            BetterRecipes.removeRecipe((ForgeRegistry<IRecipe>)recipeRegistry, recipe);
        }
    }

    private void replaceStairsRecipes(Block stair, ForgeRegistry<IRecipe> recipeRegistry, IRecipe recipe) {
        if (stair == Blocks.field_150476_ad) {
            BetterRecipes.replaceStairsRecipe(recipeRegistry, recipe, new ItemStack(Blocks.field_150344_f));
        } else if (stair == Blocks.field_150485_bF) {
            BetterRecipes.replaceStairsRecipe(recipeRegistry, recipe, new ItemStack(Blocks.field_150344_f, 1, 1));
        } else if (stair == Blocks.field_150487_bG) {
            BetterRecipes.replaceStairsRecipe(recipeRegistry, recipe, new ItemStack(Blocks.field_150344_f, 1, 2));
        } else if (stair == Blocks.field_150481_bH) {
            BetterRecipes.replaceStairsRecipe(recipeRegistry, recipe, new ItemStack(Blocks.field_150344_f, 1, 3));
        } else if (stair == Blocks.field_150400_ck) {
            BetterRecipes.replaceStairsRecipe(recipeRegistry, recipe, new ItemStack(Blocks.field_150344_f, 1, 4));
        } else if (stair == Blocks.field_150401_cl) {
            BetterRecipes.replaceStairsRecipe(recipeRegistry, recipe, new ItemStack(Blocks.field_150344_f, 1, 5));
        } else if (stair == Blocks.field_150446_ar) {
            BetterRecipes.replaceStairsRecipe(recipeRegistry, recipe, new ItemStack(Blocks.field_150347_e));
        } else if (stair == Blocks.field_150389_bf) {
            BetterRecipes.replaceStairsRecipe(recipeRegistry, recipe, new ItemStack(Blocks.field_150336_V));
        } else if (stair == Blocks.field_150390_bg) {
            BetterRecipes.replaceStairsRecipe(recipeRegistry, recipe, new ItemStack(Blocks.field_150417_aV, 1, 0));
        } else if (stair == Blocks.field_150387_bl) {
            BetterRecipes.replaceStairsRecipe(recipeRegistry, recipe, new ItemStack(Blocks.field_150385_bj));
        } else if (stair == Blocks.field_150372_bz) {
            BetterRecipes.replaceStairsRecipe(recipeRegistry, recipe, new ItemStack(Blocks.field_150322_A, 1, 0));
        } else if (stair == Blocks.field_180396_cN) {
            BetterRecipes.replaceStairsRecipe(recipeRegistry, recipe, new ItemStack(Blocks.field_180395_cM, 1, 0));
        } else if (stair == Blocks.field_150370_cb) {
            BetterRecipes.replaceStairsRecipe(recipeRegistry, recipe, new ItemStack(Blocks.field_150371_ca, 1, 0));
        } else if (stair == Blocks.field_185769_cV) {
            BetterRecipes.replaceStairsRecipe(recipeRegistry, recipe, new ItemStack(Blocks.field_185767_cT, 1));
        }
    }
}

