/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.tweaks;

import io.github.strikerrocker.vt.base.Feature;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ArmorStandSwap
extends Feature {
    private boolean enableArmorStandSwapping;

    private static void swapSlot(EntityPlayer player, EntityArmorStand armorStand, EntityEquipmentSlot slot) {
        ItemStack playerItem = player.func_184582_a(slot);
        ItemStack armorStandItem = armorStand.func_184582_a(slot);
        player.func_184201_a(slot, armorStandItem);
        armorStand.func_184201_a(slot, playerItem);
    }

    @Override
    public void syncConfig(Configuration config, String category) {
        this.enableArmorStandSwapping = config.get(category, "enableArmorStandSwapping", true, "Want an way to swap armor with armor stand?").getBoolean();
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void onEntityInteractSpecific(PlayerInteractEvent.EntityInteractSpecific event) {
        EntityPlayer player = event.getEntityPlayer();
        Entity target = event.getTarget();
        if (player.func_70093_af() && this.enableArmorStandSwapping) {
            if (target.field_70170_p.field_72995_K || player.func_175149_v() || player.func_184812_l_() || !(target instanceof EntityArmorStand)) {
                return;
            }
            event.setCanceled(true);
            EntityArmorStand armorStand = (EntityArmorStand)target;
            ArmorStandSwap.swapSlot(player, armorStand, EntityEquipmentSlot.HEAD);
            ArmorStandSwap.swapSlot(player, armorStand, EntityEquipmentSlot.CHEST);
            ArmorStandSwap.swapSlot(player, armorStand, EntityEquipmentSlot.LEGS);
            ArmorStandSwap.swapSlot(player, armorStand, EntityEquipmentSlot.FEET);
        }
    }
}

