/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.tweaks.sit;

import io.github.strikerrocker.vt.base.Feature;
import io.github.strikerrocker.vt.tweaks.sit.EntitySit;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Sit
extends Feature {
    private boolean enableSit;

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().entity(EntitySit.class).id(new ResourceLocation("vt", "entity_sit"), 1).name("entity_sit").tracker(32, 1, false).build());
    }

    @Override
    public void syncConfig(Configuration config, String category) {
        this.enableSit = config.get(category, "enableSit", true, "Want to be able to sit on slabs and stairs?").getBoolean();
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        Block block = world.func_180495_p(pos).func_177230_c();
        IBlockState blockAbove = world.func_180495_p(pos.func_177984_a());
        if ((block instanceof BlockSlab || block instanceof BlockStairs) && !EntitySit.OCCUPIED.containsKey(pos) && event.getEntityPlayer().func_184614_ca().func_190926_b() && !world.field_72995_K && this.enableSit) {
            if (!blockAbove.func_177230_c().isAir(blockAbove, (IBlockAccess)world, pos.func_177984_a())) {
                return;
            }
            if (block instanceof BlockSlab && (!state.func_177228_b().containsKey((Object)BlockSlab.field_176554_a) || state.func_177229_b((IProperty)BlockSlab.field_176554_a) != BlockSlab.EnumBlockHalf.BOTTOM)) {
                return;
            }
            if (block instanceof BlockStairs && (!state.func_177228_b().containsKey((Object)BlockStairs.field_176308_b) || state.func_177229_b((IProperty)BlockStairs.field_176308_b) != BlockStairs.EnumHalf.BOTTOM)) {
                return;
            }
            EntitySit sit = new EntitySit(world, pos);
            world.func_72838_d((Entity)sit);
            event.getEntityPlayer().func_184220_m((Entity)sit);
        }
    }

    @SubscribeEvent
    public void onEntityMount(EntityMountEvent event) {
        Entity entity;
        if (event.isDismounting() && (entity = event.getEntityBeingMounted()) instanceof EntitySit) {
            entity.func_70106_y();
            EntitySit.OCCUPIED.remove(entity.func_180425_c());
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (EntitySit.OCCUPIED.containsKey(event.getPos())) {
            EntitySit.OCCUPIED.get(event.getPos()).func_70106_y();
            EntitySit.OCCUPIED.remove(event.getPos());
        }
    }
}

