/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.entities.hostile;

import com.gildedgames.the_aether.AetherConfig;
import com.gildedgames.the_aether.entities.particles.AetherParticle;
import com.gildedgames.the_aether.entities.particles.ParticleEvilWhirly;
import com.gildedgames.the_aether.entities.particles.ParticlePassiveWhirly;
import com.gildedgames.the_aether.player.perks.AetherRankings;
import com.gildedgames.the_aether.world.AetherWorld;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityWhirlwind
extends EntityMob {
    public static final DataParameter<Boolean> IS_EVIL = EntityDataManager.func_187226_a(EntityWhirlwind.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Integer> COLOR_DATA = EntityDataManager.func_187226_a(EntityWhirlwind.class, (DataSerializer)DataSerializers.field_187192_b);
    public ArrayList<Object> particles = new ArrayList();
    public int lifeLeft;
    public int actionTimer;
    public float movementAngle;
    public float movementCurve;

    public EntityWhirlwind(World world) {
        super(world);
        this.func_70105_a(0.6f, 0.8f);
        this.movementAngle = this.field_70146_Z.nextFloat() * 360.0f;
        this.movementCurve = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f;
        this.lifeLeft = this.field_70146_Z.nextInt(512) + 512;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        if (this.field_70146_Z.nextInt(10) == 0) {
            this.lifeLeft /= 2;
            this.setEvil(true);
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    public float func_180484_a(BlockPos pos) {
        return AetherWorld.viableSpawningBlocks.contains(this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c()) ? 10.0f : this.field_70170_p.func_175724_o(pos) - 0.5f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.field_70146_Z.nextDouble() * 0.025 + 0.025);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_70606_j(10.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_EVIL, (Object)false);
        this.field_70180_af.func_187214_a(COLOR_DATA, (Object)ItemDye.field_150922_c[15]);
    }

    public void setColorData(Integer data) {
        this.field_70180_af.func_187227_b(COLOR_DATA, (Object)data);
    }

    public Integer getColorData() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR_DATA);
    }

    public void setEvil(boolean isEvil) {
        this.field_70180_af.func_187227_b(IS_EVIL, (Object)isEvil);
    }

    public boolean isEvil() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_EVIL);
    }

    public void func_70636_d() {
        EntityPlayer closestPlayer = this.findClosestPlayer();
        if (this.isEvil() && closestPlayer != null && closestPlayer.field_70122_E) {
            this.func_70624_b((EntityLivingBase)closestPlayer);
        }
        if (this.func_70638_az() == null) {
            this.field_70159_w = Math.cos(0.01745329f * this.movementAngle) * this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
            this.field_70179_y = -Math.sin(0.01745329f * this.movementAngle) * this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
            this.movementAngle += this.movementCurve;
        } else {
            super.func_70636_d();
        }
        if ((this.lifeLeft-- <= 0 || this.func_70072_I()) && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
        if (!this.field_70170_p.field_72995_K) {
            if (closestPlayer != null) {
                ++this.actionTimer;
            }
            if (this.actionTimer >= 128) {
                if (this.isEvil()) {
                    EntityCreeper entitycreeper = new EntityCreeper(this.field_70170_p);
                    entitycreeper.func_70012_b(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                    entitycreeper.field_70159_w = (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.125;
                    entitycreeper.field_70179_y = (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.125;
                    this.field_70170_p.func_72838_d((Entity)entitycreeper);
                    this.actionTimer = 0;
                    this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.HOSTILE, 0.5f, 1.0f);
                } else if (this.field_70146_Z.nextInt(4) == 0) {
                    this.func_145779_a(this.getRandomDrop(), 1);
                    this.actionTimer = 0;
                    this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.HOSTILE, 0.5f, 1.0f);
                }
            }
        } else {
            this.updateParticles();
        }
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(2.5, 2.5, 2.5));
        for (int l = 0; l < list.size(); ++l) {
            int k2;
            int j2;
            int i2;
            double d17;
            Entity entity = (Entity)list.get(l);
            double d9 = (float)entity.field_70165_t;
            double d11 = (double)((float)entity.field_70163_u) - entity.func_70033_W() * (double)0.6f;
            double d13 = (float)entity.field_70161_v;
            double d15 = this.func_70032_d(entity);
            if (d15 <= 1.5 + (d17 = d11 - this.field_70163_u)) {
                entity.field_70181_x = 0.15f;
                entity.field_70143_R = 0.0f;
                if (d17 > 1.5) {
                    entity.field_70181_x = (double)-0.45f + d17 * (double)0.35f;
                    d15 += d17 * 1.5;
                } else {
                    entity.field_70181_x = 0.125;
                }
                double d19 = Math.atan2(this.field_70165_t - d9, this.field_70161_v - d13) / 0.01745329424738884;
                entity.field_70159_w = -Math.cos(0.01745329424738884 * (d19 += 160.0)) * (d15 + 0.25) * (double)0.1f;
                entity.field_70179_y = Math.sin(0.01745329424738884 * d19) * (d15 + 0.25) * (double)0.1f;
                if (entity instanceof EntityWhirlwind) {
                    entity.func_70106_y();
                    if (!this.isEvil()) {
                        this.lifeLeft /= 2;
                        this.setEvil(true);
                        this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187646_bt, SoundCategory.HOSTILE, this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat() * 0.2f + 1.2f, 1.0f);
                    }
                }
            } else {
                double d20 = Math.atan2(this.field_70165_t - d9, this.field_70161_v - d13) / 0.01745329424738884;
                entity.field_70159_w += Math.sin(0.01745329424738884 * d20) * (double)0.01f;
                entity.field_70179_y += Math.cos(0.01745329424738884 * d20) * (double)0.01f;
            }
            if (!this.field_70170_p.func_175623_d(this.func_180425_c())) {
                this.lifeLeft -= 50;
            }
            if (!this.field_70170_p.func_82736_K().func_82766_b("mobGriefing") || this.field_70170_p.field_72995_K || !(this.field_70170_p.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(i2 = MathHelper.func_76128_c((double)this.field_70165_t) - 1 + this.field_70146_Z.nextInt(3), j2 = MathHelper.func_76128_c((double)this.field_70163_u) + this.field_70146_Z.nextInt(5), k2 = MathHelper.func_76128_c((double)this.field_70161_v) - 1 + this.field_70146_Z.nextInt(3))).func_177230_c() instanceof BlockLeaves)) continue;
            this.field_70170_p.func_175655_b(new BlockPos(i2, j2, k2), false);
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_77973_b() == Items.field_151100_aR && AetherRankings.isRankedPlayer(player.func_110124_au())) {
            this.setColorData(ItemDye.field_150922_c[heldItem.func_77952_i()]);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_70041_e_() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateParticles() {
        if (!this.isEvil()) {
            Integer color = this.getColorData();
            for (int k = 0; k < 2; ++k) {
                double d1 = (float)this.field_70165_t + this.field_70146_Z.nextFloat() * 0.25f;
                double d4 = (float)this.field_70163_u + this.field_70131_O + 0.125f;
                double d7 = (float)this.field_70161_v + this.field_70146_Z.nextFloat() * 0.25f;
                float f = this.field_70146_Z.nextFloat() * 360.0f;
                ParticlePassiveWhirly particle = new ParticlePassiveWhirly(this.field_70170_p, -Math.sin(0.01745329f * f) * 0.75, d4 - 0.25, Math.cos(0.01745329f * f) * 0.75, d1, 0.125, d7);
                FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)particle);
                this.particles.add((Object)particle);
                particle.func_70538_b((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
                particle.func_187109_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            }
        } else {
            for (int k = 0; k < 3; ++k) {
                double d2 = (float)this.field_70165_t + this.field_70146_Z.nextFloat() * 0.25f;
                double d5 = (float)this.field_70163_u + this.field_70131_O + 0.125f;
                double d8 = (float)this.field_70161_v + this.field_70146_Z.nextFloat() * 0.25f;
                float f1 = this.field_70146_Z.nextFloat() * 360.0f;
                ParticleEvilWhirly particle = new ParticleEvilWhirly(this.field_70170_p, -Math.sin(0.01745329f * f1) * 0.75, d5 - 0.25, Math.cos(0.01745329f * f1) * 0.75, d2, 0.125, d8, 3.5f);
                FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)particle);
                this.particles.add((Object)particle);
                particle.func_187109_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            }
        }
        if (this.particles.size() > 0) {
            for (int i1 = 0; i1 < this.particles.size(); ++i1) {
                AetherParticle particle = (AetherParticle)((Object)this.particles.get(i1));
                if (!particle.func_187113_k()) {
                    this.particles.remove((Object)particle);
                    continue;
                }
                double d10 = particle.getX();
                double d12 = particle.func_187116_l().field_72338_b;
                double d14 = particle.getZ();
                double d16 = this.getDistanceToParticle(particle);
                double d18 = d12 - this.field_70163_u;
                particle.setMotionY(0.115f);
                double d21 = Math.atan2(this.field_70165_t - d10, this.field_70161_v - d14) / 0.01745329424738884;
                particle.setMotionX(-Math.cos(0.01745329424738884 * (d21 += 160.0)) * (d16 * 2.5 - d18) * (double)0.1f);
                particle.setMotionZ(Math.sin(0.01745329424738884 * d21) * (d16 * 2.5 - d18) * (double)0.1f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getDistanceToParticle(AetherParticle particle) {
        float f = (float)(this.field_70165_t - particle.getX());
        float f1 = (float)(this.field_70163_u - particle.getY());
        float f2 = (float)(this.field_70161_v - particle.getZ());
        return MathHelper.func_76129_c((float)(f * f + f1 * f1 + f2 * f2));
    }

    public Item getRandomDrop() {
        int i = this.field_70146_Z.nextInt(100) + 1;
        if (i == 100) {
            return Items.field_151045_i;
        }
        if (i >= 96) {
            return Items.field_151042_j;
        }
        if (i >= 91) {
            return Items.field_151043_k;
        }
        if (i >= 82) {
            return Items.field_151044_h;
        }
        if (i >= 80) {
            return Item.func_150898_a((Block)Blocks.field_150423_aK);
        }
        if (i >= 75) {
            return Item.func_150898_a((Block)Blocks.field_150351_n);
        }
        if (i >= 64) {
            return Item.func_150898_a((Block)Blocks.field_150435_aG);
        }
        if (i >= 52) {
            return Items.field_151055_y;
        }
        if (i >= 38) {
            return Items.field_151145_ak;
        }
        if (i > 20) {
            return Item.func_150898_a((Block)Blocks.field_150364_r);
        }
        return Item.func_150898_a((Block)Blocks.field_150354_m);
    }

    public boolean func_70601_bi() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        BlockPos pos = new BlockPos(i, j, k);
        return this.field_70146_Z.nextInt(AetherConfig.spawnrates.whirlwind_spawnrate) == 0 && AetherWorld.viableSpawningBlocks.contains(this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c()) && this.field_70170_p.func_175699_k(pos) > 8 && this.field_70170_p.func_72855_b(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ());
    }

    public EntityPlayer findClosestPlayer() {
        return this.field_70170_p.func_72890_a((Entity)this, 16.0);
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74776_a("movementAngle", this.movementAngle);
        nbttagcompound.func_74776_a("movementCurve", this.movementCurve);
        nbttagcompound.func_74757_a("isEvil", this.isEvil());
        nbttagcompound.func_74768_a("colorData", this.getColorData().intValue());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.movementAngle = nbttagcompound.func_74760_g("movementAngle");
        this.movementCurve = nbttagcompound.func_74760_g("movementCurve");
        this.setEvil(nbttagcompound.func_74767_n("isEvil"));
        this.setColorData(nbttagcompound.func_74762_e("colorData"));
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        return false;
    }

    public void func_70108_f(Entity entity) {
    }

    public int func_70641_bl() {
        return 3;
    }

    public boolean func_70617_f_() {
        return this.field_70123_F;
    }
}

