/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.events;

import com.gildedgames.the_aether.AetherConfig;
import com.gildedgames.the_aether.api.AetherAPI;
import com.gildedgames.the_aether.player.PlayerAether;
import com.gildedgames.the_aether.world.TeleporterAether;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class AetherEntityEvents {
    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof EntityLiving) {
            this.entityUpdateEvents(event.getEntity(), (Event)event);
        }
    }

    private void entityUpdateEvents(Entity entity, Event event) {
        if (entity.func_184207_aI() && entity.field_71093_bK == AetherConfig.dimension.aether_dimension_id && !entity.field_70170_p.field_72995_K) {
            int transferDimension;
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            int previousDimension = entity.field_71093_bK;
            int n = transferDimension = previousDimension == AetherConfig.dimension.aether_dimension_id ? 0 : AetherConfig.dimension.aether_dimension_id;
            if (entity.field_70163_u <= 0.0) {
                EntityPlayer rider = null;
                for (Entity passenger : entity.func_184188_bt()) {
                    if (passenger instanceof EntityPlayer) {
                        rider = (EntityPlayer)passenger;
                    }
                    passenger.func_184210_p();
                }
                entity.field_71088_bW = 300;
                AetherEntityEvents.transferEntity(false, entity, (Entity)rider, server.func_71218_a(previousDimension), server.func_71218_a(transferDimension));
                if (rider != null) {
                    AetherEntityEvents.transferPlayer(entity, rider);
                }
            }
        }
    }

    public static void transferEntity(boolean shouldSpawnPortal, Entity entityIn, Entity rider, WorldServer previousWorldIn, WorldServer newWorldIn) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        BlockPos previousPos = entityIn.func_180425_c();
        entityIn.field_71093_bK = newWorldIn.field_73011_w.getDimension();
        previousWorldIn.func_72973_f(entityIn);
        entityIn.field_70128_L = false;
        server.func_184103_al().transferEntityToWorld(entityIn, previousWorldIn.field_73011_w.getDimension(), previousWorldIn, newWorldIn, (Teleporter)new TeleporterAether(false, newWorldIn));
        entityIn.func_70107_b((double)previousPos.func_177958_n(), 255.0, (double)previousPos.func_177952_p());
    }

    public static void transferPlayer(Entity riding, EntityPlayer player) {
        PlayerAether playerAether = (PlayerAether)AetherAPI.getInstance().get(player);
        playerAether.teleportPlayer(false);
        playerAether.getEntity().func_184220_m(riding);
    }
}

