/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.items.accessories;

import com.gildedgames.the_aether.Aether;
import com.gildedgames.the_aether.api.AetherAPI;
import com.gildedgames.the_aether.api.accessories.AccessoryType;
import com.gildedgames.the_aether.api.player.IPlayerAether;
import com.gildedgames.the_aether.items.ItemsAether;
import com.gildedgames.the_aether.registry.creative_tabs.AetherCreativeTabs;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAccessory
extends Item {
    public static final String ROOT = Aether.modAddress() + "textures/slots/slot_";
    protected final AccessoryType accessoryType;
    public ResourceLocation texture;
    public ResourceLocation texture_slim;
    public ResourceLocation texture_elytra;
    public ResourceLocation texture_inactive;
    public ResourceLocation texture_inactive_slim;
    private int colorHex = 0xDDDDDD;
    private boolean isDungeonLoot = false;
    private boolean hasElytra = false;
    private boolean hasInactiveTexture = false;
    private SoundEvent equipSound;
    public static final IBehaviorDispenseItem DISPENSER_BEHAVIOR = new BehaviorDefaultDispenseItem(){

        protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            ItemStack itemstack = ItemAccessory.dispenseAccessory(source, stack);
            return itemstack != null ? itemstack : super.func_82487_b(source, stack);
        }
    };

    public ItemAccessory(AccessoryType type) {
        this.accessoryType = type;
        this.texture = Aether.locate("textures/armor/accessory_base.png");
        this.texture_slim = Aether.locate("textures/armor/accessory_base_slim.png");
        this.func_77625_d(1);
        this.func_77637_a(AetherCreativeTabs.accessories);
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)DISPENSER_BEHAVIOR);
    }

    public static ItemStack dispenseAccessory(IBlockSource blockSource, ItemStack stack) {
        BlockPos blockpos = blockSource.func_180699_d().func_177972_a((EnumFacing)blockSource.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a));
        List list = blockSource.func_82618_k().func_175647_a(EntityLivingBase.class, new AxisAlignedBB(blockpos), Predicates.and((Predicate)EntitySelectors.field_180132_d, (Predicate)new EntitySelectors.ArmoredMob(stack)));
        if (list.isEmpty()) {
            return null;
        }
        EntityLivingBase entitylivingbase = (EntityLivingBase)list.get(0);
        if (entitylivingbase instanceof EntityPlayer) {
            ItemStack itemstack = stack.func_77946_l();
            itemstack.func_190920_e(1);
            IPlayerAether playerAether = AetherAPI.getInstance().get((EntityPlayer)entitylivingbase);
            if (!playerAether.getAccessoryInventory().setAccessorySlot(itemstack)) {
                BehaviorDefaultDispenseItem.func_82486_a((World)blockSource.func_82618_k(), (ItemStack)itemstack, (int)6, (EnumFacing)((EnumFacing)blockSource.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a)), (IPosition)BlockDispenser.func_149939_a((IBlockSource)blockSource));
            }
            stack.func_190918_g(1);
            return stack;
        }
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem != ItemStack.field_190927_a && AetherAPI.getInstance().get(player).getAccessoryInventory().setAccessorySlot(heldItem.func_77946_l())) {
            heldItem.func_190918_g(1);
            SoundEvent soundEvent = SoundEvents.field_187719_p;
            if (this.getEquipSound() != null) {
                soundEvent = this.getEquipSound();
            }
            player.func_184185_a(soundEvent, 1.0f, 1.0f);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)heldItem);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == ItemsAether.zanite_gemstone && toRepair.func_77973_b() == ItemsAether.zanite_ring || repair.func_77973_b() == ItemsAether.zanite_gemstone && toRepair.func_77973_b() == ItemsAether.zanite_pendant;
    }

    public AccessoryType getType() {
        return this.accessoryType;
    }

    public Item setColor(int color) {
        this.colorHex = color;
        return this;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.isDungeonLoot ? ItemsAether.aether_loot : super.func_77613_e(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack stack, int meta) {
        return this.colorHex;
    }

    public ItemAccessory setDungeonLoot() {
        this.isDungeonLoot = true;
        return this;
    }

    public ItemAccessory setTexture(String location) {
        this.texture = new ResourceLocation("aether_legacy", "textures/armor/accessory_" + location + ".png");
        this.texture_slim = Aether.locate("textures/armor/accessory_" + location + "_slim.png");
        return this;
    }

    public ItemAccessory setElytraTexture(String location) {
        this.texture_elytra = new ResourceLocation("aether_legacy", "textures/armor/accessory_" + location + ".png");
        this.hasElytra = true;
        return this;
    }

    public boolean hasElytra() {
        return this.hasElytra;
    }

    public ItemAccessory setInactiveTexture(String location) {
        this.texture_inactive = new ResourceLocation("aether_legacy", "textures/armor/accessory_" + location + ".png");
        this.texture_inactive_slim = new ResourceLocation("aether_legacy", "textures/armor/accessory_" + location + "_slim.png");
        this.hasInactiveTexture = true;
        return this;
    }

    public boolean hasInactiveTexture() {
        return this.hasInactiveTexture;
    }

    public ItemAccessory setEquipSound(SoundEvent sound) {
        this.equipSound = sound;
        return this;
    }

    public SoundEvent getEquipSound() {
        return this.equipSound;
    }
}

