/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.player.abilities;

import com.gildedgames.the_aether.api.player.util.IAetherAbility;
import com.gildedgames.the_aether.entities.projectile.EntityZephyrSnowball;
import com.gildedgames.the_aether.entities.projectile.darts.EntityDartBase;
import com.gildedgames.the_aether.items.ItemsAether;
import com.gildedgames.the_aether.player.PlayerAether;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;

public class AbilityRepulsion
implements IAetherAbility {
    private PlayerAether playerAether;
    private Random rand = new Random();

    public AbilityRepulsion(PlayerAether player) {
        this.playerAether = player;
    }

    @Override
    public boolean shouldExecute() {
        return this.playerAether.getAccessoryInventory().wearingAccessory(new ItemStack(ItemsAether.repulsion_shield)) && this.playerAether.getEntity().field_191988_bg == 0.0f && this.playerAether.getEntity().field_70702_br == 0.0f;
    }

    @Override
    public void onUpdate() {
        if (!this.playerAether.thePlayer.field_70170_p.field_72995_K) {
            List entities = this.playerAether.getEntity().field_70170_p.func_72839_b((Entity)this.playerAether.getEntity(), this.playerAether.getEntity().func_174813_aQ().func_72321_a(4.0, 4.0, 4.0));
            for (int size = 0; size < entities.size(); ++size) {
                double z;
                double y;
                double x;
                Entity projectile = (Entity)entities.get(size);
                if (!AbilityRepulsion.isProjectile(projectile) || this.getShooter(projectile) == this.playerAether.getEntity()) continue;
                if (this.getShooter(projectile) != null) {
                    Entity shooter = this.getShooter(projectile);
                    x = this.playerAether.getEntity().field_70165_t - shooter.field_70165_t;
                    y = this.playerAether.getEntity().func_174813_aQ().field_72338_b - shooter.func_174813_aQ().field_72338_b;
                    z = this.playerAether.getEntity().field_70161_v - shooter.field_70161_v;
                } else {
                    x = this.playerAether.getEntity().field_70165_t - projectile.field_70165_t;
                    y = this.playerAether.getEntity().field_70163_u - projectile.field_70163_u;
                    z = this.playerAether.getEntity().field_70161_v - projectile.field_70161_v;
                }
                double difference = -Math.sqrt(x * x + y * y + z * z);
                projectile.field_70159_w = (x /= difference) * 0.75;
                projectile.field_70181_x = (y /= difference) * 0.75 + 0.05;
                projectile.field_70179_y = (z /= difference) * 0.75;
                this.setShooter(projectile, (EntityLivingBase)this.playerAether.getEntity());
                this.playerAether.getEntity().field_70170_p.func_184133_a(this.playerAether.getEntity(), new BlockPos((Entity)this.playerAether.getEntity()), SoundEvents.field_187688_dI, SoundCategory.PLAYERS, 1.0f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.4f + 0.8f) * 1.1f);
                for (int pack = 0; pack < 12; ++pack) {
                    double packX = -projectile.field_70159_w * (double)0.15f + (double)((this.rand.nextFloat() - 0.5f) * 0.05f);
                    double packY = -projectile.field_70181_x * (double)0.15f + (double)((this.rand.nextFloat() - 0.5f) * 0.05f);
                    double packZ = -projectile.field_70179_y * (double)0.15f + (double)((this.rand.nextFloat() - 0.5f) * 0.05f);
                    this.playerAether.getEntity().field_70170_p.func_175688_a(EnumParticleTypes.FLAME, projectile.field_70165_t, projectile.field_70163_u, projectile.field_70161_v, packX *= 0.625, packY *= 0.625, packZ *= 0.625, new int[0]);
                }
                this.playerAether.accessories.damageWornStack(1, new ItemStack(ItemsAether.repulsion_shield));
            }
        }
    }

    public boolean onPlayerAttacked(DamageSource source) {
        return !AbilityRepulsion.isProjectile(source.func_76364_f());
    }

    private Entity getShooter(Entity ent) {
        return ent instanceof EntityArrow ? ((EntityArrow)ent).field_70250_c : (ent instanceof EntityThrowable ? ((EntityThrowable)ent).func_85052_h() : (ent instanceof EntityDartBase ? ((EntityDartBase)ent).field_70250_c : (ent instanceof EntityFireball ? ((EntityFireball)ent).field_70235_a : null)));
    }

    private void setShooter(Entity ent, EntityLivingBase shooter) {
        if (ent instanceof EntityArrow) {
            ((EntityArrow)ent).field_70250_c = shooter;
        } else if (ent instanceof EntityFireball) {
            ((EntityFireball)ent).field_70235_a = shooter;
        } else if (ent instanceof EntityFireball) {
            ((EntityFireball)ent).field_70235_a = shooter;
        } else if (ent instanceof EntityDartBase) {
            ((EntityDartBase)ent).field_70250_c = shooter;
        }
    }

    public static boolean isProjectile(Entity entity) {
        return entity instanceof EntityArrow || entity instanceof EntityFireball || entity instanceof EntityThrowable || entity instanceof EntityPotion || entity instanceof EntityDartBase || entity instanceof EntityZephyrSnowball;
    }
}

