/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft;

import java.util.Arrays;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="ancientspellcraft", name="AncientSpellcraft")
public class Settings {
    public ResourceLocation[] lootInjectionLocations;
    public ResourceLocation[] artefactInjectionLocations;
    public ResourceLocation[] voidCreeperBiomeBlacklist;
    public List<ResourceLocation> shardEarthShardBiomeWhitelist;
    public List<ResourceLocation> shardSorceryShardBiomeWhitelist;
    public List<ResourceLocation> shardNecromancyShardBiomeWhitelist;
    public List<ResourceLocation> shardHealingBiomeWhitelist;
    public List<ResourceLocation> shardLightningBiomeWhitelist;
    public List<ResourceLocation> shardFireBiomeWhitelist;
    public List<ResourceLocation> shardIceBiomeWhitelist;
    @Config.Name(value="General Settings")
    @Config.LangKey(value="settings.ancientspellcraft:general_settings")
    public static GeneralSettings generalSettings = new GeneralSettings();

    public Settings() {
        this.lootInjectionLocations = electroblob.wizardry.Settings.toResourceLocations((String[])Settings.generalSettings.DEFAULT_LOOT_INJECTION_LOCATIONS);
        this.artefactInjectionLocations = electroblob.wizardry.Settings.toResourceLocations((String[])generalSettings.ARTEFACT_INJECTION_LOCATIONS);
        this.voidCreeperBiomeBlacklist = electroblob.wizardry.Settings.toResourceLocations((String[])Settings.generalSettings.void_creeper_biome_blacklist);
        this.shardEarthShardBiomeWhitelist = Arrays.asList(electroblob.wizardry.Settings.toResourceLocations((String[])Settings.generalSettings.earth_shard_biome_whitelist));
        this.shardSorceryShardBiomeWhitelist = Arrays.asList(electroblob.wizardry.Settings.toResourceLocations((String[])Settings.generalSettings.sorcery_shard_biome_whitelist));
        this.shardNecromancyShardBiomeWhitelist = Arrays.asList(electroblob.wizardry.Settings.toResourceLocations((String[])Settings.generalSettings.necromancy_shard_biome_whitelist));
        this.shardHealingBiomeWhitelist = Arrays.asList(electroblob.wizardry.Settings.toResourceLocations((String[])Settings.generalSettings.healing_shard_biome_whitelist));
        this.shardLightningBiomeWhitelist = Arrays.asList(electroblob.wizardry.Settings.toResourceLocations((String[])Settings.generalSettings.lightning_shard_biome_whitelist));
        this.shardFireBiomeWhitelist = Arrays.asList(electroblob.wizardry.Settings.toResourceLocations((String[])Settings.generalSettings.fire_shard_biome_whitelist));
        this.shardIceBiomeWhitelist = Arrays.asList(electroblob.wizardry.Settings.toResourceLocations((String[])Settings.generalSettings.ice_shard_biome_whitelist));
    }

    public static class GeneralSettings {
        @Config.Name(value="JEI integration")
        @Config.Comment(value={"Enables or disables the JEI integration of the mod"})
        @Config.RequiresMcRestart
        public boolean jei_integration = true;
        @Config.Name(value="Generate Crystal Ore Shards")
        @Config.Comment(value={"Determines whether to generate elemental crystal shards in the Overworld or not"})
        @Config.RequiresMcRestart
        public boolean generate_ore_shards = true;
        @Config.Name(value="Generate Devoritium Ore")
        @Config.Comment(value={"Determines whether to generate devoritium ore blocks in the Overworld or not"})
        @Config.RequiresMcRestart
        public boolean generate_devoritium_ore = true;
        @Config.Name(value="Sphere Spell Identify Chance")
        @Config.Comment(value={"The chance of identifying unknown spells when researching them with the Sphere of Cognizance. This doesn't affects the other hint texts given by the Sphere. 0 = never identify a spell, 1.0 = always"})
        @Config.RequiresMcRestart
        public double sphere_spell_identification_chance = 0.05;
        @Config.Name(value="Loot Inject Locations")
        @Config.Comment(value={"List of loot tables to inject Ancient Spellcraft loot (as specified in loot_tables/chests/dungeon_additions.json) into. This currently includes stuff like Stone Tablets."})
        public String[] DEFAULT_LOOT_INJECTION_LOCATIONS = new String[]{"ebwizardry:chests/wizard_tower", "ebwizardry:chests/shrine", "ebwizardry:chests/obelisk", "minecraft:chests/desert_pyramid", "minecraft:chests/jungle_temple", "minecraft:chests/stronghold_corridor", "minecraft:chests/stronghold_crossing", "minecraft:chests/stronghold_library", "minecraft:chests/igloo_chest", "minecraft:chests/woodland_mansion", "minecraft:chests/end_city_treasure"};
        @Config.Name(value="Artefact Inject locations")
        @Config.Comment(value={"List of loot tables to inject Ancient Spellcraft artefacts into."})
        private String[] ARTEFACT_INJECTION_LOCATIONS = new String[]{"ebwizardry:subsets/uncommon_artefacts", "ebwizardry:subsets/rare_artefacts", "ebwizardry:subsets/epic_artefacts"};
        @Config.Name(value="Essence Extraction Screen Shake")
        @Config.Comment(value={"Determines whether to the Essence Extraction spell shakes the screen while extracting powerful blocks or not."})
        @Config.RequiresMcRestart
        public boolean shake_screen = true;
        @Config.Name(value="Baubles Integration")
        @Config.Comment(value={"Enable/Disable Baubles integration for the new artefact types (belt, helm, etc). This does NOT affect Electroblob's Wizardry's own Baubles support implementation (ring, amulet, charm)!"})
        @Config.RequiresMcRestart
        public boolean baubles_integration = true;
        @Config.Name(value="Void Creeper Spawn Rate")
        @Config.Comment(value={"Spawn rate for naturally-spawned void creepers; higher numbers mean more void creepers will spawn. Set to 0 do disable spawning entirely"})
        @Config.RequiresMcRestart
        public int void_creeper_spawn_rate = 2;
        @Config.Name(value="Orb Artefact Potency Percent Bonus")
        @Config.Comment(value={"Determines the potency bonus of the elemental orb artefacts in a percentage value"})
        @Config.RequiresMcRestart
        @Config.RangeInt(min=0, max=100)
        public int orb_artefact_potency_bonus = 30;
        @Config.Name(value="Void Creeper Biome Blacklist")
        @Config.Comment(value={"List of Biomes where Void Creepers will never spawn."})
        @Config.RequiresMcRestart
        public String[] void_creeper_biome_blacklist = new String[]{"mushroom_island", "mushroom_island_shore"};
        @Config.Name(value="Elemental Fire Crystal Shard Biome List")
        @Config.Comment(value={"List of Biomes where Fire Crystal Shards can spawn."})
        @Config.RequiresMcRestart
        public String[] fire_shard_biome_whitelist = new String[]{"desert", "desert_hills", "mutated_desert"};
        @Config.Name(value="Elemental Earth Crystal Shard Biome List")
        @Config.Comment(value={"List of Biomes where Earth Crystal Shards can spawn."})
        @Config.RequiresMcRestart
        public String[] earth_shard_biome_whitelist = new String[]{"forest", "birch_forest", "roofed_forest"};
        @Config.Name(value="Elemental Sorcery Crystal Shard Biome List")
        @Config.Comment(value={"List of Biomes where Sorcery Crystal Shards can spawn."})
        @Config.RequiresMcRestart
        public String[] sorcery_shard_biome_whitelist = new String[]{"plains", "mutated_plains"};
        @Config.Name(value="Elemental Necromancy Crystal Shard Biome List")
        @Config.Comment(value={"List of Biomes where Necromancy Crystal Shards can spawn."})
        @Config.RequiresMcRestart
        public String[] necromancy_shard_biome_whitelist = new String[]{"swampland", "mutated_swampland"};
        @Config.Name(value="Elemental Healing Crystal Shard Biome List")
        @Config.Comment(value={"List of Biomes where Healing Crystal Shards can spawn."})
        @Config.RequiresMcRestart
        public String[] healing_shard_biome_whitelist = new String[]{"jungle", "jungle_hills", "jungle_edge"};
        @Config.Name(value="Elemental Lightning Crystal Shard Biome List")
        @Config.Comment(value={"List of Biomes where Lightning Crystal Shards can spawn."})
        @Config.RequiresMcRestart
        public String[] lightning_shard_biome_whitelist = new String[]{"extreme_hills", "smaller_extreme_hills", "extreme_hills_with_trees", "mutated_extreme_hills", "mutated_extreme_hills_with_trees"};
        @Config.Name(value="Elemental Ice Crystal Shard Biome List")
        @Config.Comment(value={"List of Biomes where Ice Crystal Shards can spawn."})
        @Config.RequiresMcRestart
        public String[] ice_shard_biome_whitelist = new String[]{"taiga", "taiga_hills", "taiga_cold", "taiga_cold_hills", "mutated_taiga", "mutated_taiga_cold"};
        @Config.Name(value="Pocket Biome registry ID")
        @Config.Comment(value={"Allows you to change the pocket biome registry ID if you encounter biome ID conflicts"})
        @Config.RequiresMcRestart
        public int pocket_biome_registry_id = 168;
    }

    @Mod.EventBusSubscriber(modid="ancientspellcraft")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("ancientspellcraft")) {
                ConfigManager.sync((String)"ancientspellcraft", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

