/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.block;

import com.windanesz.ancientspellcraft.util.SpellTeleporter;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockHellFire
extends Block {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)15);
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool UPPER = PropertyBool.func_177716_a((String)"up");

    public BlockHellFire() {
        super(Material.field_151581_o);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(false)));
        this.func_149675_a(true);
        this.func_149715_a(1.5f);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (!worldIn.func_180495_p(pos.func_177977_b()).isSideSolid(worldIn, pos.func_177977_b(), EnumFacing.UP) && !Blocks.field_150480_ab.canCatchFire(worldIn, pos.func_177977_b(), EnumFacing.UP)) {
            return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canCatchFire(worldIn, pos.func_177978_c(), EnumFacing.SOUTH))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canCatchFire(worldIn, pos.func_177974_f(), EnumFacing.WEST))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canCatchFire(worldIn, pos.func_177968_d(), EnumFacing.NORTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canCatchFire(worldIn, pos.func_177976_e(), EnumFacing.EAST))).func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(this.canCatchFire(worldIn, pos.func_177984_a(), EnumFacing.DOWN)));
        }
        return this.func_176223_P();
    }

    public int func_149738_a(World worldIn) {
        return 20;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public boolean func_149703_v() {
        return true;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.func_175697_a(pos, 2)) {
            return;
        }
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        if (age < 15) {
            state = state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age + rand.nextInt(3)));
            worldIn.func_180501_a(pos, state, 4);
            worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn) + rand.nextInt(10));
        }
        if (age >= 12) {
            worldIn.func_175698_g(pos);
            return;
        }
    }

    public boolean func_149698_L() {
        return false;
    }

    public void teleportPlayer(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (entityIn instanceof EntityPlayer && !entityIn.func_184218_aH() && !entityIn.func_184207_aI() && entityIn.func_184222_aU()) {
            int currDim = entityIn.field_70170_p.field_73011_w.getDimension();
            int x = pos.func_177958_n();
            int z = pos.func_177952_p();
            int targetDim = currDim == -1 ? 0 : -1;
            worldIn.func_175698_g(pos);
            if (!worldIn.field_72995_K) {
                SpellTeleporter.teleportEntity(targetDim, entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, true, (EntityPlayer)entityIn);
            }
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        this.teleportPlayer(worldIn, pos, state, entityIn);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        double d2;
        double d1;
        double d0;
        int i;
        if (rand.nextInt(24) == 0) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o() + 0.1, (double)((float)pos.func_177952_p() + 0.5f)).face(EnumFacing.UP).clr(145, 6, 55).collide(false).scale(4.3f).time(50).spawn(worldIn);
        }
        if (rand.nextInt(24) == 0) {
            worldIn.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
        }
        if (rand.nextInt(50) == 0) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187810_eg, SoundCategory.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        for (i = 0; i < 3; ++i) {
            d0 = (double)pos.func_177958_n() + rand.nextDouble();
            d1 = (double)pos.func_177956_o() + rand.nextDouble() * 0.5 + 0.5;
            d2 = (double)pos.func_177952_p() + rand.nextDouble();
            worldIn.func_175688_a(EnumParticleTypes.PORTAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
        for (i = 0; i < 4; ++i) {
            d1 = (float)pos.func_177956_o() + rand.nextFloat();
            d2 = (float)pos.func_177952_p() + rand.nextFloat();
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
            int j = rand.nextInt(2) * 2 - 1;
            d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
            double d3 = rand.nextFloat() * 2.0f * (float)j;
            worldIn.func_175688_a(EnumParticleTypes.PORTAL, d0, d1, d2, d3, d4, d5, new int[0]);
            d0 = (float)pos.func_177958_n() + rand.nextFloat();
            d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
            d2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)j;
            d5 = rand.nextFloat() * 2.0f * (float)j;
            worldIn.func_175688_a(EnumParticleTypes.PORTAL, d0, d1, d2, d3, d4, d5, new int[0]);
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn) + worldIn.field_73012_v.nextInt(10));
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_185896_q();
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return MapColor.field_151656_f;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE, NORTH, EAST, SOUTH, WEST, UPPER});
    }

    public boolean canCatchFire(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return world.func_180495_p(pos).func_177230_c().isFlammable(world, pos, face);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

