/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.entity.ai;

import electroblob.wizardry.entity.living.ISpellCaster;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.packet.PacketNPCCastSpell;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityAIAttackSpellImproved<T extends EntityLiving>
extends EntityAIBase {
    private final T entity;
    private final double moveSpeedAmp;
    private int attackCooldown;
    private final float maxAttackDistance;
    private int attackTime = -1;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;
    private final T attacker;
    private EntityLivingBase target;
    private int cooldown = -1;
    private final int baseCooldown;
    private int continuousSpellTimer;
    private final int continuousSpellDuration;
    private final double speed;

    public EntityAIAttackSpellImproved(T attacker, double speed, float maxDistance, int baseCooldown, int continuousSpellDuration) {
        this.attacker = attacker;
        this.baseCooldown = baseCooldown;
        this.continuousSpellDuration = continuousSpellDuration;
        this.speed = speed;
        this.func_75248_a(3);
        this.entity = attacker;
        this.moveSpeedAmp = speed;
        this.attackCooldown = continuousSpellDuration;
        this.maxAttackDistance = maxDistance * maxDistance;
    }

    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        if (entitylivingbase == null) {
            return false;
        }
        this.target = entitylivingbase;
        return true;
    }

    public boolean func_75253_b() {
        return this.func_75250_a() || !this.attacker.func_70661_as().func_75500_f();
    }

    public void func_75251_c() {
        this.target = null;
        this.seeTime = 0;
        this.cooldown = -1;
        this.setContinuousSpellAndNotify(Spells.none, new SpellModifiers());
        this.continuousSpellTimer = 0;
    }

    private void setContinuousSpellAndNotify(Spell spell, SpellModifiers modifiers) {
        ((ISpellCaster)this.attacker).setContinuousSpell(spell);
        WizardryPacketHandler.net.sendToAllAround((IMessage)new PacketNPCCastSpell.Message(this.attacker.func_145782_y(), this.target == null ? -1 : this.target.func_145782_y(), EnumHand.MAIN_HAND, spell, modifiers), new NetworkRegistry.TargetPoint(((EntityLiving)this.attacker).field_71093_bK, ((EntityLiving)this.attacker).field_70165_t, ((EntityLiving)this.attacker).field_70163_u, ((EntityLiving)this.attacker).field_70161_v, 128.0));
    }

    public void func_75246_d() {
        EntityLivingBase entitylivingbase;
        double distanceSq = this.attacker.func_70092_e(this.target.field_70165_t, this.target.field_70163_u, this.target.field_70161_v);
        boolean targetIsVisible = this.attacker.func_70635_at().func_75522_a((Entity)this.target);
        this.seeTime = targetIsVisible ? ++this.seeTime : 0;
        if (distanceSq <= (double)this.maxAttackDistance && this.seeTime >= 20) {
            this.attacker.func_70661_as().func_75499_g();
        } else {
            this.attacker.func_70661_as().func_75497_a((Entity)this.target, this.speed);
        }
        this.attacker.func_70671_ap().func_75651_a((Entity)this.target, 30.0f, 30.0f);
        if (this.continuousSpellTimer > 0) {
            --this.continuousSpellTimer;
            if (distanceSq > (double)this.maxAttackDistance || !targetIsVisible || MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Tick(SpellCastEvent.Source.NPC, ((ISpellCaster)this.attacker).getContinuousSpell(), this.attacker, ((ISpellCaster)this.attacker).getModifiers(), this.continuousSpellDuration - this.continuousSpellTimer)) || !((ISpellCaster)this.attacker).getContinuousSpell().cast(((EntityLiving)this.attacker).field_70170_p, this.attacker, EnumHand.MAIN_HAND, this.continuousSpellDuration - this.continuousSpellTimer, this.target, ((ISpellCaster)this.attacker).getModifiers()) || this.continuousSpellTimer == 0) {
                this.continuousSpellTimer = 0;
                this.cooldown = ((ISpellCaster)this.attacker).getContinuousSpell().getCooldown() + this.baseCooldown;
                this.setContinuousSpellAndNotify(Spells.none, new SpellModifiers());
                return;
            }
            if (this.continuousSpellDuration - this.continuousSpellTimer == 1) {
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.NPC, ((ISpellCaster)this.attacker).getContinuousSpell(), this.attacker, ((ISpellCaster)this.attacker).getModifiers()));
            }
        } else if (--this.cooldown == 0) {
            if (distanceSq > (double)this.maxAttackDistance || !targetIsVisible) {
                return;
            }
            double dx = this.target.field_70165_t - ((EntityLiving)this.attacker).field_70165_t;
            double dz = this.target.field_70161_v - ((EntityLiving)this.attacker).field_70161_v;
            ArrayList spells = new ArrayList(((ISpellCaster)this.attacker).getSpells());
            if (spells.size() > 0 && !((EntityLiving)this.attacker).field_70170_p.field_72995_K) {
                while (!spells.isEmpty()) {
                    Spell spell = (Spell)spells.get(((EntityLiving)this.attacker).field_70170_p.field_73012_v.nextInt(spells.size()));
                    SpellModifiers modifiers = ((ISpellCaster)this.attacker).getModifiers();
                    if (spell != null && this.attemptCastSpell(spell, modifiers)) {
                        ((EntityLiving)this.attacker).field_70177_z = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
                        return;
                    }
                    spells.remove(spell);
                }
            }
        } else if (this.cooldown < 0) {
            this.cooldown = this.baseCooldown;
        }
        if ((entitylivingbase = this.entity.func_70638_az()) != null) {
            boolean flag1;
            double d0 = this.entity.func_70092_e(entitylivingbase.field_70165_t, entitylivingbase.func_174813_aQ().field_72338_b, entitylivingbase.field_70161_v);
            boolean flag = this.entity.func_70635_at().func_75522_a((Entity)entitylivingbase);
            boolean bl = flag1 = this.seeTime > 0;
            if (flag != flag1) {
                this.seeTime = 0;
            }
            this.seeTime = flag ? ++this.seeTime : --this.seeTime;
            if (d0 <= (double)this.maxAttackDistance && this.seeTime >= 20) {
                this.entity.func_70661_as().func_75499_g();
                ++this.strafingTime;
            } else {
                this.entity.func_70661_as().func_75497_a((Entity)entitylivingbase, this.moveSpeedAmp);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if ((double)this.entity.func_70681_au().nextFloat() < 0.3) {
                    boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.entity.func_70681_au().nextFloat() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (d0 > (double)(this.maxAttackDistance * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (d0 < (double)(this.maxAttackDistance * 0.25f)) {
                    this.strafingBackwards = true;
                }
                this.entity.func_70605_aq().func_188488_a(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                this.entity.func_70625_a((Entity)entitylivingbase, 30.0f, 30.0f);
            } else {
                this.entity.func_70671_ap().func_75651_a((Entity)entitylivingbase, 30.0f, 30.0f);
            }
        }
    }

    private boolean attemptCastSpell(Spell spell, SpellModifiers modifiers) {
        if (MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Pre(SpellCastEvent.Source.NPC, spell, this.attacker, modifiers))) {
            return false;
        }
        if (spell.cast(((EntityLiving)this.attacker).field_70170_p, this.attacker, EnumHand.MAIN_HAND, 0, this.target, modifiers)) {
            if (spell.isContinuous) {
                this.continuousSpellTimer = this.continuousSpellDuration - 1;
                this.setContinuousSpellAndNotify(spell, modifiers);
            } else {
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.NPC, spell, this.attacker, modifiers));
                this.cooldown = this.baseCooldown + spell.getCooldown();
                if (spell.requiresPacket()) {
                    PacketNPCCastSpell.Message msg = new PacketNPCCastSpell.Message(this.attacker.func_145782_y(), this.target.func_145782_y(), EnumHand.MAIN_HAND, spell, modifiers);
                    WizardryPacketHandler.net.sendToDimension((IMessage)msg, ((EntityLiving)this.attacker).field_70170_p.field_73011_w.getDimension());
                }
            }
            return true;
        }
        return false;
    }
}

