/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.entity.living;

import com.google.common.base.Optional;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntitySpiritBear
extends EntityPolarBear
implements IEntityOwnable {
    private int dispelTimer = 0;
    private UUID ownerUUID;
    protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityTameable.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final int DISPEL_TIME = 10;

    public EntitySpiritBear(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.3f, 1.4f);
        this.field_70728_aV = 0;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new SpiritBearAIFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new SpiritBearAIOwnerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new SpiritBearIOwnerHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        if (this.field_70170_p.field_72995_K) {
            this.spawnAppearParticles();
        }
        return livingdata;
    }

    @Nullable
    public UUID func_184753_b() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orNull();
    }

    @Nullable
    public EntityLivingBase getOwner() {
        try {
            UUID uuid = this.func_184753_b();
            return uuid == null ? null : this.field_70170_p.func_152378_a(uuid);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public void setOwnerId(@Nullable UUID ownerId) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)ownerId));
    }

    public float getOpacity() {
        return 1.0f - (float)this.dispelTimer / 10.0f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.dispelTimer > 0 && this.dispelTimer++ > 10) {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K) {
            double x = this.field_70165_t - (double)(this.field_70130_N / 2.0f) + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N);
            double y = this.field_70163_u + (double)(this.field_70131_O * this.field_70146_Z.nextFloat()) + (double)0.2f;
            double z = this.field_70161_v - (double)(this.field_70130_N / 2.0f) + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N);
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DUST).pos(x, y, z).clr(0.8f, 0.8f, 1.0f).spawn(this.field_70170_p);
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.func_184753_b() == player.func_110124_au() && stack.func_77973_b() instanceof ISpellCastingItem && this.getOwner() == player && player.func_70093_af() && this.field_70173_aa > 20) {
            ++this.dispelTimer;
            this.func_184185_a(WizardrySounds.ENTITY_SPIRIT_WOLF_VANISH, 0.7f, this.field_70146_Z.nextFloat() * 0.4f + 1.0f);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public EntityWolf createChild(EntityAgeable ageable) {
        return null;
    }

    protected int func_70693_a(EntityPlayer player) {
        return 0;
    }

    protected boolean func_146066_aG() {
        return false;
    }

    protected Item func_146068_u() {
        return null;
    }

    public ITextComponent func_145748_c_() {
        if (this.getOwner() != null) {
            return new TextComponentTranslation("entity.ebwizardry:summonedcreature.nameplate", new Object[]{this.getOwner().func_70005_c_(), new TextComponentTranslation("entity." + this.func_70022_Q() + ".name", new Object[0])});
        }
        return super.func_145748_c_();
    }

    public boolean func_145818_k_() {
        return Wizardry.settings.summonedCreatureNames && this.getOwner() != null;
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_190026_er;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_190029_eu;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_190028_et;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_190030_ev, 0.15f, 1.0f);
    }

    protected void func_189796_de() {
        super.func_189796_de();
    }

    protected ResourceLocation func_184647_J() {
        return null;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    private void spawnAppearParticles() {
        for (int i = 0; i < 15; ++i) {
            double x = this.field_70165_t - (double)(this.field_70130_N / 2.0f) + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N);
            double y = this.field_70163_u + (double)(this.field_70131_O * this.field_70146_Z.nextFloat()) + (double)0.2f;
            double z = this.field_70161_v - (double)(this.field_70130_N / 2.0f) + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N);
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).clr(0.8f, 0.8f, 1.0f).spawn(this.field_70170_p);
        }
    }

    public class SpiritBearIOwnerHurtTarget
    extends EntityAITarget {
        EntitySpiritBear bear;
        EntityLivingBase attacker;
        private int timestamp;

        public SpiritBearIOwnerHurtTarget(EntitySpiritBear theEntityTameableIn) {
            super((EntityCreature)theEntityTameableIn, false);
            this.bear = theEntityTameableIn;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.bear.getOwner();
            if (entitylivingbase == null) {
                return false;
            }
            this.attacker = entitylivingbase.func_110144_aD();
            int i = entitylivingbase.func_142013_aG();
            return i != this.timestamp && this.func_75296_a(this.attacker, false);
        }

        public void func_75249_e() {
            this.field_75299_d.func_70624_b(this.attacker);
            EntityLivingBase entitylivingbase = this.bear.getOwner();
            if (entitylivingbase != null) {
                this.timestamp = entitylivingbase.func_142013_aG();
            }
            super.func_75249_e();
        }
    }

    public class SpiritBearAIOwnerHurtByTarget
    extends EntityAITarget {
        EntitySpiritBear bear;
        EntityLivingBase attacker;
        private int timestamp;

        public SpiritBearAIOwnerHurtByTarget(EntitySpiritBear bear) {
            super((EntityCreature)bear, false);
            this.bear = bear;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.bear.getOwner();
            if (entitylivingbase == null) {
                return false;
            }
            this.attacker = entitylivingbase.func_70643_av();
            int i = entitylivingbase.func_142015_aE();
            return i != this.timestamp && this.func_75296_a(this.attacker, false);
        }

        public void func_75249_e() {
            this.field_75299_d.func_70624_b(this.attacker);
            EntityLivingBase entitylivingbase = this.bear.getOwner();
            if (entitylivingbase != null) {
                this.timestamp = entitylivingbase.func_142015_aE();
            }
            super.func_75249_e();
        }
    }

    class SpiritBearAIFollowOwner
    extends EntityAIBase {
        private final EntitySpiritBear bear;
        private EntityLivingBase owner;
        World world;
        private final double followSpeed;
        private final PathNavigate petPathfinder;
        private int timeToRecalcPath;
        float maxDist;
        float minDist;
        private float oldWaterCost;

        public SpiritBearAIFollowOwner(EntitySpiritBear bear, double followSpeedIn, float minDistIn, float maxDistIn) {
            this.bear = bear;
            this.world = bear.field_70170_p;
            this.followSpeed = followSpeedIn;
            this.petPathfinder = bear.func_70661_as();
            this.minDist = minDistIn;
            this.maxDist = maxDistIn;
            this.func_75248_a(3);
            if (!(bear.func_70661_as() instanceof PathNavigateGround) && !(bear.func_70661_as() instanceof PathNavigateFlying)) {
                throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
            }
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.bear.getOwner();
            if (entitylivingbase == null) {
                return false;
            }
            if (entitylivingbase instanceof EntityPlayer && ((EntityPlayer)entitylivingbase).func_175149_v()) {
                return false;
            }
            if (this.bear.func_70068_e((Entity)entitylivingbase) < (double)(this.minDist * this.minDist)) {
                return false;
            }
            this.owner = entitylivingbase;
            return true;
        }

        public boolean func_75253_b() {
            return !this.petPathfinder.func_75500_f() && this.bear.func_70068_e((Entity)this.owner) > (double)(this.maxDist * this.maxDist);
        }

        public void func_75249_e() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.bear.func_184643_a(PathNodeType.WATER);
            this.bear.func_184644_a(PathNodeType.WATER, 0.0f);
        }

        public void func_75251_c() {
            this.owner = null;
            this.petPathfinder.func_75499_g();
            this.bear.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
        }

        public void func_75246_d() {
            this.bear.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.bear.func_70646_bf());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 10;
                if (!this.petPathfinder.func_75497_a((Entity)this.owner, this.followSpeed) && !this.bear.func_110167_bD() && !this.bear.func_184218_aH() && this.bear.func_70068_e((Entity)this.owner) >= 144.0) {
                    int i = MathHelper.func_76128_c((double)this.owner.field_70165_t) - 2;
                    int j = MathHelper.func_76128_c((double)this.owner.field_70161_v) - 2;
                    int k = MathHelper.func_76128_c((double)this.owner.func_174813_aQ().field_72338_b);
                    for (int l = 0; l <= 4; ++l) {
                        for (int i1 = 0; i1 <= 4; ++i1) {
                            if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.isTeleportFriendlyBlock(i, j, k, l, i1)) continue;
                            this.bear.func_70012_b((float)(i + l) + 0.5f, k, (float)(j + i1) + 0.5f, this.bear.field_70177_z, this.bear.field_70125_A);
                            this.petPathfinder.func_75499_g();
                            return;
                        }
                    }
                }
            }
        }

        protected boolean isTeleportFriendlyBlock(int x, int z, int y, int xOffset, int zOffset) {
            BlockPos blockpos = new BlockPos(x + xOffset, y - 1, z + zOffset);
            IBlockState iblockstate = this.world.func_180495_p(blockpos);
            return iblockstate.func_193401_d((IBlockAccess)this.world, blockpos, EnumFacing.DOWN) == BlockFaceShape.SOLID && iblockstate.func_189884_a((Entity)this.bear) && this.world.func_175623_d(blockpos.func_177984_a()) && this.world.func_175623_d(blockpos.func_177981_b(2));
        }
    }
}

