/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.entity.projectile;

import com.windanesz.ancientspellcraft.item.ItemNewArtefact;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftSpells;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.entity.construct.EntityScaledConstruct;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class EntityManaVortex
extends EntityScaledConstruct {
    private double velX;
    private double velZ;

    public EntityManaVortex(World world) {
        super(world);
        this.func_70105_a(Spells.tornado.getProperty("effect_radius").floatValue() * 0.6f, 0.05f);
        this.field_70178_ae = true;
    }

    protected boolean shouldScaleHeight() {
        return false;
    }

    public void setHorizontalVelocity(double velX, double velZ) {
        this.velX = velX;
        this.velZ = velZ;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        double radius = this.field_70130_N / 2.0f * 2.0f;
        if (this.field_70173_aa % 120 != 1 || this.field_70170_p.field_72995_K) {
            // empty if block
        }
        this.func_70091_d(MoverType.SELF, this.velX, this.field_70181_x, this.velZ);
        if (!this.field_70170_p.field_72995_K) {
            List targets = EntityUtils.getLivingWithinRadius((double)radius, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (World)this.field_70170_p);
            float damage = 0.0f;
            if (!targets.isEmpty()) {
                damage = AncientSpellcraftSpells.mana_vortex.getProperty("damage").floatValue() * this.damageMultiplier;
                if (this.getCaster() instanceof EntityPlayer && ItemNewArtefact.isNewArtefactActive((EntityPlayer)this.getCaster(), AncientSpellcraftItems.belt_vortex)) {
                    damage *= 0.5f;
                }
            }
            for (EntityLivingBase target : targets) {
                if (target instanceof EntityPlayer && (this.getCaster() instanceof EntityPlayer && !Wizardry.settings.playersMoveEachOther || ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)target), (Item)WizardryItems.amulet_anchoring)) || !this.isValidTarget((Entity)target)) continue;
                if (this.getCaster() != null) {
                    target.func_70097_a(MagicDamage.causeIndirectMagicDamage((Entity)this, (Entity)this.getCaster(), (MagicDamage.DamageType)MagicDamage.DamageType.MAGIC), damage);
                } else {
                    target.func_70097_a(DamageSource.field_76376_m, damage);
                }
                EntityUtils.applyStandardKnockback((Entity)this, (EntityLivingBase)target, (float)0.1f);
            }
        } else {
            double speed;
            float r;
            int j;
            for (j = 0; j < 60; ++j) {
                r = this.field_70170_p.field_73012_v.nextFloat();
                speed = 0.02 / (double)r * (1.0 + this.field_70170_p.field_73012_v.nextDouble());
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.CLOUD).entity((Entity)this).pos(0.0, 1.0, 0.0).clr(DrawingUtils.mix((int)DrawingUtils.mix((int)0xFFFEF5, (int)12414942, (float)(r / 0.7f)), (int)DrawingUtils.mix((int)12277709, (int)4849756, (float)(r / 0.7f)), (float)((r - 0.6f) / 0.2f))).spin((double)r * (radius - 1.0) + 0.5, speed).scale(0.2f).spawn(this.field_70170_p);
            }
            for (j = 0; j < 5; ++j) {
                radius = this.field_70130_N / 10.0f;
                r = this.field_70170_p.field_73012_v.nextFloat();
                speed = 0.02 / (double)r * (1.0 + this.field_70170_p.field_73012_v.nextDouble());
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.CLOUD).entity((Entity)this).pos(0.0, 1.0, 0.0).clr(DrawingUtils.mix((int)0xF7F7F7, (int)0xFFFFD9, (float)(r / 0.7f))).spin((double)r * (radius - 1.0) + 0.5, speed).scale(0.4f).spawn(this.field_70170_p);
            }
        }
    }

    public void despawn() {
        if (this.field_70170_p.field_72995_K) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPHERE).pos(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v).scale(this.field_70130_N / 2.0f * 2.0f * 0.8f).clr(DrawingUtils.mix((int)12277709, (int)4849756, (float)0.7f)).spawn(this.field_70170_p);
            for (int i = 0; i < 40; ++i) {
                double particleX = this.field_70165_t - 1.0 + 2.0 * this.field_70170_p.field_73012_v.nextDouble();
                double particleZ = this.field_70161_v - 1.0 + 2.0 * this.field_70170_p.field_73012_v.nextDouble();
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.CLOUD).pos(particleX, this.field_70163_u + 1.0, particleZ).vel((particleX - this.field_70165_t) * 0.3, 0.0, (particleZ - this.field_70161_v) * 0.3).clr(DrawingUtils.mix((int)12277709, (int)4849756, (float)0.7f)).scale(0.15f).time(20).spawn(this.field_70170_p);
                particleX = this.field_70165_t - 1.0 + 2.0 * this.field_70170_p.field_73012_v.nextDouble();
                particleZ = this.field_70161_v - 1.0 + 2.0 * this.field_70170_p.field_73012_v.nextDouble();
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(particleX, this.field_70163_u + 1.0, particleZ).fade(0x5E5D5E).vel((particleX - this.field_70165_t) * (double)0.7f, 0.0, (particleZ - this.field_70161_v) * (double)0.7f).time(15).clr(DrawingUtils.mix((int)12277709, (int)4849756, (float)0.7f)).spawn(this.field_70170_p);
            }
        } else {
            float explosion = 1.0f;
            if (this.getCaster() instanceof EntityPlayer && ItemNewArtefact.isNewArtefactActive((EntityPlayer)this.getCaster(), AncientSpellcraftItems.belt_vortex)) {
                explosion = 3.2f;
            }
            this.field_70170_p.func_72876_a((Entity)(this.getCaster() != null ? this.getCaster() : this), this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, explosion, false);
        }
        super.despawn();
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.velX = nbttagcompound.func_74769_h("velX");
        this.velZ = nbttagcompound.func_74769_h("velZ");
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74780_a("velX", this.velX);
        nbttagcompound.func_74780_a("velZ", this.velZ);
    }

    public void writeSpawnData(ByteBuf data) {
        super.writeSpawnData(data);
        data.writeDouble(this.velX);
        data.writeDouble(this.velZ);
    }

    public void readSpawnData(ByteBuf data) {
        super.readSpawnData(data);
        this.velX = data.readDouble();
        this.velZ = data.readDouble();
    }
}

