/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.handler;

import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.entity.ai.EntitySummonAIFollowOwner;
import com.windanesz.ancientspellcraft.item.ItemNewArtefact;
import com.windanesz.ancientspellcraft.potion.PotionMetamagicEffect;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftEnchantments;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftPotions;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftSpells;
import com.windanesz.ancientspellcraft.spell.Martyr;
import com.windanesz.ancientspellcraft.spell.MetaSpellBuff;
import com.windanesz.ancientspellcraft.spell.TimeKnot;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.entity.living.EntitySkeletonMinion;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.event.SpellBindEvent;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.integration.DamageSafetyChecker;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.potion.Curse;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.ImbueWeapon;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.spell.SpellBuff;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.IElementalDamage;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WandHelper;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class ASEventHandler {
    public static final IStoredVariable<Integer> COUNTDOWN_KEY = IStoredVariable.StoredVariable.ofInt((String)"artefactEternityCountdown", (Persistence)Persistence.NEVER).withTicker(ASEventHandler::update);
    public static final IStoredVariable<Integer> SPELL_ID = IStoredVariable.StoredVariable.ofInt((String)"artefactEternitySpell", (Persistence)Persistence.ALWAYS);

    private ASEventHandler() {
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        if (event.getSource() != null && event.getSource().func_76346_g() instanceof EntityLivingBase) {
            int level;
            EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
            World world = event.getEntityLiving().field_70170_p;
            if (!attacker.func_184614_ca().func_190926_b() && ImbueWeapon.isSword((ItemStack)attacker.func_184614_ca()) && (level = EnchantmentHelper.func_77506_a((Enchantment)AncientSpellcraftEnchantments.static_charge, (ItemStack)attacker.func_184614_ca())) > 0 && event.getEntityLiving().field_70170_p.field_72995_K) {
                for (int i = 0; i < 5; ++i) {
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARK, (Entity)event.getEntityLiving()).spawn(event.getEntityLiving().field_70170_p);
                }
            }
        }
    }

    private static void onMetaMagicFinished(EntityPlayer player, Spell spell, Potion effect) {
        ASEventHandler.setCooldown(player, spell);
        player.func_184589_d(effect);
    }

    private static void setCooldown(EntityPlayer player, Spell spell) {
        List<ItemStack> wands = ASUtils.getAllHotbarWands(player);
        if (wands != null && !wands.isEmpty()) {
            for (ItemStack wand : wands) {
                int index = 0;
                for (Spell currentSpell : WandHelper.getSpells((ItemStack)wand)) {
                    int[] cooldowns = WandHelper.getCooldowns((ItemStack)wand);
                    if (cooldowns.length == 0) {
                        int count = WandHelper.getSpells((ItemStack)wand).length - 1;
                        cooldowns = new int[count];
                    }
                    if (currentSpell == spell) {
                        int[] maxCooldowns = WandHelper.getMaxCooldowns((ItemStack)wand);
                        if (maxCooldowns.length == 0) {
                            int count = WandHelper.getSpells((ItemStack)wand).length - 1;
                            maxCooldowns = new int[count];
                        }
                        cooldowns[index] = 1200;
                        maxCooldowns[index] = 1200;
                        WandHelper.setCooldowns((ItemStack)wand, (int[])cooldowns);
                        WandHelper.setMaxCooldowns((ItemStack)wand, (int[])maxCooldowns);
                    }
                    ++index;
                }
            }
        }
    }

    private static int update(EntityPlayer player, Integer countdown) {
        if (countdown == null) {
            return 0;
        }
        if (!player.field_70170_p.field_72995_K) {
            WizardData data = WizardData.get((EntityPlayer)player);
            Integer spellId = (Integer)data.getVariable(SPELL_ID);
            if (spellId == null) {
                return 0;
            }
            Spell spell = Spell.byMetadata((int)spellId);
            if (countdown != 1 || ItemArtefact.findMatchingWandAndCast((EntityPlayer)player, (Spell)spell)) {
                // empty if block
            }
            if (countdown > 0) {
                Integer n = countdown;
                Integer n2 = countdown = Integer.valueOf(countdown - 1);
            }
        }
        return countdown;
    }

    @SubscribeEvent
    public static void onLivingHurtEvent(LivingHurtEvent event) {
        int level;
        EntityLivingBase attacker;
        WizardData data;
        EntityPlayer player;
        if (event.getEntity() instanceof EntityPlayer) {
            player = (EntityPlayer)event.getEntity();
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                if (artefact == AncientSpellcraftItems.amulet_time_knot && player.func_70644_a(AncientSpellcraftPotions.time_knot) && player.func_110143_aJ() - event.getAmount() <= 0.0f) {
                    TimeKnot.loopPlayer(player);
                    player.func_70066_B();
                    if (!player.field_70170_p.field_72995_K) {
                        Iterator iterator = player.func_193076_bZ().values().iterator();
                    }
                }
                if (artefact == AncientSpellcraftItems.charm_cryostasis) {
                    if (!(player.func_110143_aJ() <= 6.0f) && !(player.func_110143_aJ() - event.getAmount() <= 6.0f) || !(player.field_70170_p.field_73012_v.nextFloat() < 0.25f)) continue;
                    AncientSpellcraftSpells.cryostasis.cast(player.field_70170_p, player, player.func_184600_cs(), 0, new SpellModifiers());
                    continue;
                }
                if (artefact == AncientSpellcraftItems.ring_berserker) {
                    if (player.field_70170_p.field_72995_K || !(player.func_110143_aJ() <= 6.0f) && !(player.func_110143_aJ() - event.getAmount() <= 6.0f) || player.func_70644_a(MobEffects.field_76420_g)) continue;
                    player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 300));
                    continue;
                }
                if (artefact != AncientSpellcraftItems.amulet_rabbit || player.field_70170_p.field_72995_K || !(player.field_70170_p.field_73012_v.nextFloat() < 0.25f)) continue;
                if (!player.func_70644_a(MobEffects.field_76424_c)) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 200));
                }
                if (player.func_70644_a(MobEffects.field_76437_t)) continue;
                player.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 200, 1));
            }
        }
        if (!(event.getEntity().field_70170_p.field_72995_K || !event.getEntityLiving().func_70644_a(AncientSpellcraftPotions.martyr_beneficial) || !(event.getEntityLiving() instanceof EntityPlayer) || event.getSource().func_76363_c() || event.getSource() instanceof IElementalDamage && ((IElementalDamage)event.getSource()).isRetaliatory() || (data = WizardData.get((EntityPlayer)(player = (EntityPlayer)event.getEntityLiving()))) == null)) {
            Iterator<UUID> iterator = Martyr.getMartyrBoundEntities(data).iterator();
            while (iterator.hasNext()) {
                Entity entity = EntityUtils.getEntityByUUID((World)player.field_70170_p, (UUID)iterator.next());
                if (entity == null) {
                    iterator.remove();
                }
                if (!(entity instanceof EntityPlayer) || !((EntityPlayer)entity).func_70644_a(AncientSpellcraftPotions.martyr)) continue;
                if (DamageSafetyChecker.attackEntitySafely((Entity)entity, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)player, (MagicDamage.DamageType)MagicDamage.DamageType.MAGIC, (boolean)true), (float)event.getAmount(), (String)event.getSource().func_76355_l(), (DamageSource)DamageSource.field_76376_m, (boolean)false)) {
                    entity.func_184185_a(WizardrySounds.SPELL_CURSE_OF_SOULBINDING_RETALIATE, 1.0f, player.field_70170_p.field_73012_v.nextFloat() * 0.2f + 1.0f);
                }
                event.setCanceled(true);
            }
        }
        if (event.getSource().func_76346_g() instanceof EntityLivingBase && !(attacker = (EntityLivingBase)event.getSource().func_76346_g()).func_184614_ca().func_190926_b() && ImbueWeapon.isSword((ItemStack)attacker.func_184614_ca()) && (level = EnchantmentHelper.func_77506_a((Enchantment)AncientSpellcraftEnchantments.static_charge, (ItemStack)attacker.func_184614_ca())) > 0 && !MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.SHOCK, (Entity)event.getEntityLiving())) {
            event.setAmount(event.getAmount() + (float)(level * 2));
        }
    }

    @SubscribeEvent
    public static void onPotionApplicableEvent(PotionEvent.PotionApplicableEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                if (artefact == AncientSpellcraftItems.amulet_poison_resistance) {
                    if (event.getPotionEffect().func_188419_a() != MobEffects.field_76436_u || !(player.field_70170_p.field_73012_v.nextFloat() < 0.5f)) continue;
                    event.setResult(Event.Result.DENY);
                    continue;
                }
                if (artefact != AncientSpellcraftItems.amulet_curse_ward || !(event.getPotionEffect().func_188419_a() instanceof Curse)) continue;
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPotionRemoveEvent(PotionEvent.PotionRemoveEvent event) {
        if (event.getPotion() == AncientSpellcraftPotions.magical_exhaustion) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPotionExpiryEvent(PotionEvent.PotionExpiryEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                ItemStack pendant;
                Spell spell;
                if (artefact != AncientSpellcraftItems.amulet_pendant_of_eternity || ASEventHandler.getArtefactItemStack(player, (ItemArtefact)AncientSpellcraftItems.amulet_pendant_of_eternity) == null || (spell = ASEventHandler.getCurrentSpellFromSpellBearingArtefact(AncientSpellcraftItems.amulet_pendant_of_eternity, pendant = ASEventHandler.getArtefactItemStack(player, (ItemArtefact)AncientSpellcraftItems.amulet_pendant_of_eternity))) == Spells.none || !(spell instanceof SpellBuff)) continue;
                try {
                    SpellBuff obj = (SpellBuff)spell;
                    Field field = ASUtils.ReflectionUtil.getField(obj.getClass(), "potionSet");
                    ASUtils.ReflectionUtil.makeAccessible(field);
                    Set potionset = (Set)field.get(obj);
                    if (!potionset.contains(event.getPotionEffect().func_188419_a())) continue;
                    WizardData data = WizardData.get((EntityPlayer)player);
                    data.setVariable(COUNTDOWN_KEY, (Object)20);
                    data.setVariable(SPELL_ID, (Object)spell.metadata());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        EntityLivingBase entity;
        EntityPlayer player;
        if (event.getSource().func_76346_g() instanceof EntityPlayer && event.getEntity() instanceof EntityLivingBase && ((EntityLivingBase)event.getEntity()).func_70662_br() && ItemArtefact.isArtefactActive((EntityPlayer)(player = (EntityPlayer)event.getSource().func_76346_g()), (Item)AncientSpellcraftItems.charm_reanimation) && !event.getEntityLiving().field_70170_p.field_72995_K && player.field_70170_p.field_73012_v.nextFloat() < 0.15f && ((entity = event.getEntityLiving()) instanceof EntitySkeleton || entity instanceof EntityZombie)) {
            EntitySkeletonMinion skeletonMinion = new EntitySkeletonMinion(entity.field_70170_p);
            skeletonMinion.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            skeletonMinion.setCaster((EntityLivingBase)player);
            skeletonMinion.setLifetime(600);
            if (entity.func_184592_cb().func_77973_b() instanceof ItemBow || entity.func_184614_ca().func_77973_b() instanceof ItemBow) {
                skeletonMinion.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
            } else {
                skeletonMinion.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151041_m));
            }
            skeletonMinion.func_184642_a(EntityEquipmentSlot.MAINHAND, 0.0f);
            entity.field_70170_p.func_72838_d((Entity)skeletonMinion);
        }
    }

    @SubscribeEvent
    public static void onProjectileImpactArrowEvent(ProjectileImpactEvent.Arrow event) {
        if (!event.getArrow().field_70170_p.field_72995_K && event.getArrow().field_70250_c != null && event.getArrow().field_70250_c instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getArrow().field_70250_c;
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                EntityLivingBase target;
                if (artefact != AncientSpellcraftItems.ring_poison_arrow || !(player.field_70170_p.field_73012_v.nextFloat() < 0.2f) || event.getRayTraceResult().field_72308_g == null || !(event.getRayTraceResult().field_72308_g instanceof EntityLivingBase) || (target = (EntityLivingBase)event.getRayTraceResult().field_72308_g).func_70644_a(MobEffects.field_76436_u)) continue;
                target.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 100));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onSpellCastPreEvent(SpellCastEvent.Pre event) {
        if (event.getCaster() instanceof EntityPlayer) {
            EntityPlayer player;
            if (!(event.getSpell() instanceof MetaSpellBuff)) {
                player = (EntityPlayer)event.getCaster();
                HashMap potionEffectMap = new HashMap();
                Map potionEffects = player.func_193076_bZ();
                potionEffectMap.putAll(potionEffects);
                for (Map.Entry entry : potionEffectMap.entrySet()) {
                    SpellModifiers modifiers;
                    Potion potion = (Potion)entry.getKey();
                    if (potion instanceof PotionMetamagicEffect) {
                        int level;
                        PotionEffect effect;
                        if (potion.equals(AncientSpellcraftPotions.arcane_augmentation)) {
                            effect = (PotionEffect)entry.getValue();
                            SpellModifiers modifiers2 = event.getModifiers();
                            float range = modifiers2.get(WizardryItems.range_upgrade);
                            float blast = modifiers2.get(WizardryItems.blast_upgrade);
                            level = effect.func_76458_c() + 1;
                            if (level > 0) {
                                modifiers2.set(WizardryItems.range_upgrade, blast + (float)level * 0.25f, true);
                                modifiers2.set(WizardryItems.blast_upgrade, range + (float)level * 0.25f, true);
                            }
                            ASEventHandler.onMetaMagicFinished(player, AncientSpellcraftSpells.arcane_augmentation, AncientSpellcraftPotions.arcane_augmentation);
                        } else if (potion.equals(AncientSpellcraftPotions.intensifying_focus)) {
                            effect = (PotionEffect)entry.getValue();
                            SpellModifiers modifiers3 = event.getModifiers();
                            float potency = modifiers3.get("potency");
                            float range = modifiers3.get(WizardryItems.range_upgrade);
                            float blast = modifiers3.get(WizardryItems.range_upgrade);
                            int level2 = effect.func_76458_c() + 1;
                            if (level2 > 0) {
                                modifiers3.set("potency", potency + (float)level2 * 0.15f, true);
                                modifiers3.set(WizardryItems.range_upgrade, blast - (float)level2 * 0.25f, true);
                                modifiers3.set(WizardryItems.blast_upgrade, range - (float)level2 * 0.25f, true);
                            }
                            ASEventHandler.setCooldown(player, AncientSpellcraftSpells.intensifying_focus);
                            player.func_184589_d(AncientSpellcraftPotions.intensifying_focus);
                            ASEventHandler.onMetaMagicFinished(player, AncientSpellcraftSpells.intensifying_focus, AncientSpellcraftPotions.intensifying_focus);
                        } else if (potion.equals(AncientSpellcraftPotions.continuity_charm)) {
                            effect = (PotionEffect)entry.getValue();
                            SpellModifiers modifiers4 = event.getModifiers();
                            float duration = modifiers4.get(WizardryItems.duration_upgrade);
                            float cost = modifiers4.get("cost");
                            level = effect.func_76458_c() + 1;
                            if (level > 0) {
                                modifiers4.set(WizardryItems.duration_upgrade, duration + (float)level * 0.25f, true);
                                modifiers4.set("cost", cost + (float)level * 0.15f, true);
                            }
                            ASEventHandler.onMetaMagicFinished(player, AncientSpellcraftSpells.continuity_charm, AncientSpellcraftPotions.continuity_charm);
                        }
                    }
                    if (potion == AncientSpellcraftPotions.spell_blast) {
                        modifiers = event.getModifiers();
                        float blast = modifiers.get(WizardryItems.blast_upgrade);
                        modifiers.set(WizardryItems.blast_upgrade, blast + 0.25f, true);
                    }
                    if (potion == AncientSpellcraftPotions.spell_range) {
                        modifiers = event.getModifiers();
                        float range = modifiers.get(WizardryItems.range_upgrade);
                        modifiers.set(WizardryItems.range_upgrade, range + 0.25f, true);
                    }
                    if (potion == AncientSpellcraftPotions.spell_cooldown) {
                        modifiers = event.getModifiers();
                        float cooldown = modifiers.get(WizardryItems.cooldown_upgrade);
                        modifiers.set(WizardryItems.cooldown_upgrade, cooldown - 0.15f, true);
                    }
                    if (potion != AncientSpellcraftPotions.spell_duration) continue;
                    modifiers = event.getModifiers();
                    float duration = modifiers.get(WizardryItems.duration_upgrade);
                    modifiers.set(WizardryItems.duration_upgrade, duration + 0.25f, false);
                }
            }
            player = (EntityPlayer)event.getCaster();
            SpellModifiers modifiers = event.getModifiers();
            int jewelsSetCount = 0;
            if (ItemNewArtefact.isNewArtefactActive(player, AncientSpellcraftItems.belt_enchanter) && event.getSpell().getType() == SpellType.BUFF) {
                modifiers.set(WizardryItems.duration_upgrade, modifiers.get(WizardryItems.duration_upgrade) * 1.2f, false);
            }
            for (ItemNewArtefact itemNewArtefact : ItemNewArtefact.getActiveNewArtefacts(player, new ItemNewArtefact.AdditionalType[0])) {
                if (itemNewArtefact != AncientSpellcraftItems.head_curse) continue;
                float potency = modifiers.get("potency");
                int modifier = 0;
                for (Potion potion : player.func_193076_bZ().keySet()) {
                    if (!(potion instanceof Curse)) continue;
                    modifier = (int)((double)modifier + 0.1);
                }
                if (modifier < 0) continue;
                modifiers.set("potency", (float)(1 + modifier) * potency, false);
            }
            for (ItemArtefact itemArtefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                float potency = modifiers.get("potency");
                float cost = modifiers.get("cost");
                if (itemArtefact == AncientSpellcraftItems.charm_mana_orb) {
                    modifiers.set("cost", 0.85f * cost, false);
                } else if (itemArtefact == AncientSpellcraftItems.amulet_mana) {
                    modifiers.set("cost", 0.9f * cost, false);
                } else if (itemArtefact == AncientSpellcraftItems.ring_blast) {
                    modifiers.set("cost", 1.25f * cost, false);
                    event.getModifiers().set(WizardryItems.blast_upgrade, event.getModifiers().get(WizardryItems.blast_upgrade) + 0.25f, true);
                } else if (itemArtefact == AncientSpellcraftItems.ring_range) {
                    modifiers.set("cost", 1.25f * cost, false);
                    event.getModifiers().set(WizardryItems.range_upgrade, event.getModifiers().get(WizardryItems.range_upgrade) + 0.25f, true);
                } else if (itemArtefact == AncientSpellcraftItems.charm_elemental_grimoire) {
                    if (event.getSpell().getElement() == Element.FIRE || event.getSpell().getElement() == Element.ICE || event.getSpell().getElement() == Element.LIGHTNING) {
                        modifiers.set("potency", 0.1f + potency, false);
                    }
                } else if (itemArtefact == AncientSpellcraftItems.charm_earth_orb) {
                    if (event.getSpell().getElement() == Element.EARTH) {
                        modifiers.set("potency", 0.01f * (float)Settings.generalSettings.orb_artefact_potency_bonus + potency, false);
                    } else {
                        modifiers.set("potency", -0.5f + potency, false);
                    }
                } else if (itemArtefact == AncientSpellcraftItems.charm_healing_orb) {
                    if (event.getSpell().getElement() == Element.HEALING) {
                        modifiers.set("potency", 0.01f * (float)Settings.generalSettings.orb_artefact_potency_bonus + potency, false);
                    } else {
                        modifiers.set("potency", -0.5f + potency, false);
                    }
                } else if (itemArtefact == AncientSpellcraftItems.charm_lightning_orb) {
                    if (event.getSpell().getElement() == Element.LIGHTNING) {
                        modifiers.set("potency", 0.01f * (float)Settings.generalSettings.orb_artefact_potency_bonus + potency, false);
                    } else {
                        modifiers.set("potency", -0.5f + potency, false);
                    }
                } else if (itemArtefact == AncientSpellcraftItems.charm_fire_orb) {
                    if (event.getSpell().getElement() == Element.FIRE) {
                        modifiers.set("potency", 0.01f * (float)Settings.generalSettings.orb_artefact_potency_bonus + potency, false);
                    } else {
                        modifiers.set("potency", -0.5f + potency, false);
                    }
                } else if (itemArtefact == AncientSpellcraftItems.charm_ice_orb) {
                    if (event.getSpell().getElement() == Element.ICE) {
                        modifiers.set("potency", 0.01f * (float)Settings.generalSettings.orb_artefact_potency_bonus + potency, false);
                    } else {
                        modifiers.set("potency", -0.5f + potency, false);
                    }
                } else if (itemArtefact == AncientSpellcraftItems.charm_necromancy_orb) {
                    if (event.getSpell().getElement() == Element.NECROMANCY) {
                        modifiers.set("potency", 0.01f * (float)Settings.generalSettings.orb_artefact_potency_bonus + potency, false);
                    } else {
                        modifiers.set("potency", -0.5f + potency, false);
                    }
                } else if (itemArtefact == AncientSpellcraftItems.charm_sorcery_orb) {
                    if (event.getSpell().getElement() == Element.SORCERY) {
                        modifiers.set("potency", 0.01f * (float)Settings.generalSettings.orb_artefact_potency_bonus + potency, false);
                    } else {
                        modifiers.set("potency", -0.5f + potency, false);
                    }
                }
                if (itemArtefact == AncientSpellcraftItems.ring_power) {
                    ++jewelsSetCount;
                    modifiers.set("potency", 0.05f + potency, false);
                    modifiers.set("cost", 0.05f + cost, false);
                    continue;
                }
                if (itemArtefact == AncientSpellcraftItems.amulet_power) {
                    ++jewelsSetCount;
                    modifiers.set("potency", 0.1f + potency, false);
                    modifiers.set("cost", 0.1f + cost, false);
                    continue;
                }
                if (itemArtefact != AncientSpellcraftItems.charm_power_orb) continue;
                ++jewelsSetCount;
                modifiers.set("potency", 0.2f + potency, false);
                modifiers.set("cost", 0.2f + cost, false);
            }
            if (jewelsSetCount > 1) {
                float potency = modifiers.get("potency");
                float f = (float)(jewelsSetCount - 1) * 5.0f / 100.0f;
                modifiers.set("potency", f + potency, false);
            }
        }
    }

    @SubscribeEvent
    public static void onSpellCastPostEvent(SpellCastEvent.Post event) {
        EntityPlayer player;
        if (event.getCaster() instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)(player = (EntityPlayer)event.getCaster()), (Item)AncientSpellcraftItems.charm_knowledge_orb)) {
            boolean flag = false;
            if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() instanceof ItemWand) {
                if (((ItemWand)player.func_184614_ca().func_77973_b()).tier.level == Tier.MASTER.level) {
                    flag = true;
                }
            } else if (!player.func_184592_cb().func_190926_b() && player.func_184592_cb().func_77973_b() instanceof ItemWand && ((ItemWand)player.func_184592_cb().func_77973_b()).tier.level == Tier.MASTER.level) {
                flag = true;
            }
            if (flag) {
                int progression = (int)((float)event.getSpell().getCost() * event.getModifiers().get("progression"));
                List<ItemStack> wands = ASUtils.getAllHotbarWands(player, Tier.ADVANCED);
                if (wands != null && !wands.isEmpty()) {
                    ItemStack targetWand = ASUtils.getRandomListItem(wands);
                    WandHelper.addProgression((ItemStack)targetWand, (int)progression);
                    Tier nextTier = Tier.values()[((ItemWand)targetWand.func_77973_b()).tier.ordinal() + 1];
                    int excess = WandHelper.getProgression((ItemStack)targetWand) - nextTier.getProgression();
                    if (excess >= 0 && excess < progression) {
                        player.func_184185_a(WizardrySounds.ITEM_WAND_LEVELUP, 1.25f, 1.0f);
                        if (!player.field_70170_p.field_72995_K) {
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("item.ebwizardry:wand.levelup", new Object[]{targetWand.func_77973_b().func_77653_i(targetWand), nextTier.getNameForTranslationFormatted()}));
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onArcaneWorkbenchApplyButtonPressed(SpellBindEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K) {
            int centre_slot = 9;
            int upgrade_slot = 10;
            ItemStack centre = event.getContainer().func_75139_a(centre_slot).func_75211_c();
            ItemStack upgrade = event.getContainer().func_75139_a(upgrade_slot).func_75211_c();
            EntityPlayer player = event.getEntityPlayer();
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                if (artefact != AncientSpellcraftItems.charm_wand_upgrade || !(player.field_70170_p.field_73012_v.nextFloat() < 0.2f) || !WandHelper.isWandUpgrade((Item)upgrade.func_77973_b()) || !(centre.func_77973_b() instanceof ItemWand)) continue;
                Item specialUpgrade = upgrade.func_77973_b();
                if (WandHelper.getTotalUpgrades((ItemStack)centre) >= ((ItemWand)centre.func_77973_b()).tier.upgradeLimit || WandHelper.getUpgradeLevel((ItemStack)centre, (Item)specialUpgrade) >= 3) continue;
                player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:will_o_wisp.tag_has_no_name", new Object[0]), true);
                player.func_191521_c(new ItemStack(specialUpgrade));
            }
        }
    }

    private static ItemStack getArtefactItemStack(EntityPlayer player, ItemArtefact artefact) {
        return ASUtils.getItemStackFromInventoryHotbar(player, (Item)artefact);
    }

    private static Spell getCurrentSpellFromSpellBearingArtefact(Item item, ItemStack stack) {
        return Spell.byMetadata((int)stack.func_77952_i());
    }

    @SubscribeEvent
    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            EntityPlayer player = event.player;
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                float i;
                if (artefact != AncientSpellcraftItems.ring_prismarine || !player.func_70027_ad() || (i = player.func_184811_cZ().func_185143_a(AncientSpellcraftItems.ring_prismarine, 0.0f)) != 0.0f) continue;
                player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 120));
                SpellModifiers modifiers = new SpellModifiers();
                if (!AncientSpellcraftSpells.extinguish.cast(player.field_70170_p, player, EnumHand.MAIN_HAND, 0, modifiers)) continue;
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.SCROLL, AncientSpellcraftSpells.extinguish, (EntityLivingBase)player, modifiers));
                player.func_184811_cZ().func_185145_a(AncientSpellcraftItems.ring_prismarine, 1200);
            }
        }
    }

    @SubscribeEvent
    public static void onCheckSpawnEvent(EntityJoinWorldEvent event) {
        Entity owner;
        if (event.getEntity() instanceof ISummonedCreature && event.getEntity() instanceof EntityCreature && ((ISummonedCreature)event.getEntity()).func_70902_q() != null && (owner = ((ISummonedCreature)event.getEntity()).func_70902_q()) instanceof EntityPlayer && ItemNewArtefact.isNewArtefactActive((EntityPlayer)owner, AncientSpellcraftItems.head_minions) && ItemNewArtefact.isNewArtefactActive((EntityPlayer)owner, AncientSpellcraftItems.head_minions)) {
            EntityCreature creature = (EntityCreature)event.getEntity();
            EntitySummonAIFollowOwner task = new EntitySummonAIFollowOwner(creature, 1.0, 10.0f, 2.0f);
            creature.field_70714_bg.func_75776_a(5, (EntityAIBase)task);
        }
    }

    static {
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{COUNTDOWN_KEY, SPELL_ID});
    }
}

